/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import au.com.objectix.jgridshift.GridShift;
import au.com.objectix.jgridshift.GridShiftFile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.geotools.referencing.factory.gridshift.NTv2GridShiftFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;

public class NTv2Transform
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final long serialVersionUID = -3082112044314062512L;
    protected static final Logger LOGGER = Logging.getLogger(NTv2Transform.class);
    private URI grid = null;
    private URL gridLocation = null;
    private GridShiftFile gridShift;
    private static NTv2GridShiftFactory FACTORY = new NTv2GridShiftFactory();
    private transient MathTransform2D inverse;

    public NTv2Transform(URI file) throws NoSuchIdentifierException {
        if (file == null) {
            throw new NoSuchIdentifierException("No NTv2 Grid File specified.", null);
        }
        this.grid = file;
        this.gridLocation = this.locateGrid(this.grid.toString());
        if (this.gridLocation == null) {
            throw new NoSuchIdentifierException("Could not locate NTv2 Grid File " + file, null);
        }
        if (!FACTORY.isNTv2Grid(this.gridLocation)) {
            throw new NoSuchIdentifierException("NTv2 Grid File not available.", file.toString());
        }
    }

    URL locateGrid(String grid) {
        for (GridShiftLocator locator : ReferencingFactoryFinder.getGridShiftLocators(null)) {
            URL result = locator.locateGrid(grid);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.grid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            NTv2Transform that = (NTv2Transform)object;
            return Utilities.equals(this.getParameterValues(), that.getParameterValues());
        }
        return false;
    }

    @Override
    public synchronized MathTransform2D inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.bidirectionalTransform(srcPts, srcOff, dstPts, dstOff, numPts, true);
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.bidirectionalTransform(srcPts, srcOff, dstPts, dstOff, numPts, false);
    }

    private void bidirectionalTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, boolean forward) throws TransformException {
        if (this.gridShift == null) {
            try {
                this.gridShift = FACTORY.createNTv2Grid(this.gridLocation);
            }
            catch (FactoryException e) {
                throw new TransformException("NTv2 Grid " + this.gridLocation + " Could not be created", e);
            }
        }
        try {
            GridShift shift = new GridShift();
            while (--numPts >= 0) {
                shift.setLonPositiveEastDegrees(srcPts[srcOff++]);
                shift.setLatDegrees(srcPts[srcOff++]);
                boolean shifted = forward ? this.gridShift.gridShiftForward(shift) : this.gridShift.gridShiftReverse(shift);
                if (shifted) {
                    dstPts[dstOff++] = shift.getShiftedLonPositiveEastDegrees();
                    dstPts[dstOff++] = shift.getShiftedLatDegrees();
                    continue;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Point (" + srcPts[srcOff - 2] + ", " + srcPts[srcOff - 1] + ") is not covered by '" + this.grid + "' NTv2 grid, it will not be shifted.");
                }
                dstPts[dstOff++] = srcPts[srcOff - 2];
                dstPts[dstOff++] = srcPts[srcOff - 1];
            }
        }
        catch (IOException e) {
            throw new TransformException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameter<URI> file = new Parameter<URI>(Provider.FILE);
        file.setValue(this.grid);
        return new ParameterGroup(Provider.PARAMETERS, (GeneralParameterValue[])new ParameterValue[]{file});
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -3710592152744574801L;
        public static final DefaultParameterDescriptor<URI> FILE = new DefaultParameterDescriptor<Object>(Provider.toMap(new NamedIdentifier(Citations.EPSG, "Latitude and longitude difference file"), new NamedIdentifier(Citations.EPSG, "8656")), URI.class, null, null, null, null, null, true);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "NTv2"), new NamedIdentifier(Citations.EPSG, "9615")}, new ParameterDescriptor[]{FILE});

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
            return new NTv2Transform(Provider.value(FILE, values));
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D,
    Serializable {
        private static final long serialVersionUID = -4707304160205218546L;

        public Inverse() {
            super(NTv2Transform.this);
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return null;
        }

        @Override
        public void transform(double[] source, int srcOffset, double[] dest, int dstOffset, int length) throws TransformException {
            NTv2Transform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        @Override
        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            NTv2Transform.this.inverse = this;
        }
    }
}

