/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotools.measure.Units;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.metadata.iso.quality.AbsoluteExternalPositionalAccuracyImpl;
import org.geotools.metadata.iso.quality.QuantitativeResultImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.factory.AbstractCachedAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.epsg.AuthorityCodes;
import org.geotools.referencing.factory.epsg.AxisName;
import org.geotools.referencing.factory.epsg.BursaWolfInfo;
import org.geotools.referencing.factory.epsg.CoordinateOperationSet;
import org.geotools.referencing.factory.epsg.TableInfo;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.TableWriter;
import org.geotools.util.Version;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import si.uom.NonSI;
import si.uom.SI;

public abstract class AbstractEpsgFactory
extends AbstractCachedAuthorityFactory {
    private static final int BURSA_WOLF_MIN_CODE = 9603;
    private static final int BURSA_WOLF_MAX_CODE = 9607;
    private static final int ROTATION_FRAME_CODE = 9607;
    private static final int DUMMY_OPERATION = 1;
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational(223);
    private transient Citation authority;
    protected DataSource dataSource;
    private Connection connection;
    private final Map<String, PreparedStatement> statements = new IdentityHashMap<String, PreparedStatement>();
    private int lastObjectType = -1;
    private transient String lastTableForName;
    private final Map<String, AxisName> axisNames = new HashMap<String, AxisName>();
    private final Map<String, Short> axisCounts = new HashMap<String, Short>();
    private final Map<String, Boolean> codeProjection = new HashMap<String, Boolean>();
    private final Map<String, LocalName> scopes = new HashMap<String, LocalName>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> safetyGuard = new HashSet<String>();
    private static final TableInfo[] TABLES_INFO = new TableInfo[]{new TableInfo(CoordinateReferenceSystem.class, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "COORD_REF_SYS_KIND", new Class[]{ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class}, new String[]{"projected", "geographic", "geocentric"}), new TableInfo(CoordinateSystem.class, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME", "COORD_SYS_TYPE", new Class[]{CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, VerticalCS.class}, new String[]{"Cartesian", "ellipsoidal", "spherical", "vertical"}), new TableInfo(CoordinateSystemAxis.class, "[Coordinate Axis] AS CA INNER JOIN [Coordinate Axis Name] AS CAN ON CA.COORD_AXIS_NAME_CODE=CAN.COORD_AXIS_NAME_CODE", "COORD_AXIS_CODE", "COORD_AXIS_NAME"), new TableInfo(Datum.class, "[Datum]", "DATUM_CODE", "DATUM_NAME", "DATUM_TYPE", new Class[]{GeodeticDatum.class, VerticalDatum.class, EngineeringDatum.class}, new String[]{"geodetic", "vertical", "engineering"}), new TableInfo(Ellipsoid.class, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME"), new TableInfo(PrimeMeridian.class, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME"), new TableInfo(CoordinateOperation.class, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME", "COORD_OP_TYPE", new Class[]{Projection.class, Conversion.class, Transformation.class}, new String[]{"conversion", "conversion", "transformation"}), new TableInfo(OperationMethod.class, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME"), new TableInfo(ParameterDescriptor.class, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME"), new TableInfo(Unit.class, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME")};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractEpsgFactory(Hints userHints) throws FactoryException {
        super(80);
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        if (userHints == null) throw new FactoryException("A EPSG_DATA_SOURCE hint is required.");
        Object hint = userHints.get(Hints.EPSG_DATA_SOURCE);
        if (hint instanceof String) {
            String name = (String)hint;
            try {
                this.dataSource = (DataSource)GeoTools.getInitialContext(userHints).lookup(name);
            }
            catch (NamingException e) {
                throw new FactoryException("A EPSG_DATA_SOURCE hint is required:" + e);
            }
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.dataSource);
            return;
        }
        if (!(hint instanceof DataSource)) throw new FactoryException("A EPSG_DATA_SOURCE hint is required.");
        this.dataSource = (DataSource)hint;
        this.hints.put(Hints.EPSG_DATA_SOURCE, this.dataSource);
    }

    public AbstractEpsgFactory(Hints userHints, DataSource dataSource) {
        super(80);
        this.dataSource = dataSource;
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        this.hints.put(Hints.EPSG_DATA_SOURCE, dataSource);
    }

    public AbstractEpsgFactory(Hints userHints, Connection connection) {
        super(80, userHints);
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        this.connection = connection;
        AbstractEpsgFactory.ensureNonNull("connection", connection);
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            try {
                String query = this.adaptSQL("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC");
                DatabaseMetaData metadata = this.getConnection().getMetaData();
                try (Statement statement = this.getConnection().createStatement();
                     ResultSet result = statement.executeQuery(query);){
                    if (result.next()) {
                        String version = result.getString(1);
                        Date date = result.getDate(2);
                        String engine = metadata.getDatabaseProductName();
                        CitationImpl c = new CitationImpl(Citations.EPSG);
                        c.getAlternateTitles().add(Vocabulary.formatInternational(37, "EPSG", version, engine));
                        c.setEdition(new SimpleInternationalString(version));
                        c.setEditionDate(date);
                        this.authority = (Citation)((Object)c.unmodifiable());
                        this.hints.put(Hints.VERSION, new Version(version));
                    } else {
                        this.authority = Citations.EPSG;
                    }
                }
            }
            catch (SQLException exception) {
                Logging.unexpectedException(LOGGER, AbstractEpsgFactory.class, "getAuthority", exception);
                return Citations.EPSG;
            }
        }
        return this.authority;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getBackingStoreDescription() throws FactoryException {
        Citation authority = this.getAuthority();
        try (TableWriter table = new TableWriter(null, " ");){
            Vocabulary resources = Vocabulary.getResources(null);
            InternationalString cs = authority.getEdition();
            if (cs != null) {
                table.write(resources.getString(239, "EPSG"));
                table.write(58);
                table.nextColumn();
                table.write(cs.toString());
                table.nextLine();
            }
            try {
                DatabaseMetaData metadata = this.getConnection().getMetaData();
                String s = metadata.getDatabaseProductName();
                if (s != null) {
                    table.write(resources.getLabel(35));
                    table.nextColumn();
                    table.write(s);
                    s = metadata.getDatabaseProductVersion();
                    if (s != null) {
                        table.write(32);
                        table.write(resources.getString(238, s));
                    }
                    table.nextLine();
                }
                if ((s = metadata.getURL()) != null) {
                    table.write(resources.getLabel(36));
                    table.nextColumn();
                    table.write(s);
                    table.nextLine();
                }
            }
            catch (SQLException exception) {
                throw new FactoryException(exception);
            }
            String string = table.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (this.authority == null) {
            this.getAuthority();
        }
        return super.getImplementationHints();
    }

    @Override
    protected synchronized Set<String> generateAuthorityCodes(Class type) throws FactoryException {
        HashSet<String> result = new HashSet<String>();
        for (TableInfo table : TABLES_INFO) {
            if (!table.isTypeOf(type)) continue;
            AuthorityCodeSet codes = new AuthorityCodeSet(table, type);
            result.addAll(codes);
        }
        return result;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        IdentifiedObject identifiedObject = this.createObject(code);
        ReferenceIdentifier identifier = identifiedObject.getName();
        if (identifier instanceof GenericName) {
            return ((GenericName)((Object)identifier)).toInternationalString();
        }
        return new SimpleInternationalString(identifier.getCode());
    }

    private PreparedStatement prepareStatement(String key, String sql) throws SQLException {
        assert (Thread.holdsLock(this));
        PreparedStatement stmt = this.statements.get(key);
        if (stmt == null) {
            stmt = this.getConnection().prepareStatement(this.adaptSQL(sql));
            this.statements.put(key, stmt);
        }
        return stmt;
    }

    private static String getString(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        String value = result.getString(columnIndex);
        AbstractEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value.trim();
    }

    private static String getString(ResultSet result, int columnIndex, String code, int columnFault) throws SQLException, FactoryException {
        String str = result.getString(columnIndex);
        if (result.wasNull()) {
            ResultSetMetaData metadata = result.getMetaData();
            String column = metadata.getColumnName(columnFault);
            String table = metadata.getTableName(columnFault);
            result.close();
            throw new FactoryException(Errors.format(147, code, column, table));
        }
        return str.trim();
    }

    private static double getDouble(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        double value = result.getDouble(columnIndex);
        AbstractEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value;
    }

    private static int getInt(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        int value = result.getInt(columnIndex);
        AbstractEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value;
    }

    private static void ensureNonNull(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        if (result.wasNull()) {
            ResultSetMetaData metadata = result.getMetaData();
            String column = metadata.getColumnName(columnIndex);
            String table = metadata.getTableName(columnIndex);
            result.close();
            throw new FactoryException(Errors.format(147, code, column, table));
        }
    }

    private String toPrimaryKey(Class type, String code, String table, String codeColumn, String nameColumn) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        String identifier = this.trimAuthority(code);
        if (!this.isPrimaryKey(identifier)) {
            String KEY = "NumericalIdentifier";
            PreparedStatement statement = this.statements.get("NumericalIdentifier");
            if (statement != null && !table.equals(this.lastTableForName)) {
                this.statements.remove("NumericalIdentifier");
                statement.close();
                statement = null;
                this.lastTableForName = null;
            }
            if (statement == null) {
                String query = "SELECT " + codeColumn + " FROM " + table + " WHERE " + nameColumn + " = ?";
                statement = this.getConnection().prepareStatement(this.adaptSQL(query));
                this.statements.put("NumericalIdentifier", statement);
            }
            statement.setString(1, identifier);
            identifier = null;
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    identifier = AbstractEpsgFactory.ensureSingleton(result.getString(1), identifier, code);
                }
            }
            if (identifier == null) {
                throw this.noSuchAuthorityCode(type, code);
            }
        }
        return identifier;
    }

    private static <T> T ensureSingleton(T newValue, T oldValue, String code) throws FactoryException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryException(Errors.format(44, code));
    }

    private Map<String, Object> generateProperties(String name, String code, String remarks) throws SQLException, FactoryException {
        this.properties.clear();
        Citation authority = this.getAuthority();
        if (name != null) {
            this.properties.put("name", new NamedIdentifier(authority, name.trim()));
        }
        if (code != null) {
            InternationalString edition = authority.getEdition();
            String version = edition != null ? edition.toString() : null;
            this.properties.put("identifiers", new NamedIdentifier(authority, code.trim(), version));
        }
        if (remarks != null && (remarks = remarks.trim()).length() != 0) {
            this.properties.put("remarks", remarks);
        }
        ArrayList<LocalName> alias = null;
        PreparedStatement stmt = this.prepareStatement("Alias", "SELECT NAMING_SYSTEM_NAME, ALIAS FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_CODE = ?");
        stmt.setString(1, code);
        try (ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                org.geotools.util.GenericName generic;
                String scope = result.getString(1);
                String local = AbstractEpsgFactory.getString(result, 2, code);
                if (scope == null) {
                    generic = new LocalName(local);
                } else {
                    LocalName cached = this.scopes.get(scope);
                    if (cached == null) {
                        cached = new LocalName(scope);
                        this.scopes.put(scope, cached);
                    }
                    generic = new ScopedName(cached, local);
                }
                if (alias == null) {
                    alias = new ArrayList<LocalName>();
                }
                alias.add((LocalName)generic);
            }
        }
        if (alias != null) {
            this.properties.put("alias", alias.toArray(new GenericName[alias.size()]));
        }
        return this.properties;
    }

    private Map<String, Object> generateProperties(String name, String code, String area, String scope, String remarks) throws SQLException, FactoryException {
        Map<String, Object> properties = this.generateProperties(name, code, remarks);
        if (area != null && (area = area.trim()).length() != 0) {
            Extent extent = this.generateExtent(area);
            properties.put("domainOfValidity", extent);
        }
        if (scope != null && (scope = scope.trim()).length() != 0) {
            properties.put("scope", scope);
        }
        return properties;
    }

    @Override
    public synchronized IdentifiedObject generateObject(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        String KEY = "IdentifiedObject";
        PreparedStatement stmt = this.statements.get("IdentifiedObject");
        StringBuilder query = null;
        String epsg = this.trimAuthority(code);
        boolean isPrimaryKey = this.isPrimaryKey(epsg);
        int tupleToSkip = isPrimaryKey ? this.lastObjectType : -1;
        int index = -1;
        for (int i = -1; i < TABLES_INFO.length; ++i) {
            if (i == tupleToSkip) continue;
            try {
                if (i >= 0) {
                    String column;
                    TableInfo table = TABLES_INFO[i];
                    String string = column = isPrimaryKey ? table.codeColumn : table.nameColumn;
                    if (column == null) continue;
                    if (query == null) {
                        query = new StringBuilder("SELECT ");
                    }
                    query.setLength(7);
                    query.append(table.codeColumn);
                    query.append(" FROM ");
                    query.append(table.table);
                    query.append(" WHERE ");
                    query.append(column);
                    query.append(" = ?");
                    if (isPrimaryKey) {
                        assert (!this.statements.containsKey("IdentifiedObject")) : table;
                        stmt = this.prepareStatement("IdentifiedObject", query.toString());
                    } else {
                        stmt = this.getConnection().prepareStatement(this.adaptSQL(query.toString()));
                    }
                }
                stmt.setString(1, epsg);
                try (ResultSet result = stmt.executeQuery();){
                    boolean present = result.next();
                    if (present) {
                        if (index >= 0) {
                            throw new FactoryException(Errors.format(44, code));
                        }
                        int n = index = i < 0 ? this.lastObjectType : i;
                        if (isPrimaryKey) {
                            break;
                        }
                    }
                }
                if (isPrimaryKey && this.statements.remove("IdentifiedObject") == null) {
                    throw new AssertionError((Object)code);
                }
                stmt.close();
                continue;
            }
            catch (SQLException exception) {
                throw AbstractEpsgFactory.databaseFailure(IdentifiedObject.class, code, exception);
            }
        }
        if (isPrimaryKey) {
            this.lastObjectType = index;
        }
        if (index >= 0) {
            switch (index) {
                case 0: {
                    return this.createCoordinateReferenceSystem(code);
                }
                case 1: {
                    return this.createCoordinateSystem(code);
                }
                case 2: {
                    return this.createCoordinateSystemAxis(code);
                }
                case 3: {
                    return this.createDatum(code);
                }
                case 4: {
                    return this.createEllipsoid(code);
                }
                case 5: {
                    return this.createPrimeMeridian(code);
                }
                case 6: {
                    return this.createCoordinateOperation(code);
                }
                case 7: {
                    return this.generateOperationMethod(code);
                }
                case 8: {
                    return this.generateParameterDescriptor(code);
                }
                case 9: {
                    break;
                }
                default: {
                    throw new AssertionError(index);
                }
            }
        }
        return super.createObject(code);
    }

    @Override
    public synchronized Unit<?> generateUnit(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        Unit returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Unit.class, code, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME");
            PreparedStatement stmt = this.prepareStatement("Unit", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE FROM [Unit of Measure] WHERE UOM_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    int source = AbstractEpsgFactory.getInt(result, 1, code);
                    double b = result.getDouble(2);
                    double c = result.getDouble(3);
                    int target = AbstractEpsgFactory.getInt(result, 4, code);
                    Unit<?> base = AbstractEpsgFactory.getUnit(target);
                    if (base == null) {
                        throw this.noSuchAuthorityCode(Unit.class, String.valueOf(target));
                    }
                    Unit<?> unit = AbstractEpsgFactory.getUnit(source);
                    if (unit == null) {
                        if (b != 0.0 && c != 0.0) {
                            unit = b == c ? base : base.multiply(b / c);
                        } else {
                            throw new FactoryException("Unsupported unit: " + code);
                        }
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(unit, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(Unit.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Unit.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Ellipsoid generateEllipsoid(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        Ellipsoid returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Ellipsoid.class, code, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME");
            PreparedStatement stmt = this.prepareStatement("Ellipsoid", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    Ellipsoid ellipsoid;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    double semiMajorAxis = AbstractEpsgFactory.getDouble(result, 3, code);
                    double inverseFlattening = result.getDouble(4);
                    double semiMinorAxis = result.getDouble(5);
                    String unitCode = AbstractEpsgFactory.getString(result, 6, code);
                    String remarks = result.getString(7);
                    Unit<Length> unit = this.createUnit(unitCode);
                    Map<String, Object> properties = this.generateProperties(name, epsg, remarks);
                    if (inverseFlattening == 0.0) {
                        if (semiMinorAxis == 0.0) {
                            String column = result.getMetaData().getColumnName(3);
                            result.close();
                            throw new FactoryException(Errors.format(147, code, column));
                        }
                        ellipsoid = this.factories.getDatumFactory().createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
                    } else {
                        if (semiMinorAxis != 0.0) {
                            LogRecord record = Loggings.format(Level.WARNING, 1, code);
                            record.setLoggerName(LOGGER.getName());
                            LOGGER.log(record);
                        }
                        ellipsoid = this.factories.getDatumFactory().createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(ellipsoid, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(Ellipsoid.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized PrimeMeridian generatePrimeMeridian(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        PrimeMeridian returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(PrimeMeridian.class, code, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME");
            PreparedStatement stmt = this.prepareStatement("PrimeMeridian", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    double longitude = AbstractEpsgFactory.getDouble(result, 3, code);
                    String unit_code = AbstractEpsgFactory.getString(result, 4, code);
                    String remarks = result.getString(5);
                    Unit<Angle> unit = this.createUnit(unit_code);
                    Map<String, Object> properties = this.generateProperties(name, epsg, remarks);
                    PrimeMeridian primeMeridian = this.factories.getDatumFactory().createPrimeMeridian(properties, longitude, unit);
                    returnValue = AbstractEpsgFactory.ensureSingleton(primeMeridian, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(PrimeMeridian.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code);
        }
        return returnValue;
    }

    public synchronized Extent generateExtent(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        Extent returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Extent.class, code, "[Area]", "AREA_CODE", "AREA_NAME");
            PreparedStatement stmt = this.prepareStatement("Area", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    ExtentImpl extent = null;
                    String description = result.getString(1);
                    if (description != null) {
                        extent = new ExtentImpl();
                        extent.setDescription(new SimpleInternationalString(description));
                    }
                    double ymin = result.getDouble(2);
                    if (!result.wasNull()) {
                        double ymax = result.getDouble(3);
                        if (!result.wasNull()) {
                            double xmin = result.getDouble(4);
                            if (!result.wasNull()) {
                                double xmax = result.getDouble(5);
                                if (!result.wasNull()) {
                                    if (extent == null) {
                                        extent = new ExtentImpl();
                                    }
                                    extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(xmin, xmax, ymin, ymax)));
                                }
                            }
                        }
                    }
                    if (extent == null) continue;
                    returnValue = AbstractEpsgFactory.ensureSingleton(extent.unmodifiable(), returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(Extent.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Extent.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] generateBursaWolfParameters(String code, ResultSet toClose) throws SQLException, FactoryException {
        if (this.safetyGuard.contains(code)) {
            return null;
        }
        PreparedStatement stmt = this.prepareStatement("BursaWolfParametersSet", "SELECT CO.COORD_OP_CODE, CO.COORD_OP_METHOD_CODE, CRS2.DATUM_CODE FROM [Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS CRS2 ON CO.TARGET_CRS_CODE = CRS2.COORD_REF_SYS_CODE WHERE CO.COORD_OP_METHOD_CODE >= 9603 AND CO.COORD_OP_METHOD_CODE <= 9607 AND CO.COORD_OP_CODE <> 1 AND CO.SOURCE_CRS_CODE IN ( SELECT CRS1.COORD_REF_SYS_CODE  FROM [Coordinate Reference System] AS CRS1  WHERE CRS1.DATUM_CODE = ?) ORDER BY CRS2.DATUM_CODE, ABS(CO.DEPRECATED), CO.COORD_OP_ACCURACY, CO.COORD_OP_CODE DESC");
        stmt.setString(1, code);
        ArrayList<BursaWolfInfo> bwInfos = null;
        try (ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                String operation = AbstractEpsgFactory.getString(result, 1, code);
                int method = AbstractEpsgFactory.getInt(result, 2, code);
                String datum = AbstractEpsgFactory.getString(result, 3, code);
                if (bwInfos == null) {
                    bwInfos = new ArrayList<BursaWolfInfo>();
                }
                bwInfos.add(new BursaWolfInfo(operation, method, datum));
            }
        }
        if (bwInfos == null) {
            return null;
        }
        toClose.close();
        int size = bwInfos.size();
        if (size > 1) {
            Object[] codes = bwInfos.toArray(new BursaWolfInfo[size]);
            this.sort(codes);
            bwInfos.clear();
            HashSet<String> added = new HashSet<String>();
            for (Object candidate : codes) {
                if (!added.add(((BursaWolfInfo)candidate).target)) continue;
                bwInfos.add((BursaWolfInfo)candidate);
            }
            size = bwInfos.size();
        }
        stmt = this.prepareStatement("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?");
        for (int i = 0; i < size; ++i) {
            GeodeticDatum datum;
            BursaWolfInfo info = (BursaWolfInfo)bwInfos.get(i);
            try {
                this.safetyGuard.add(code);
                datum = this.createGeodeticDatum(info.target);
            }
            finally {
                this.safetyGuard.remove(code);
            }
            BursaWolfParameters parameters = new BursaWolfParameters(datum);
            stmt.setString(1, info.operation);
            stmt.setInt(2, info.method);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    AbstractEpsgFactory.setBursaWolfParameter(parameters, AbstractEpsgFactory.getInt(result, 1, info.operation), AbstractEpsgFactory.getDouble(result, 2, info.operation), this.createUnit(AbstractEpsgFactory.getString(result, 3, info.operation)));
                }
            }
            if (info.method == 9607) {
                parameters.ex = -parameters.ex;
                parameters.ey = -parameters.ey;
                parameters.ey = -parameters.ey;
            }
            bwInfos.set(i, (BursaWolfInfo)((Object)parameters));
        }
        return bwInfos.toArray(new BursaWolfParameters[size]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Datum generateDatum(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        Datum returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Datum.class, code, "[Datum]", "DATUM_CODE", "DATUM_NAME");
            PreparedStatement stmt = this.prepareStatement("Datum", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                boolean exit = false;
                while (result.next()) {
                    Datum datum;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String type = AbstractEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                    String anchor = result.getString(4);
                    Date epoch = result.getDate(5);
                    String area = result.getString(6);
                    String scope = result.getString(7);
                    String remarks = result.getString(8);
                    Map<String, Object> properties = this.generateProperties(name, epsg, area, scope, remarks);
                    if (anchor != null) {
                        properties.put("anchorPoint", anchor);
                    }
                    if (epoch != null) {
                        try {
                            properties.put("realizationEpoch", epoch);
                        }
                        catch (NumberFormatException exception) {
                            Logging.unexpectedException(LOGGER, AbstractEpsgFactory.class, "createDatum", exception);
                        }
                    }
                    DatumFactory factory = this.factories.getDatumFactory();
                    if (type.equals("geodetic")) {
                        properties = new HashMap<String, Object>(properties);
                        Ellipsoid ellipsoid = this.createEllipsoid(AbstractEpsgFactory.getString(result, 9, code));
                        PrimeMeridian meridian = this.createPrimeMeridian(AbstractEpsgFactory.getString(result, 10, code));
                        BursaWolfParameters[] param = this.generateBursaWolfParameters(primaryKey, result);
                        if (param != null) {
                            exit = true;
                            properties.put("bursaWolf", param);
                        }
                        datum = factory.createGeodeticDatum(properties, ellipsoid, meridian);
                    } else if (type.equals("vertical")) {
                        datum = factory.createVerticalDatum(properties, VerticalDatumType.GEOIDAL);
                    } else {
                        if (!type.equals("engineering")) {
                            result.close();
                            throw new FactoryException(Errors.format(187, type));
                        }
                        datum = factory.createEngineeringDatum(properties);
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(datum, returnValue, code);
                    if (!exit) continue;
                    Datum datum2 = returnValue;
                    return datum2;
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(Datum.class, code, exception);
        }
        if (returnValue != null) return returnValue;
        throw this.noSuchAuthorityCode(Datum.class, code);
    }

    private AxisName getAxisName(String code) throws FactoryException {
        assert (Thread.holdsLock(this));
        AxisName returnValue = this.axisNames.get(code);
        if (returnValue == null) {
            try {
                PreparedStatement stmt = this.prepareStatement("AxisName", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM [Coordinate Axis Name] WHERE COORD_AXIS_NAME_CODE = ?");
                stmt.setString(1, code);
                try (ResultSet result = stmt.executeQuery();){
                    while (result.next()) {
                        String name = AbstractEpsgFactory.getString(result, 1, code);
                        String description = result.getString(2);
                        String remarks = result.getString(3);
                        if (description == null) {
                            description = remarks;
                        } else if (remarks != null) {
                            description = description + System.getProperty("line.separator", "\n") + remarks;
                        }
                        AxisName axis = new AxisName(name, description);
                        returnValue = AbstractEpsgFactory.ensureSingleton(axis, returnValue, code);
                    }
                }
                if (returnValue == null) {
                    throw this.noSuchAuthorityCode(AxisName.class, code);
                }
                this.axisNames.put(code, returnValue);
            }
            catch (SQLException exception) {
                throw AbstractEpsgFactory.databaseFailure(AxisName.class, code, exception);
            }
        }
        return returnValue;
    }

    @Override
    public synchronized CoordinateSystemAxis generateCoordinateSystemAxis(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        CoordinateSystemAxis returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Axis", "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM [Coordinate Axis] WHERE COORD_AXIS_CODE = ?");
            stmt.setString(1, code);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    AxisDirection direction;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String nameCode = AbstractEpsgFactory.getString(result, 2, code);
                    String orientation = AbstractEpsgFactory.getString(result, 3, code);
                    String abbreviation = AbstractEpsgFactory.getString(result, 4, code);
                    String unit = AbstractEpsgFactory.getString(result, 5, code);
                    try {
                        direction = DefaultCoordinateSystemAxis.getDirection(orientation);
                    }
                    catch (NoSuchElementException exception) {
                        if (orientation.equalsIgnoreCase("Geocentre > equator/PM")) {
                            direction = AxisDirection.OTHER;
                        }
                        if (orientation.equalsIgnoreCase("Geocentre > equator/90dE")) {
                            direction = AxisDirection.EAST;
                        }
                        if (orientation.equalsIgnoreCase("Geocentre > north pole")) {
                            direction = AxisDirection.NORTH;
                        }
                        throw new FactoryException(exception);
                    }
                    AxisName an = this.getAxisName(nameCode);
                    Map<String, Object> properties = this.generateProperties(an.name, epsg, an.description);
                    CSFactory factory = this.factories.getCSFactory();
                    CoordinateSystemAxis axis = factory.createCoordinateSystemAxis(properties, abbreviation, direction, this.createUnit(unit));
                    returnValue = AbstractEpsgFactory.ensureSingleton(axis, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(CoordinateSystemAxis.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code);
        }
        return returnValue;
    }

    private CoordinateSystemAxis[] generateAxisForCoordinateSystem(String code, int dimension) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[dimension];
        PreparedStatement stmt = this.prepareStatement("AxisOrder", "SELECT COORD_AXIS_CODE FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ? ORDER BY [ORDER]");
        stmt.setString(1, code);
        int i = 0;
        try (ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                String axisCode = AbstractEpsgFactory.getString(result, 1, code);
                if (i < axis.length) {
                    axis[i] = this.createCoordinateSystemAxis(axisCode);
                }
                ++i;
            }
        }
        if (i != axis.length) {
            throw new FactoryException(Errors.format(93, axis.length, i));
        }
        return axis;
    }

    @Override
    public synchronized CoordinateSystem generateCoordinateSystem(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        CoordinateSystem returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(CoordinateSystem.class, code, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME");
            PreparedStatement stmt = this.prepareStatement("CoordinateSystem", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS FROM [Coordinate System] WHERE COORD_SYS_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String type = AbstractEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                    int dimension = AbstractEpsgFactory.getInt(result, 4, code);
                    String remarks = result.getString(5);
                    CoordinateSystemAxis[] axis = this.generateAxisForCoordinateSystem(primaryKey, dimension);
                    Map<String, Object> properties = this.generateProperties(name, epsg, remarks);
                    CSFactory factory = this.factories.getCSFactory();
                    CoordinateSystem cs = null;
                    if (type.equals("ellipsoidal")) {
                        switch (dimension) {
                            case 2: {
                                cs = factory.createEllipsoidalCS(properties, axis[0], axis[1]);
                                break;
                            }
                            case 3: {
                                cs = factory.createEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
                            }
                        }
                    } else if (type.equals("cartesian")) {
                        switch (dimension) {
                            case 2: {
                                cs = factory.createCartesianCS(properties, axis[0], axis[1]);
                                break;
                            }
                            case 3: {
                                cs = factory.createCartesianCS(properties, axis[0], axis[1], axis[2]);
                            }
                        }
                    } else if (type.equals("spherical")) {
                        switch (dimension) {
                            case 3: {
                                cs = factory.createSphericalCS(properties, axis[0], axis[1], axis[2]);
                            }
                        }
                    } else if (type.equals("vertical") || type.equals("gravity-related")) {
                        switch (dimension) {
                            case 1: {
                                cs = factory.createVerticalCS(properties, axis[0]);
                            }
                        }
                    } else if (type.equals("linear")) {
                        switch (dimension) {
                            case 1: {
                                cs = factory.createLinearCS(properties, axis[0]);
                            }
                        }
                    } else if (type.equals("polar")) {
                        switch (dimension) {
                            case 2: {
                                cs = factory.createPolarCS(properties, axis[0], axis[1]);
                            }
                        }
                    } else if (type.equals("cylindrical")) {
                        switch (dimension) {
                            case 3: {
                                cs = factory.createCylindricalCS(properties, axis[0], axis[1], axis[2]);
                            }
                        }
                    } else if (type.equals("affine")) {
                        switch (dimension) {
                            case 2: {
                                cs = factory.createAffineCS(properties, axis[0], axis[1]);
                                break;
                            }
                            case 3: {
                                cs = factory.createAffineCS(properties, axis[0], axis[1], axis[2]);
                            }
                        }
                    } else {
                        result.close();
                        throw new FactoryException(Errors.format(187, type));
                    }
                    if (cs == null) {
                        result.close();
                        throw new FactoryException(Errors.format(173, type));
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(cs, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(CoordinateSystem.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code);
        }
        return returnValue;
    }

    private String toPrimaryKeyCRS(String code) throws SQLException, FactoryException {
        return this.toPrimaryKey(CoordinateReferenceSystem.class, code, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateReferenceSystem generateCoordinateReferenceSystem(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        CoordinateReferenceSystem returnValue = null;
        try {
            String primaryKey = this.toPrimaryKeyCRS(code);
            PreparedStatement stmt = this.prepareStatement("CoordinateReferenceSystem", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?");
            stmt.setString(1, primaryKey);
            boolean exit = false;
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    CoordinateReferenceSystem crs;
                    Map<String, Object> properties;
                    Datum datum;
                    CoordinateSystem cs;
                    String dmCode;
                    String csCode;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String area = result.getString(3);
                    String scope = result.getString(4);
                    String remarks = result.getString(5);
                    String type = AbstractEpsgFactory.getString(result, 6, code);
                    CRSFactory factory = this.factories.getCRSFactory();
                    if (type.equalsIgnoreCase("geographic 2D") || type.equalsIgnoreCase("geographic 3D")) {
                        csCode = AbstractEpsgFactory.getString(result, 7, code);
                        dmCode = result.getString(8);
                        cs = this.createEllipsoidalCS(csCode);
                        if (dmCode != null) {
                            datum = this.createGeodeticDatum(dmCode);
                        } else {
                            String geoCode = AbstractEpsgFactory.getString(result, 9, code, 8);
                            result.close();
                            exit = true;
                            GeographicCRS baseCRS = this.createGeographicCRS(geoCode);
                            datum = baseCRS.getDatum();
                        }
                        properties = this.generateProperties(name, epsg, area, scope, remarks);
                        crs = factory.createGeographicCRS(properties, (GeodeticDatum)datum, (EllipsoidalCS)cs);
                    } else if (type.equalsIgnoreCase("projected")) {
                        csCode = AbstractEpsgFactory.getString(result, 7, code);
                        String geoCode = AbstractEpsgFactory.getString(result, 9, code);
                        String opCode = AbstractEpsgFactory.getString(result, 10, code);
                        result.close();
                        exit = true;
                        CartesianCS cs2 = this.createCartesianCS(csCode);
                        GeographicCRS baseCRS = this.createGeographicCRS(geoCode);
                        CoordinateOperation op = this.createCoordinateOperation(opCode);
                        if (!(op instanceof Conversion)) throw this.noSuchAuthorityCode(Projection.class, opCode);
                        Map<String, Object> properties2 = this.generateProperties(name, epsg, area, scope, remarks);
                        crs = factory.createProjectedCRS(properties2, baseCRS, (Conversion)op, cs2);
                    } else if (type.equalsIgnoreCase("vertical")) {
                        csCode = AbstractEpsgFactory.getString(result, 7, code);
                        dmCode = AbstractEpsgFactory.getString(result, 8, code);
                        cs = this.createVerticalCS(csCode);
                        datum = this.createVerticalDatum(dmCode);
                        properties = this.generateProperties(name, epsg, area, scope, remarks);
                        crs = factory.createVerticalCRS(properties, (VerticalDatum)datum, (VerticalCS)cs);
                    } else if (type.equalsIgnoreCase("compound")) {
                        CoordinateReferenceSystem crs2;
                        CoordinateReferenceSystem crs1;
                        String code1 = AbstractEpsgFactory.getString(result, 11, code);
                        String code2 = AbstractEpsgFactory.getString(result, 12, code);
                        result.close();
                        exit = true;
                        if (!this.safetyGuard.add(epsg)) {
                            throw AbstractEpsgFactory.recursiveCall(CompoundCRS.class, epsg);
                        }
                        try {
                            crs1 = this.createCoordinateReferenceSystem(code1);
                            crs2 = this.createCoordinateReferenceSystem(code2);
                        }
                        finally {
                            this.safetyGuard.remove(epsg);
                        }
                        properties = this.generateProperties(name, epsg, area, scope, remarks);
                        crs = factory.createCompoundCRS(properties, crs1, crs2);
                    } else if (type.equalsIgnoreCase("geocentric")) {
                        csCode = AbstractEpsgFactory.getString(result, 7, code);
                        dmCode = AbstractEpsgFactory.getString(result, 8, code);
                        cs = this.createCoordinateSystem(csCode);
                        datum = this.createGeodeticDatum(dmCode);
                        properties = this.generateProperties(name, epsg, area, scope, remarks);
                        if (cs instanceof CartesianCS) {
                            crs = factory.createGeocentricCRS((Map<String, ?>)properties, (GeodeticDatum)datum, (CartesianCS)cs);
                        } else {
                            if (!(cs instanceof SphericalCS)) {
                                result.close();
                                throw new FactoryException(Errors.format(63, cs.getClass(), GeocentricCRS.class));
                            }
                            crs = factory.createGeocentricCRS((Map<String, ?>)properties, (GeodeticDatum)datum, (SphericalCS)cs);
                        }
                    } else {
                        if (!type.equalsIgnoreCase("engineering")) {
                            result.close();
                            throw new FactoryException(Errors.format(187, type));
                        }
                        csCode = AbstractEpsgFactory.getString(result, 7, code);
                        dmCode = AbstractEpsgFactory.getString(result, 8, code);
                        cs = this.createCoordinateSystem(csCode);
                        datum = this.createEngineeringDatum(dmCode);
                        properties = this.generateProperties(name, epsg, area, scope, remarks);
                        crs = factory.createEngineeringCRS(properties, (EngineeringDatum)datum, cs);
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(crs, returnValue, code);
                    if (!exit) continue;
                    CoordinateReferenceSystem coordinateReferenceSystem = returnValue;
                    return coordinateReferenceSystem;
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(CoordinateReferenceSystem.class, code, exception);
        }
        if (returnValue != null) return returnValue;
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
    }

    public synchronized ParameterDescriptor<?> generateParameterDescriptor(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        ParameterDescriptor returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(ParameterDescriptor.class, code, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME");
            PreparedStatement stmt = this.prepareStatement("ParameterDescriptor", "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION FROM [Coordinate_Operation Parameter] WHERE PARAMETER_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    Class<Double> type;
                    Unit<?> unit;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String remarks = result.getString(3);
                    PreparedStatement units = this.prepareStatement("ParameterUnit", "SELECT MIN(UOM_CODE) AS UOM, MIN(PARAM_VALUE_FILE_REF) AS FILEREF FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC");
                    units.setString(1, epsg);
                    try (ResultSet resultUnits = units.executeQuery();){
                        if (resultUnits.next()) {
                            String element = resultUnits.getString(1);
                            unit = element != null ? this.createUnit(element) : null;
                            element = resultUnits.getString(2);
                            type = element != null && element.trim().length() != 0 ? URI.class : Double.TYPE;
                        } else {
                            unit = null;
                            type = Double.TYPE;
                        }
                    }
                    Map<String, Object> properties = this.generateProperties(name, epsg, remarks);
                    DefaultParameterDescriptor<Object> descriptor = new DefaultParameterDescriptor<Object>(properties, type, null, null, null, null, unit, true);
                    returnValue = AbstractEpsgFactory.ensureSingleton(descriptor, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(OperationMethod.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private ParameterDescriptor[] generateParameterDescriptors(String method) throws FactoryException, SQLException {
        PreparedStatement stmt = this.prepareStatement("ParameterDescriptors", "SELECT PARAMETER_CODE FROM [Coordinate_Operation Parameter Usage] WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER");
        stmt.setString(1, method);
        try (ResultSet results = stmt.executeQuery();){
            ArrayList descriptors = new ArrayList();
            while (results.next()) {
                String param = AbstractEpsgFactory.getString(results, 1, method);
                descriptors.add(this.generateParameterDescriptor(param));
            }
            ParameterDescriptor[] parameterDescriptorArray = descriptors.toArray(new ParameterDescriptor[descriptors.size()]);
            return parameterDescriptorArray;
        }
    }

    /*
     * Exception decompiling
     */
    private void fillParameterValues(String method, String operation, ParameterValueGroup parameters) throws FactoryException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 16[WHILELOOP]], but top level block is 21[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized OperationMethod generateOperationMethod(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        OperationMethod returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(OperationMethod.class, code, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME");
            PreparedStatement stmt = this.prepareStatement("OperationMethod", "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, FORMULA, REMARKS FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?");
            stmt.setString(1, primaryKey);
            try (ResultSet result = stmt.executeQuery();){
                DefaultOperationMethod method = null;
                while (result.next()) {
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String formula = result.getString(3);
                    String remarks = result.getString(4);
                    int encoded = this.getDimensionsForMethod(epsg);
                    int sourceDimensions = encoded >>> 16;
                    int targetDimensions = encoded & 0xFFFF;
                    GeneralParameterDescriptor[] descriptors = this.generateParameterDescriptors(epsg);
                    Map<String, Object> properties = this.generateProperties(name, epsg, remarks);
                    if (formula != null) {
                        properties.put("formula", formula);
                    }
                    method = new DefaultOperationMethod(properties, sourceDimensions, targetDimensions, new DefaultParameterDescriptorGroup(properties, descriptors));
                    returnValue = AbstractEpsgFactory.ensureSingleton(method, returnValue, code);
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(OperationMethod.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private int getDimensionsForMethod(String code) throws SQLException {
        Dimensions temp;
        PreparedStatement stmt = this.prepareStatement("MethodDimensions", "SELECT SOURCE_CRS_CODE, TARGET_CRS_CODE FROM [Coordinate_Operation] WHERE COORD_OP_METHOD_CODE = ? AND SOURCE_CRS_CODE IS NOT NULL AND TARGET_CRS_CODE IS NOT NULL");
        stmt.setString(1, code);
        HashMap<Dimensions, Dimensions> dimensions = new HashMap<Dimensions, Dimensions>();
        Dimensions max = temp = new Dimensions(131074);
        try (ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                short sourceDimensions = this.getDimensionForCRS(result.getString(1));
                short targetDimensions = this.getDimensionForCRS(result.getString(2));
                temp.encoded = sourceDimensions << 16 | targetDimensions;
                Dimensions candidate = (Dimensions)dimensions.get(temp);
                if (candidate == null) {
                    candidate = new Dimensions(temp.encoded);
                    dimensions.put(candidate, candidate);
                }
                if (++candidate.occurences <= max.occurences) continue;
                max = candidate;
            }
        }
        return max.encoded;
    }

    private short getDimensionForCRS(String code) throws SQLException {
        short dimension;
        Short cached = this.axisCounts.get(code);
        if (cached == null) {
            PreparedStatement stmt = this.prepareStatement("Dimension", "  SELECT COUNT(COORD_AXIS_CODE) FROM [Coordinate Axis] WHERE COORD_SYS_CODE = (SELECT COORD_SYS_CODE  FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?)");
            stmt.setString(1, code);
            try (ResultSet result = stmt.executeQuery();){
                dimension = result.next() ? (short)result.getShort(1) : (short)2;
                this.axisCounts.put(code, dimension);
            }
        } else {
            dimension = cached;
        }
        return dimension;
    }

    final synchronized boolean isProjection(String code) throws SQLException {
        Boolean projection = this.codeProjection.get(code);
        if (projection == null) {
            PreparedStatement stmt = this.prepareStatement("isProjection", "SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE PROJECTION_CONV_CODE = ? AND COORD_REF_SYS_KIND LIKE 'projected%'");
            stmt.setString(1, code);
            try (ResultSet result = stmt.executeQuery();){
                boolean found = result.next();
                projection = found;
                this.codeProjection.put(code, projection);
            }
        }
        return projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateOperation generateCoordinateOperation(String code) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("code", code);
        CoordinateOperation returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(CoordinateOperation.class, code, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME");
            PreparedStatement stmt = this.prepareStatement("CoordinateOperation", "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?");
            stmt.setString(1, primaryKey);
            boolean exit = false;
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    CoordinateOperation operation;
                    ParameterValueGroup parameters;
                    OperationMethod method;
                    boolean isBursaWolf;
                    int targetDimensions;
                    CoordinateReferenceSystem targetCRS;
                    int sourceDimensions;
                    CoordinateReferenceSystem sourceCRS;
                    String targetCode;
                    String sourceCode;
                    String epsg = AbstractEpsgFactory.getString(result, 1, code);
                    String name = AbstractEpsgFactory.getString(result, 2, code);
                    String type = AbstractEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                    boolean isTransformation = type.equals("transformation");
                    boolean isConversion = type.equals("conversion");
                    boolean isConcatenated = type.equals("concatenated operation");
                    if (isConversion) {
                        sourceCode = result.getString(4);
                        targetCode = result.getString(5);
                    } else {
                        sourceCode = AbstractEpsgFactory.getString(result, 4, code);
                        targetCode = AbstractEpsgFactory.getString(result, 5, code);
                    }
                    String methodCode = isConcatenated ? result.getString(6) : AbstractEpsgFactory.getString(result, 6, code);
                    String version = result.getString(7);
                    double accuracy = result.getDouble(8);
                    if (result.wasNull()) {
                        accuracy = Double.NaN;
                    }
                    String area = result.getString(9);
                    String scope = result.getString(10);
                    String remarks = result.getString(11);
                    if (sourceCode != null) {
                        sourceCRS = this.createCoordinateReferenceSystem(sourceCode);
                        sourceDimensions = sourceCRS.getCoordinateSystem().getDimension();
                    } else {
                        sourceCRS = null;
                        sourceDimensions = 2;
                    }
                    if (targetCode != null) {
                        targetCRS = this.createCoordinateReferenceSystem(targetCode);
                        targetDimensions = targetCRS.getCoordinateSystem().getDimension();
                    } else {
                        targetCRS = null;
                        targetDimensions = 2;
                    }
                    if (methodCode == null) {
                        isBursaWolf = false;
                        method = null;
                        parameters = null;
                    } else {
                        int num;
                        try {
                            num = Integer.parseInt(methodCode);
                        }
                        catch (NumberFormatException exception) {
                            result.close();
                            throw new FactoryException(exception);
                        }
                        isBursaWolf = num >= 9603 && num <= 9607;
                        method = this.generateOperationMethod(methodCode);
                        if (method.getSourceDimensions() != sourceDimensions || method.getTargetDimensions() != targetDimensions) {
                            method = new DefaultOperationMethod(method, sourceDimensions, targetDimensions);
                        }
                        String classe = method.getName().getCode();
                        parameters = this.factories.getMathTransformFactory().getDefaultParameters(classe);
                        this.fillParameterValues(methodCode, epsg, parameters);
                    }
                    Map<String, Object> properties = this.generateProperties(name, epsg, area, scope, remarks);
                    if (version != null && (version = version.trim()).length() != 0) {
                        properties.put("operationVersion", version);
                    }
                    if (!Double.isNaN(accuracy)) {
                        QuantitativeResultImpl accuracyResult = new QuantitativeResultImpl(new double[]{accuracy});
                        accuracyResult.setValueUnit(SI.METRE);
                        AbsoluteExternalPositionalAccuracyImpl accuracyElement = new AbsoluteExternalPositionalAccuracyImpl(accuracyResult);
                        accuracyElement.setMeasureDescription(TRANSFORMATION_ACCURACY);
                        accuracyElement.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
                        properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{(PositionalAccuracy)((Object)accuracyElement.unmodifiable())});
                    }
                    if (isConversion && (sourceCRS == null || targetCRS == null)) {
                        operation = new DefiningConversion(properties, method, parameters);
                    } else {
                        Class expected;
                        if (isConcatenated) {
                            result.close();
                            exit = true;
                            PreparedStatement cstmt = this.prepareStatement("ConcatenatedOperation", "SELECT SINGLE_OPERATION_CODE FROM [Coordinate_Operation Path] WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP");
                            cstmt.setString(1, epsg);
                            ArrayList<String> codes = new ArrayList<String>();
                            try (ResultSet cr = cstmt.executeQuery();){
                                while (cr.next()) {
                                    codes.add(cr.getString(1));
                                }
                            }
                            CoordinateOperation[] operations = new CoordinateOperation[codes.size()];
                            if (!this.safetyGuard.add(epsg)) {
                                throw AbstractEpsgFactory.recursiveCall(ConcatenatedOperation.class, epsg);
                            }
                            try {
                                for (int i = 0; i < operations.length; ++i) {
                                    operations[i] = this.createCoordinateOperation((String)codes.get(i));
                                }
                            }
                            finally {
                                this.safetyGuard.remove(epsg);
                            }
                            try {
                                DefaultConcatenatedOperation i = new DefaultConcatenatedOperation(properties, operations);
                                return i;
                            }
                            catch (IllegalArgumentException exception) {
                                throw new FactoryException(exception);
                            }
                        }
                        if (isBursaWolf) {
                            try {
                                Unit<Length> axisUnit;
                                Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(sourceCRS);
                                if (ellipsoid != null) {
                                    axisUnit = ellipsoid.getAxisUnit();
                                    parameters.parameter("src_semi_major").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                                    parameters.parameter("src_semi_minor").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
                                    parameters.parameter("src_dim").setValue(sourceCRS.getCoordinateSystem().getDimension());
                                }
                                if ((ellipsoid = CRSUtilities.getHeadGeoEllipsoid(targetCRS)) != null) {
                                    axisUnit = ellipsoid.getAxisUnit();
                                    parameters.parameter("tgt_semi_major").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                                    parameters.parameter("tgt_semi_minor").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
                                    parameters.parameter("tgt_dim").setValue(targetCRS.getCoordinateSystem().getDimension());
                                }
                            }
                            catch (ParameterNotFoundException exception) {
                                result.close();
                                throw new FactoryException(Errors.format(52, method.getName().getCode(), exception));
                            }
                        }
                        if (isTransformation) {
                            expected = Transformation.class;
                        } else {
                            if (!isConversion) {
                                result.close();
                                throw new FactoryException(Errors.format(187, type));
                            }
                            expected = Conversion.class;
                        }
                        MathTransform mt = this.factories.getMathTransformFactory().createBaseToDerived(sourceCRS, parameters, targetCRS.getCoordinateSystem());
                        operation = DefaultOperation.create(properties, sourceCRS, targetCRS, mt, method, expected);
                    }
                    returnValue = AbstractEpsgFactory.ensureSingleton(operation, returnValue, code);
                    if (!exit) continue;
                    CoordinateOperation coordinateOperation = returnValue;
                    return coordinateOperation;
                }
            }
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(CoordinateOperation.class, code, exception);
        }
        if (returnValue != null) return returnValue;
        throw this.noSuchAuthorityCode(CoordinateOperation.class, code);
    }

    @Override
    public synchronized Set generateFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        AbstractEpsgFactory.ensureNonNull("sourceCode", sourceCode);
        AbstractEpsgFactory.ensureNonNull("targetCode", targetCode);
        String pair = sourceCode + " \u21e8 " + targetCode;
        CoordinateOperationSet set = new CoordinateOperationSet(this);
        try {
            String sourceKey = this.toPrimaryKeyCRS(sourceCode);
            String targetKey = this.toPrimaryKeyCRS(targetCode);
            boolean searchTransformations = false;
            do {
                String sql;
                String key;
                if (searchTransformations) {
                    key = "TransformationFromCRS";
                    sql = "SELECT COORD_OP_CODE FROM [Coordinate_Operation] WHERE SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY ABS(DEPRECATED), COORD_OP_ACCURACY";
                } else {
                    key = "ConversionFromCRS";
                    sql = "SELECT PROJECTION_CONV_CODE FROM [Coordinate Reference System] WHERE SOURCE_GEOGCRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                PreparedStatement stmt = this.prepareStatement(key, sql);
                stmt.setString(1, sourceKey);
                stmt.setString(2, targetKey);
                try (ResultSet result = stmt.executeQuery();){
                    while (result.next()) {
                        String code = AbstractEpsgFactory.getString(result, 1, pair);
                        set.addAuthorityCode(code, searchTransformations ? null : targetKey);
                    }
                }
            } while (searchTransformations = !searchTransformations);
            Object[] codes = set.getAuthorityCodes();
            this.sort(codes);
            set.setAuthorityCodes((String[])codes);
        }
        catch (SQLException exception) {
            throw AbstractEpsgFactory.databaseFailure(CoordinateOperation.class, pair, exception);
        }
        set.resolve(1);
        return set;
    }

    private void sort(Object ... codes) throws SQLException, FactoryException {
        if (codes.length <= 1) {
            return;
        }
        PreparedStatement stmt = this.prepareStatement("Supersession", "SELECT SUPERSEDED_BY FROM [Supersession] WHERE OBJECT_CODE = ? ORDER BY SUPERSESSION_YEAR DESC");
        int maxIterations = 15;
        do {
            boolean changed = false;
            for (int i = 0; i < codes.length; ++i) {
                String code = codes[i].toString();
                stmt.setString(1, code);
                try (ResultSet result = stmt.executeQuery();){
                    while (result.next()) {
                        String replacement = AbstractEpsgFactory.getString(result, 1, code);
                        for (int j = i + 1; j < codes.length; ++j) {
                            Object candidate = codes[j];
                            if (!replacement.equals(candidate.toString())) continue;
                            System.arraycopy(codes, i, codes, i + 1, j - i);
                            codes[i++] = candidate;
                            changed = true;
                        }
                    }
                    continue;
                }
            }
            if (changed) continue;
            return;
        } while (--maxIterations != 0);
        LOGGER.finer("Possible recursivity in supersessions.");
    }

    private static FactoryException recursiveCall(Class<? extends IdentifiedObject> type, String code) {
        return new FactoryException(Errors.format(164, type, code));
    }

    private static FactoryException databaseFailure(Class<? extends Object> type, String code, SQLException cause) {
        return new FactoryException(Errors.format(38, type, code), cause);
    }

    protected abstract String adaptSQL(String var1);

    protected boolean isPrimaryKey(String code) throws FactoryException {
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            char c = code.charAt(i);
            if (Character.isDigit(c) || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    final synchronized boolean canDispose() {
        return true;
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        this.disconnect();
        super.dispose();
    }

    public void connect() throws FactoryException {
        try {
            this.getConnection();
        }
        catch (SQLException e) {
            throw new FactoryException(e);
        }
    }

    public void disconnect() throws FactoryException {
        if (this.connection != null) {
            boolean isClosed;
            try {
                isClosed = this.connection.isClosed();
                Iterator<PreparedStatement> it = this.statements.values().iterator();
                while (it.hasNext()) {
                    it.next().close();
                    it.remove();
                }
                this.connection.close();
            }
            catch (SQLException exception) {
                throw new FactoryException(exception);
            }
            if (!isClosed) {
                LogRecord record = Loggings.format(Level.FINE, 12);
                record.setLoggerName(LOGGER.getName());
                LOGGER.log(record);
            }
            this.connection = null;
        }
    }

    protected synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    protected void shutdown(boolean active) throws SQLException {
    }

    protected final void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static Unit<?> getUnit(int code) {
        switch (code) {
            case 9001: {
                return Units.METRE;
            }
            case 9002: {
                return Units.FOOT;
            }
            case 9030: {
                return Units.NAUTICAL_MILE;
            }
            case 9036: {
                return Units.KILOMETER;
            }
            case 9101: {
                return Units.RADIAN;
            }
            case 9102: 
            case 9122: {
                return Units.DEGREE_ANGLE;
            }
            case 9103: {
                return Units.MINUTE_ANGLE;
            }
            case 9104: {
                return Units.SECOND_ANGLE;
            }
            case 9105: {
                return Units.GRADE;
            }
            case 9107: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9108: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9109: {
                return Units.MICRORADIAN;
            }
            case 9110: {
                return Units.SEXAGESIMAL_DMS;
            }
            case 9201: 
            case 9203: {
                return Units.ONE;
            }
            case 9202: {
                return Units.PPM;
            }
        }
        return null;
    }

    private static void setBursaWolfParameter(BursaWolfParameters parameters, int code, double value, Unit<?> unit) throws FactoryException {
        Unit<Quantity<Dimensionless>> target = unit;
        if (code >= 8605) {
            if (code <= 8607) {
                target = SI.METRE;
            } else if (code == 8611) {
                target = Units.PPM;
            } else if (code <= 8710) {
                target = NonSI.SECOND_ANGLE;
            }
        }
        if (target != unit) {
            value = Units.getConverterToAny(unit, target).convert(value);
        }
        switch (code) {
            case 8605: {
                parameters.dx = value;
                break;
            }
            case 8606: {
                parameters.dy = value;
                break;
            }
            case 8607: {
                parameters.dz = value;
                break;
            }
            case 8608: {
                parameters.ex = value;
                break;
            }
            case 8609: {
                parameters.ey = value;
                break;
            }
            case 8610: {
                parameters.ez = value;
                break;
            }
            case 8611: {
                parameters.ppm = value;
                break;
            }
            default: {
                throw new FactoryException(Errors.format(176, code));
            }
        }
    }

    final class AuthorityCodeSet
    extends AbstractSet<String>
    implements Serializable {
        private static final long serialVersionUID = 7105664579449680562L;
        public final Class<?> type;
        private final boolean isProjection;
        private transient java.util.Map<String, String> asMap;
        final String sqlAll;
        private final String sqlSingle;
        private transient PreparedStatement queryAll;
        private transient PreparedStatement querySingle;
        private int size = -1;

        public AuthorityCodeSet(TableInfo table, Class type) {
            StringBuilder buffer = new StringBuilder("SELECT ");
            buffer.append(table.codeColumn);
            if (table.nameColumn != null) {
                buffer.append(", ").append(table.nameColumn);
            }
            buffer.append(" FROM ").append(table.table);
            boolean hasWhere = false;
            Class<?> tableType = table.type;
            if (table.typeColumn != null) {
                for (int i = 0; i < table.subTypes.length; ++i) {
                    Class<?> candidate = table.subTypes[i];
                    if (!candidate.isAssignableFrom(type)) continue;
                    buffer.append(" WHERE (").append(table.typeColumn).append(" LIKE '").append(table.typeNames[i]).append("%'");
                    hasWhere = true;
                    tableType = candidate;
                    break;
                }
                if (hasWhere) {
                    buffer.append(')');
                }
            }
            this.type = tableType;
            this.isProjection = Projection.class.isAssignableFrom(tableType);
            int length = buffer.length();
            buffer.append(" ORDER BY ").append(table.codeColumn);
            this.sqlAll = AbstractEpsgFactory.this.adaptSQL(buffer.toString());
            buffer.setLength(length);
            buffer.append(hasWhere ? " AND " : " WHERE ").append(table.codeColumn).append(" = ?");
            this.sqlSingle = AbstractEpsgFactory.this.adaptSQL(buffer.toString());
        }

        private ResultSet getAll() throws SQLException {
            assert (Thread.holdsLock(this));
            if (this.queryAll != null) {
                try {
                    return this.queryAll.executeQuery();
                }
                catch (SQLException ignore) {
                    this.queryAll.close();
                    this.queryAll = null;
                    this.recoverableException("getAll", ignore);
                }
            }
            this.queryAll = AbstractEpsgFactory.this.getConnection().prepareStatement(this.sqlAll);
            return this.queryAll.executeQuery();
        }

        private ResultSet getSingle(Object code) throws SQLException {
            assert (Thread.holdsLock(this));
            if (this.querySingle == null) {
                this.querySingle = AbstractEpsgFactory.this.getConnection().prepareStatement(this.sqlSingle);
            }
            this.querySingle.setString(1, code.toString());
            return this.querySingle.executeQuery();
        }

        private boolean isAcceptable(ResultSet results) throws SQLException {
            if (!this.isProjection) {
                return true;
            }
            String code = results.getString(1);
            return AbstractEpsgFactory.this.isProjection(code);
        }

        private boolean isAcceptable(String code) throws SQLException {
            if (!this.isProjection) {
                return true;
            }
            return AbstractEpsgFactory.this.isProjection(code);
        }

        @Override
        public synchronized boolean isEmpty() {
            if (this.size != -1) {
                return this.size == 0;
            }
            boolean empty = true;
            try (ResultSet results = this.getAll();){
                while (results.next()) {
                    if (!this.isAcceptable(results)) continue;
                    empty = false;
                    break;
                }
            }
            catch (SQLException exception) {
                this.unexpectedException("isEmpty", exception);
            }
            this.size = empty ? 0 : -2;
            return empty;
        }

        @Override
        public synchronized int size() {
            if (this.size >= 0) {
                return this.size;
            }
            int count = 0;
            try (ResultSet results = this.getAll();){
                while (results.next()) {
                    if (!this.isAcceptable(results)) continue;
                    ++count;
                }
            }
            catch (SQLException exception) {
                this.unexpectedException("size", exception);
            }
            this.size = count;
            return count;
        }

        @Override
        public synchronized boolean contains(Object code) {
            boolean exists = false;
            if (code != null) {
                try (ResultSet results = this.getSingle(code);){
                    while (results.next()) {
                        if (!this.isAcceptable(results)) continue;
                        exists = true;
                        break;
                    }
                }
                catch (SQLException exception) {
                    this.unexpectedException("contains", exception);
                }
            }
            return exists;
        }

        @Override
        public synchronized java.util.Iterator<String> iterator() {
            try {
                Iterator iterator = new Iterator(this.getAll());
                this.queryAll = null;
                return iterator;
            }
            catch (SQLException exception) {
                this.unexpectedException("iterator", exception);
                Set empty = Collections.emptySet();
                return empty.iterator();
            }
        }

        protected LinkedHashSet<String> writeReplace() throws ObjectStreamException {
            return new LinkedHashSet<String>(this);
        }

        protected synchronized void finalize() throws SQLException {
            if (this.querySingle != null) {
                this.querySingle.close();
                this.querySingle = null;
            }
            if (this.queryAll != null) {
                this.queryAll.close();
                this.queryAll = null;
            }
        }

        private void unexpectedException(String method, SQLException exception) {
            this.unexpectedException(AuthorityCodes.class, method, exception);
        }

        void unexpectedException(Class classe, String method, SQLException exception) {
            Logging.unexpectedException(ReferencingFactory.LOGGER, classe, method, exception);
        }

        private void recoverableException(String method, SQLException exception) {
            LogRecord record = Loggings.format(Level.FINE, 43);
            record.setSourceClassName(AuthorityCodes.class.getName());
            record.setSourceMethodName(method);
            record.setThrown(exception);
            record.setLoggerName(ReferencingFactory.LOGGER.getName());
            ReferencingFactory.LOGGER.log(record);
        }

        final java.util.Map<String, String> asMap() {
            if (this.asMap == null) {
                this.asMap = new Map();
            }
            return this.asMap;
        }

        private final class Map
        extends AbstractMap<String, String> {
            private Map() {
            }

            @Override
            public int size() {
                return AuthorityCodeSet.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AuthorityCodeSet.this.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get(Object code) {
                String value = null;
                if (code != null) {
                    try {
                        AuthorityCodeSet authorityCodeSet = AuthorityCodeSet.this;
                        synchronized (authorityCodeSet) {
                            try (ResultSet results = AuthorityCodeSet.this.getSingle(code);){
                                while (results.next()) {
                                    if (!AuthorityCodeSet.this.isAcceptable(results)) continue;
                                    value = results.getString(2);
                                    break;
                                }
                            }
                        }
                    }
                    catch (SQLException exception) {
                        AuthorityCodeSet.this.unexpectedException("get", exception);
                    }
                }
                return value;
            }

            @Override
            public boolean containsKey(Object key) {
                return AuthorityCodeSet.this.contains(key);
            }

            @Override
            public Set<String> keySet() {
                return AuthorityCodeSet.this;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                throw new UnsupportedOperationException();
            }
        }

        private final class Iterator
        implements java.util.Iterator<String> {
            private ResultSet results;
            private transient String next;

            Iterator(ResultSet results) throws SQLException {
                assert (Thread.holdsLock(AuthorityCodeSet.this));
                this.results = results;
                this.toNext();
            }

            private void toNext() throws SQLException {
                while (this.results.next()) {
                    this.next = this.results.getString(1);
                    if (!AuthorityCodeSet.this.isAcceptable(this.next)) continue;
                    return;
                }
                this.finalize();
            }

            @Override
            public boolean hasNext() {
                return this.results != null;
            }

            @Override
            public String next() {
                if (this.results == null) {
                    throw new NoSuchElementException();
                }
                String current = this.next;
                try {
                    this.toNext();
                }
                catch (SQLException exception) {
                    this.results = null;
                    AuthorityCodeSet.this.unexpectedException(Iterator.class, "next", exception);
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws SQLException {
                this.next = null;
                if (this.results != null) {
                    PreparedStatement owner = (PreparedStatement)this.results.getStatement();
                    this.results.close();
                    this.results = null;
                    AuthorityCodeSet authorityCodeSet = AuthorityCodeSet.this;
                    synchronized (authorityCodeSet) {
                        assert (owner != AuthorityCodeSet.this.queryAll);
                        if (AuthorityCodeSet.this.queryAll == null) {
                            AuthorityCodeSet.this.queryAll = owner;
                        } else {
                            owner.close();
                        }
                    }
                }
            }
        }
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder(Class<? extends IdentifiedObject> type) {
            super(AbstractEpsgFactory.this, type);
        }

        @Override
        protected Set<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
            String code;
            String where;
            String select = "COORD_REF_SYS_CODE";
            String from = "[Coordinate Reference System]";
            if (object instanceof Ellipsoid) {
                select = "ELLIPSOID_CODE";
                from = "[Ellipsoid]";
                where = "SEMI_MAJOR_AXIS";
                code = Double.toString(((Ellipsoid)object).getSemiMajorAxis());
            } else {
                IdentifiedObject dependency;
                if (object instanceof GeneralDerivedCRS) {
                    dependency = ((GeneralDerivedCRS)object).getBaseCRS();
                    where = "SOURCE_GEOGCRS_CODE";
                } else if (object instanceof SingleCRS) {
                    dependency = ((SingleCRS)object).getDatum();
                    where = "DATUM_CODE";
                } else if (object instanceof GeodeticDatum) {
                    dependency = ((GeodeticDatum)object).getEllipsoid();
                    select = "DATUM_CODE";
                    from = "[Datum]";
                    where = "ELLIPSOID_CODE";
                } else {
                    return super.getCodeCandidates(object);
                }
                dependency = AbstractEpsgFactory.this.getIdentifiedObjectFinder(dependency.getClass()).find(dependency);
                ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier(dependency, this.getAuthority());
                if (id == null || (code = id.getCode()) == null) {
                    return super.getCodeCandidates(object);
                }
            }
            String sql = "SELECT " + select + " FROM " + from + " WHERE " + where + "='" + code + '\'';
            sql = AbstractEpsgFactory.this.adaptSQL(sql);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            try (Statement s = AbstractEpsgFactory.this.getConnection().createStatement();
                 ResultSet r = s.executeQuery(sql);){
                while (r.next()) {
                    result.add(r.getString(1));
                }
            }
            catch (SQLException exception) {
                throw AbstractEpsgFactory.databaseFailure(Identifier.class, code, exception);
            }
            return result;
        }
    }

    private static final class Dimensions {
        int encoded;
        int occurences;

        Dimensions(int e) {
            this.encoded = e;
        }

        public int hashCode() {
            return this.encoded;
        }

        public boolean equals(Object object) {
            return object instanceof Dimensions && ((Dimensions)object).encoded == this.encoded;
        }

        public String toString() {
            return "[(" + (this.encoded >>> 16) + ',' + (this.encoded & 0xFFFF) + ")\u00d7" + this.occurences + ']';
        }
    }
}

