/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.CachedTile;
import javax.media.jai.TileCache;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRecycler;
import org.geotools.util.logging.Logging;

public class RecyclingTileFactory
extends Observable
implements TileFactory,
TileRecycler,
Observer {
    static final Logger LOGGER = Logging.getLogger(RecyclingTileFactory.class);
    private HashMap<Long, ArrayList> recycledArrays = new HashMap(32);
    private long memoryUsed = 0L;
    private final Observable tileCache;

    private static long getBufferSizeCSM(ComponentSampleModel csm) {
        int scanlineStride;
        int pixelStride;
        int[] bandOffsets = csm.getBandOffsets();
        int maxBandOff = bandOffsets[0];
        for (int i = 1; i < bandOffsets.length; ++i) {
            maxBandOff = Math.max(maxBandOff, bandOffsets[i]);
        }
        long size = 0L;
        if (maxBandOff >= 0) {
            size += (long)(maxBandOff + 1);
        }
        if ((pixelStride = csm.getPixelStride()) > 0) {
            size += (long)(pixelStride * (csm.getWidth() - 1));
        }
        if ((scanlineStride = csm.getScanlineStride()) > 0) {
            size += (long)(scanlineStride * (csm.getHeight() - 1));
        }
        return size;
    }

    private static long getNumBanksCSM(ComponentSampleModel csm) {
        int[] bankIndices = csm.getBankIndices();
        int maxIndex = bankIndices[0];
        for (int i = 1; i < bankIndices.length; ++i) {
            int bankIndex = bankIndices[i];
            if (bankIndex <= maxIndex) continue;
            maxIndex = bankIndex;
        }
        return maxIndex + 1;
    }

    private static Object getBankReference(DataBuffer db) {
        Object array = null;
        switch (db.getDataType()) {
            case 0: {
                array = ((DataBufferByte)db).getBankData();
                break;
            }
            case 1: {
                array = ((DataBufferUShort)db).getBankData();
                break;
            }
            case 2: {
                array = ((DataBufferShort)db).getBankData();
                break;
            }
            case 3: {
                array = ((DataBufferInt)db).getBankData();
                break;
            }
            case 4: {
                array = DataBufferUtils.getBankDataFloat(db);
                break;
            }
            case 5: {
                array = DataBufferUtils.getBankDataDouble(db);
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
        return array;
    }

    private static long getDataBankSize(int dataType, int numBanks, int size) {
        int bytesPerElement = 0;
        switch (dataType) {
            case 0: {
                bytesPerElement = 1;
                break;
            }
            case 1: 
            case 2: {
                bytesPerElement = 2;
                break;
            }
            case 3: 
            case 4: {
                bytesPerElement = 4;
                break;
            }
            case 5: {
                bytesPerElement = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
        return numBanks * size * bytesPerElement;
    }

    public RecyclingTileFactory(Observable tileCache) {
        if (!(tileCache instanceof TileCache)) {
            throw new IllegalArgumentException("Provided argument is not of type TileCache");
        }
        this.tileCache = tileCache;
        tileCache.addObserver(this);
    }

    @Override
    public boolean canReclaimMemory() {
        return true;
    }

    @Override
    public boolean isMemoryCache() {
        return true;
    }

    @Override
    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        HashMap<Long, ArrayList> hashMap = this.recycledArrays;
        synchronized (hashMap) {
            this.recycledArrays.clear();
            this.memoryUsed = 0L;
        }
    }

    @Override
    public WritableRaster createTile(SampleModel sampleModel, Point location) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        DataBuffer db = null;
        int type = sampleModel.getTransferType();
        long numBanks = 0L;
        long size = 0L;
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            numBanks = RecyclingTileFactory.getNumBanksCSM(csm);
            size = RecyclingTileFactory.getBufferSizeCSM(csm);
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            numBanks = 1L;
            int dataTypeSize = DataBuffer.getDataTypeSize(type);
            size = mppsm.getScanlineStride() * mppsm.getHeight() + (mppsm.getDataBitOffset() + dataTypeSize - 1) / dataTypeSize;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sampleModel;
            numBanks = 1L;
            size = sppsm.getScanlineStride() * (sppsm.getHeight() - 1) + sppsm.getWidth();
        }
        if (size != 0L) {
            Object array = this.getRecycledArray(type, numBanks, size);
            if (array != null) {
                switch (type) {
                    case 0: {
                        byte[][] bankData = (byte[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], (byte)0);
                            ++i;
                        }
                        db = new DataBufferByte(bankData, (int)size);
                        break;
                    }
                    case 1: {
                        short[][] bankData = (short[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], (short)0);
                            ++i;
                        }
                        db = new DataBufferUShort(bankData, (int)size);
                        break;
                    }
                    case 2: {
                        short[][] bankData = (short[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], (short)0);
                            ++i;
                        }
                        db = new DataBufferShort(bankData, (int)size);
                        break;
                    }
                    case 3: {
                        int[][] bankData = (int[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], 0);
                            ++i;
                        }
                        db = new DataBufferInt(bankData, (int)size);
                        break;
                    }
                    case 4: {
                        float[][] bankData = (float[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], 0.0f);
                            ++i;
                        }
                        db = DataBufferUtils.createDataBufferFloat(bankData, (int)size);
                        break;
                    }
                    case 5: {
                        double[][] bankData = (double[][])array;
                        int i = 0;
                        while ((long)i < numBanks) {
                            Arrays.fill(bankData[i], 0.0);
                            ++i;
                        }
                        db = DataBufferUtils.createDataBufferDouble(bankData, (int)size);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("");
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this.getClass().getName() + " Using a recycled array");
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this.getClass().getName() + " No type " + type + " array[" + numBanks + "][" + size + "] available");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getName() + " Size is zero");
        }
        if (db == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this.getClass().getName() + " Creating new DataBuffer");
            }
            db = sampleModel.createDataBuffer();
        }
        return Raster.createWritableRaster(sampleModel, db, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleTile(Raster tile) {
        DataBuffer db = tile.getDataBuffer();
        Long key = (long)db.getDataType() << 56 | (long)db.getNumBanks() << 32 | (long)db.getSize();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Recycling array for: " + db.getDataType() + " " + db.getNumBanks() + " " + db.getSize());
            LOGGER.fine("recycleTile(); key = " + key);
        }
        HashMap<Long, ArrayList> hashMap = this.recycledArrays;
        synchronized (hashMap) {
            ArrayList<Object> cast;
            ArrayList<Object> value = this.recycledArrays.get(key);
            ArrayList<Object> arrays = null;
            arrays = value != null ? (cast = value) : new ArrayList<Object>(10);
            this.memoryUsed += RecyclingTileFactory.getDataBankSize(db.getDataType(), db.getNumBanks(), db.getSize());
            arrays.add(RecyclingTileFactory.getBankReference(db));
            if (value == null) {
                this.recycledArrays.put(key, arrays);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRecycledArray(int arrayType, long numBanks, long arrayLength) {
        Long key = (long)arrayType << 56 | numBanks << 32 | arrayLength;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Attempting to get array for: " + arrayType + " " + numBanks + " " + arrayLength);
            LOGGER.fine("Attempting to get array for key " + key);
        }
        HashMap<Long, ArrayList> hashMap = this.recycledArrays;
        synchronized (hashMap) {
            ArrayList value = this.recycledArrays.get(key);
            if (value != null) {
                ArrayList arrays = value;
                for (int idx = arrays.size() - 1; idx >= 0; --idx) {
                    Object array = arrays.remove(idx);
                    this.memoryUsed -= RecyclingTileFactory.getDataBankSize(arrayType, (int)numBanks, (int)arrayLength);
                    if (idx == 0) {
                        this.recycledArrays.remove(key);
                    }
                    if (array != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("good reference");
                        }
                        return array;
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("null reference");
                }
            }
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o.equals(this.tileCache) && arg instanceof CachedTile) {
            CachedTile tile = (CachedTile)arg;
            switch (tile.getAction()) {
                case 1: 
                case 2: {
                    this.recycleTile(tile.getTile());
                }
            }
        }
    }
}

