/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.footprint.FootprintGeometryProvider;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderFinder;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class SidecarFootprintProvider
implements FootprintGeometryProvider {
    static final Logger LOGGER = Logging.getLogger(SidecarFootprintProvider.class);
    static final Set<FootprintLoader> LOADERS = new HashSet<FootprintLoader>();
    private static final String FOOTPRINT_LOCATION_ATTRIBUTE = "location";
    public static final String FOOTPRINTS_DATA_DIR_KEY = "FOOTPRINTS_DATA_DIR";
    private static final String FOOTPRINTS_DATA_DIR;
    private File reference;
    private volatile FootprintLoader lastLoader;

    public SidecarFootprintProvider(File reference) {
        this.reference = reference;
    }

    @Override
    public Geometry getFootprint(SimpleFeature feature) throws IOException {
        String path = this.getPath(feature);
        if (path != null) {
            return this.getFootprint(path);
        }
        return null;
    }

    private String getPath(SimpleFeature feature) throws IOException {
        String path = null;
        if (feature == null) {
            path = this.reference.getAbsolutePath();
        } else {
            Object value = feature.getAttribute(FOOTPRINT_LOCATION_ATTRIBUTE);
            if (value instanceof String && !((String)value).matches("^(?i)https?://.*$")) {
                String strValue = (String)value;
                path = this.getFullPath(strValue);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not use the location attribute value to search for a sidecar file, the value was: " + value);
            }
        }
        return path;
    }

    public Geometry getFootprint(String path) throws IOException {
        String noExtension = this.getNoExtensionPath(path);
        FootprintLoader loader = this.lastLoader;
        Geometry result = null;
        try {
            if (loader != null) {
                result = loader.loadFootprint(noExtension);
            }
            if (result == null) {
                result = this.checkForFootprint(noExtension);
            }
            if (result == null && (noExtension = SidecarFootprintProvider.getAlternativePath(path, true)) != null) {
                result = this.checkForFootprint(noExtension);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to load the footprint for granule " + path, e);
        }
        return result;
    }

    private static String getAlternativePath(String path, boolean removeExtension) {
        return FOOTPRINTS_DATA_DIR != null ? SidecarFootprintProvider.getAlternativeFile(path, removeExtension).getAbsolutePath() : null;
    }

    public static File getAlternativeFile(File file) {
        return FOOTPRINTS_DATA_DIR != null ? SidecarFootprintProvider.getAlternativeFile(file.getAbsolutePath(), false) : null;
    }

    private static File getAlternativeFile(String path, boolean removeExtension) {
        String basePath = FilenameUtils.getPathNoEndSeparator(path);
        String name = removeExtension ? FilenameUtils.getBaseName(path) : FilenameUtils.getName(path);
        String alternativePath = basePath + File.separatorChar + name;
        return new File(FOOTPRINTS_DATA_DIR, alternativePath);
    }

    private Geometry checkForFootprint(String noExtension) {
        Geometry result = null;
        for (FootprintLoader test : LOADERS) {
            try {
                result = test.loadFootprint(noExtension);
                if (result == null) continue;
                this.lastLoader = test;
                break;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, test.getClass().getName() + " threw exception loading footprint", e);
            }
        }
        return result;
    }

    private FootprintLoader getLoader(String noExtension) {
        for (FootprintLoader test : LOADERS) {
            try {
                Geometry result = test.loadFootprint(noExtension);
                if (result == null) continue;
                return test;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, test.getClass().getName() + " threw exception loading footprint", e);
            }
        }
        return null;
    }

    private String getNoExtensionPath(String path) {
        int idx = path.lastIndexOf(".");
        return idx > 0 ? path.substring(0, idx) : path;
    }

    private String getFullPath(String strValue) throws IOException {
        File file = new File(strValue);
        if (!file.isAbsolute()) {
            file = new File(this.reference, strValue);
        }
        return file.getCanonicalPath();
    }

    @Override
    public void dispose() {
    }

    public static String getFootprintsDataDir() {
        return FOOTPRINTS_DATA_DIR;
    }

    @Override
    public List<File> getSidecars(SimpleFeature feature) throws IOException {
        String path = this.getPath(feature);
        if (path != null) {
            return this.getSidecars(path);
        }
        return Collections.emptyList();
    }

    public List<File> getSidecars(String path) throws IOException {
        String noExtensionPath = this.getNoExtensionPath(path);
        FootprintLoader loader = this.getLoader(noExtensionPath);
        if (loader != null) {
            return loader.getFootprintFiles(noExtensionPath);
        }
        return Collections.emptyList();
    }

    static {
        String prefixDir = System.getProperty(FOOTPRINTS_DATA_DIR_KEY);
        String footprintsDir = null;
        if (prefixDir != null) {
            String dir = prefixDir;
            File file = new File(dir);
            if (!file.exists()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified path doesn't refer to an existing folder. Please check the path: " + dir);
                }
            } else if (!file.isDirectory()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified path doesn't refer to a directory. Please check the path: " + dir);
                }
            } else {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Setting the Footprints data dir to: " + dir);
                }
                footprintsDir = dir;
            }
        }
        FOOTPRINTS_DATA_DIR = footprintsDir;
        Set<FootprintLoaderSpi> SPI = FootprintLoaderFinder.getAvailableLoaders();
        Iterator<FootprintLoaderSpi> iterator = SPI.iterator();
        while (iterator.hasNext()) {
            LOADERS.add(iterator.next().createLoader());
        }
    }
}

