/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandmerge;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.jai.codecimpl.util.FloatDoubleColorModel;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

public class BandMergeOpImage
extends PointOpImage {
    public static final int TILE_EXTENDER = 1;
    ColorModel[] colorModels;
    private final Range[] noData;
    private final boolean hasROI;
    private final boolean hasNoData;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    private ROI roi;

    public BandMergeOpImage(List sources, Map config, Range[] noData, ROI roi, double destinationNoData, boolean setAlpha, ImageLayout layout) {
        super(BandMergeOpImage.vectorize(sources), BandMergeOpImage.layoutHelper(sources, layout, setAlpha), config, true);
        this.permitInPlaceOperation();
        int numSrcs = sources.size();
        this.colorModels = new ColorModel[numSrcs];
        for (int i = 0; i < numSrcs; ++i) {
            this.colorModels[i] = ((RenderedImage)sources.get(i)).getColorModel();
        }
        int dataType = this.getSampleModel().getDataType();
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat(destinationNoData);
                break;
            }
            case 5: {
                this.destNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (noData != null) {
            int nullRanges = 0;
            for (int i = 0; i < noData.length; ++i) {
                nullRanges += noData[i] == null ? 1 : 0;
            }
            if (nullRanges != noData.length) {
                if (noData.length != numSrcs || nullRanges > 0) {
                    Range firstNoData = noData[0];
                    this.noData = new Range[numSrcs];
                    for (int i = 0; i < numSrcs; ++i) {
                        this.noData[i] = firstNoData;
                    }
                } else {
                    this.noData = noData;
                }
                this.hasNoData = true;
            } else {
                this.noData = null;
                this.hasNoData = false;
            }
        } else {
            this.noData = null;
            this.hasNoData = false;
        }
        this.roi = roi;
        this.hasROI = roi != null;
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    private static int totalNumBands(List sources) {
        int total = 0;
        for (int i = 0; i < sources.size(); ++i) {
            RenderedImage image = (RenderedImage)sources.get(i);
            if (image.getColorModel() instanceof IndexColorModel) {
                total += image.getColorModel().getNumComponents();
                continue;
            }
            total += image.getSampleModel().getNumBands();
        }
        return total;
    }

    private static ImageLayout layoutHelper(List sources, ImageLayout il, boolean setAlpha) {
        ColorModel cm;
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        int numSources = sources.size();
        int destNumBands = BandMergeOpImage.totalNumBands(sources);
        int destDataType = 0;
        RenderedImage srci = (RenderedImage)sources.get(0);
        Rectangle destBounds = new Rectangle(srci.getMinX(), srci.getMinY(), srci.getWidth(), srci.getHeight());
        for (int i = 0; i < numSources; ++i) {
            srci = (RenderedImage)sources.get(i);
            destBounds = destBounds.intersection(new Rectangle(srci.getMinX(), srci.getMinY(), srci.getWidth(), srci.getHeight()));
            int typei = srci.getSampleModel().getTransferType();
            destDataType = typei > destDataType ? typei : destDataType;
        }
        layout.setMinX(destBounds.x);
        layout.setMinY(destBounds.y);
        layout.setWidth(destBounds.width);
        layout.setHeight(destBounds.height);
        SampleModel sm = layout.getSampleModel((RenderedImage)sources.get(0));
        if (sm.getNumBands() < destNumBands) {
            int[] destOffsets = new int[destNumBands];
            for (int i = 0; i < destNumBands; ++i) {
                destOffsets[i] = i;
            }
            int destTileWidth = sm.getWidth();
            int destTileHeight = sm.getHeight();
            if (layout.isValid(64)) {
                destTileWidth = layout.getTileWidth((RenderedImage)sources.get(0));
            }
            if (layout.isValid(128)) {
                destTileHeight = layout.getTileHeight((RenderedImage)sources.get(0));
            }
            sm = RasterFactory.createComponentSampleModel(sm, destDataType, destTileWidth, destTileHeight, destNumBands);
            layout.setSampleModel(sm);
        }
        if ((cm = layout.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(sm, cm)) {
            layout.unsetValid(512);
        }
        if ((cm == null || !cm.hasAlpha()) && sm instanceof ComponentSampleModel) {
            cm = BandMergeOpImage.getDefaultColorModel(sm, setAlpha);
            layout.setColorModel(cm);
        }
        return layout;
    }

    static ColorModel getDefaultColorModel(SampleModel sm, boolean setAlpha) {
        int dataType = sm.getDataType();
        int numBands = sm.getNumBands();
        if (dataType < 0 || dataType > 5 || numBands < 1) {
            return null;
        }
        ColorSpace cs = null;
        switch (numBands) {
            case 0: {
                throw new IllegalArgumentException("No input bands defined");
            }
            case 1: {
                cs = ColorSpace.getInstance(1003);
                break;
            }
            case 2: 
            case 4: {
                if (setAlpha) {
                    cs = numBands == 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
                    break;
                }
                cs = new ColorSpace(dataType, numBands){

                    @Override
                    public float[] toRGB(float[] colorvalue) {
                        return null;
                    }

                    @Override
                    public float[] toCIEXYZ(float[] colorvalue) {
                        return null;
                    }

                    @Override
                    public float[] fromRGB(float[] rgbvalue) {
                        return null;
                    }

                    @Override
                    public float[] fromCIEXYZ(float[] colorvalue) {
                        return null;
                    }
                };
                break;
            }
            case 3: {
                cs = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                cs = new BogusColorSpace(numBands);
            }
        }
        int dataTypeSize = DataBuffer.getDataTypeSize(dataType);
        int[] bits = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bits[i] = dataTypeSize;
        }
        boolean useAlpha = false;
        boolean premultiplied = false;
        int transparency = 1;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new ComponentColorModel(cs, bits, useAlpha, premultiplied, transparency, dataType);
            }
            case 4: 
            case 5: {
                return new FloatDoubleColorModel(cs, useAlpha, premultiplied, transparency, dataType);
            }
        }
        throw new IllegalArgumentException("Wrong data type used");
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        block10: {
            block9: {
                int destType = dest.getTransferType();
                ROI roiTile = null;
                if (this.hasROI) {
                    Rectangle rect = new Rectangle(destRect);
                    rect.grow(1, 1);
                    if (!rect.intersection(this.roi.getBounds()).isEmpty()) {
                        roiTile = this.roi.intersect(new ROIShape(rect));
                    }
                }
                if (this.hasROI && (roiTile == null || roiTile.getBounds().isEmpty())) break block9;
                switch (destType) {
                    case 0: {
                        this.byteLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 1: 
                    case 2: {
                        this.shortLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 3: {
                        this.intLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 4: {
                        this.floatLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 5: {
                        this.doubleLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("Wrong image data type");
                    }
                }
            }
            int numBands = this.getSampleModel().getNumBands();
            double[] background = new double[numBands];
            Arrays.fill(background, this.destNoDataDouble);
            ImageUtil.fillBackground(dest, destRect, background);
        }
    }

    private void byteLoop(Raster[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        PixelAccessor[] pas = new PixelAccessor[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            pas[i] = new PixelAccessor(sources[i].getSampleModel(), this.colorModels[i]);
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels(dest, destRect, destType, true);
        int minX = destRect.x;
        int minY = destRect.y;
        byte[][] dstdata = (byte[][])dimd.data;
        if (this.caseA) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    byte[] dstdatabandb = dstdata[db];
                    byte[][] srcdata = (byte[][])simd.data;
                    byte[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else if (this.caseB) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        byte[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                byte[][] srcdata = (byte[][])simd.data;
                                byte[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataByte;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    byte[] dstdatabandb = dstdata[db];
                    byte[][] srcdata = (byte[][])simd.data;
                    byte[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = this.noData[sindex].contains(srcdatabandsb[srcpos]) ? this.destNoDataByte : srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        byte[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                byte[][] srcdata = (byte[][])simd.data;
                                byte[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    byte value = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.noData[sindex].contains(value) ? this.destNoDataByte : value;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataByte;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void shortLoop(Raster[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        PixelAccessor[] pas = new PixelAccessor[nSrcs];
        int minX = destRect.x;
        int minY = destRect.y;
        boolean isUshort = this.getSampleModel().getDataType() == 1;
        for (int i = 0; i < nSrcs; ++i) {
            pas[i] = new PixelAccessor(sources[i].getSampleModel(), this.colorModels[i]);
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels(dest, destRect, destType, true);
        short[][] dstdata = (short[][])dimd.data;
        if (this.caseA) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    short[] dstdatabandb = dstdata[db];
                    short[][] srcdata = (short[][])simd.data;
                    short[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else if (this.caseB) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        short[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                short[][] srcdata = (short[][])simd.data;
                                short[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataShort;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    short[] dstdatabandb = dstdata[db];
                    short[][] srcdata = (short[][])simd.data;
                    short[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = this.noData[sindex].contains(srcdatabandsb[srcpos]) ? this.destNoDataShort : srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        short[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                short[][] srcdata = (short[][])simd.data;
                                short[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    short value = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.noData[sindex].contains(value) ? this.destNoDataShort : value;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataShort;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void intLoop(Raster[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        PixelAccessor[] pas = new PixelAccessor[nSrcs];
        int minX = destRect.x;
        int minY = destRect.y;
        for (int i = 0; i < nSrcs; ++i) {
            pas[i] = new PixelAccessor(sources[i].getSampleModel(), this.colorModels[i]);
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels(dest, destRect, destType, true);
        int[][] dstdata = (int[][])dimd.data;
        if (this.caseA) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    int[] dstdatabandb = dstdata[db];
                    int[][] srcdata = (int[][])simd.data;
                    int[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else if (this.caseB) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        int[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                int[][] srcdata = (int[][])simd.data;
                                int[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataInt;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    int[] dstdatabandb = dstdata[db];
                    int[][] srcdata = (int[][])simd.data;
                    int[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = this.noData[sindex].contains(srcdatabandsb[srcpos]) ? this.destNoDataInt : srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        int[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                int[][] srcdata = (int[][])simd.data;
                                int[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    int value = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.noData[sindex].contains(value) ? this.destNoDataInt : value;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataInt;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void floatLoop(Raster[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        PixelAccessor[] pas = new PixelAccessor[nSrcs];
        int minX = destRect.x;
        int minY = destRect.y;
        for (int i = 0; i < nSrcs; ++i) {
            pas[i] = new PixelAccessor(sources[i].getSampleModel(), this.colorModels[i]);
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels(dest, destRect, destType, true);
        float[][] dstdata = (float[][])dimd.data;
        if (this.caseA) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    float[] dstdatabandb = dstdata[db];
                    float[][] srcdata = (float[][])simd.data;
                    float[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else if (this.caseB) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        float[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                float[][] srcdata = (float[][])simd.data;
                                float[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataFloat;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    float[] dstdatabandb = dstdata[db];
                    float[][] srcdata = (float[][])simd.data;
                    float[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = this.noData[sindex].contains(srcdatabandsb[srcpos]) ? this.destNoDataFloat : srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        float[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                float[][] srcdata = (float[][])simd.data;
                                float[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    float value = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.noData[sindex].contains(value) ? this.destNoDataFloat : value;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataFloat;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void doubleLoop(Raster[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        PixelAccessor[] pas = new PixelAccessor[nSrcs];
        int minX = destRect.x;
        int minY = destRect.y;
        for (int i = 0; i < nSrcs; ++i) {
            pas[i] = new PixelAccessor(sources[i].getSampleModel(), this.colorModels[i]);
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels(dest, destRect, destType, true);
        double[][] dstdata = (double[][])dimd.data;
        if (this.caseA) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    double[] dstdatabandb = dstdata[db];
                    double[][] srcdata = (double[][])simd.data;
                    double[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else if (this.caseB) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        double[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                double[][] srcdata = (double[][])simd.data;
                                double[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataDouble;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                for (int sb = 0; sb < snbands[sindex] && db < dnbands; ++sb, ++db) {
                    double[] dstdatabandb = dstdata[db];
                    double[][] srcdata = (double[][])simd.data;
                    double[] srcdatabandsb = srcdata[sb];
                    int srcstart = simd.bandOffsets[sb];
                    int dststart = dimd.bandOffsets[db];
                    int y = 0;
                    while (y < destRect.height) {
                        int i = 0;
                        int srcpos = srcstart;
                        int dstpos = dststart;
                        while (i < dRectWidth) {
                            dstdatabandb[dstpos] = this.noData[sindex].contains(srcdatabandsb[srcpos]) ? this.destNoDataDouble : srcdatabandsb[srcpos];
                            ++i;
                            srcpos += srcPixelStride;
                            dstpos += dstPixelStride;
                        }
                        ++y;
                        srcstart += srcLineStride;
                        dststart += dstLineStride;
                    }
                }
            }
        } else {
            int db = 0;
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                UnpackedImageData simd = this.colorModels[sindex] instanceof IndexColorModel ? pas[sindex].getComponents(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType()) : pas[sindex].getPixels(sources[sindex], destRect, sources[sindex].getSampleModel().getTransferType(), false);
                int srcPixelStride = simd.pixelStride;
                int srcLineStride = simd.lineStride;
                int dstPixelStride = dimd.pixelStride;
                int dstLineStride = dimd.lineStride;
                int dRectWidth = destRect.width;
                int srcstart = 0;
                int dststart = 0;
                int y = 0;
                while (y < destRect.height) {
                    int i = 0;
                    int srcpos = srcstart;
                    int dstpos = dststart;
                    while (i < dRectWidth) {
                        double[] dstdatabandb;
                        int dbidx;
                        int sb;
                        if (roiTile.contains(i + minX, y + minY)) {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                double[][] srcdata = (double[][])simd.data;
                                double[] srcdatabandsb = srcdata[sb];
                                if (db < dnbands) {
                                    double value = srcdatabandsb[srcpos + simd.bandOffsets[sb]];
                                    dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.noData[sindex].contains(value) ? this.destNoDataDouble : value;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex]; ++sb) {
                                dbidx = db + sb;
                                dstdatabandb = dstdata[dbidx];
                                dstdatabandb[dstpos + dimd.bandOffsets[dbidx]] = this.destNoDataDouble;
                            }
                        }
                        ++i;
                        srcpos += srcPixelStride;
                        dstpos += dstPixelStride;
                    }
                    ++y;
                    srcstart += srcLineStride;
                    dststart += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private static Vector vectorize(List sources) {
        if (sources instanceof Vector) {
            return (Vector)sources;
        }
        Vector vector = new Vector(sources.size());
        for (Object element : sources) {
            vector.add(element);
        }
        return vector;
    }
}

