/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.FeatureIteratorImpl;
import org.geotools.feature.collection.SimpleFeatureIteratorImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;
import org.opengis.util.ProgressListener;

public class TreeSetFeatureCollection
implements SimpleFeatureCollection {
    protected static Logger LOGGER = Logging.getLogger("org.geotools.data.collection");
    private SortedMap<String, SimpleFeature> contents = new TreeMap<String, SimpleFeature>();
    private ReferencedEnvelope bounds = null;
    protected String id;
    protected SimpleFeatureType schema;

    public TreeSetFeatureCollection() {
        this(null, null);
    }

    public TreeSetFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this(collection.getID(), collection.getSchema());
        this.addAll(collection);
    }

    public TreeSetFeatureCollection(String id, SimpleFeatureType memberType) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = memberType;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope();
            Iterator<SimpleFeature> i = this.contents.values().iterator();
            while (i.hasNext()) {
                BoundingBox geomBounds = i.next().getBounds();
                if (geomBounds.isEmpty()) continue;
                this.bounds.include(geomBounds);
            }
        }
        return this.bounds;
    }

    public boolean add(SimpleFeature feature) {
        if (feature == null) {
            return false;
        }
        String ID = feature.getID();
        if (ID == null) {
            return false;
        }
        if (this.contents.containsKey(ID)) {
            return false;
        }
        if (this.schema == null) {
            this.schema = feature.getFeatureType();
        }
        SimpleFeatureType childType = this.getSchema();
        if (!feature.getFeatureType().equals(childType)) {
            LOGGER.warning("Feature Collection contains a heterogeneous mix of features");
        }
        this.contents.put(ID, feature);
        return true;
    }

    @Deprecated
    protected boolean add(SimpleFeature feature, boolean fire) {
        return this.add(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<SimpleFeature> featuresAdded = new ArrayList<SimpleFeature>(collection.size());
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                boolean added = this.add(f);
                changed |= added;
                if (!added) continue;
                featuresAdded.add(f);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            DataUtilities.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(FeatureCollection<?, ?> collection) {
        boolean changed = false;
        try (FeatureIterator<?> iterator = collection.features();){
            ArrayList<SimpleFeature> featuresAdded = new ArrayList<SimpleFeature>(collection.size());
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                boolean added = this.add(f);
                changed |= added;
                if (!added) continue;
                featuresAdded.add(f);
            }
            boolean bl = changed;
            return bl;
        }
    }

    public void clear() {
        if (this.contents.isEmpty()) {
            return;
        }
        SimpleFeature[] oldFeatures = new SimpleFeature[this.contents.size()];
        oldFeatures = this.contents.values().toArray(oldFeatures);
        this.contents.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof SimpleFeature)) {
            return false;
        }
        SimpleFeature feature = (SimpleFeature)o;
        String ID = feature.getID();
        return this.contents.containsKey(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                if (this.contents.containsKey(feature.getID())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            DataUtilities.close(iterator);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public Iterator<SimpleFeature> iterator() {
        final Iterator<SimpleFeature> iterator = this.contents.values().iterator();
        return new Iterator<SimpleFeature>(){
            SimpleFeature currFeature = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SimpleFeature next() {
                this.currFeature = (SimpleFeature)iterator.next();
                return this.currFeature;
            }

            @Override
            public void remove() {
                iterator.remove();
                TreeSetFeatureCollection.this.bounds = null;
            }
        };
    }

    @Override
    public SimpleFeatureIterator features() {
        return new SimpleFeatureIteratorImpl(this.contents.values());
    }

    public boolean remove(Object o) {
        if (!(o instanceof SimpleFeature)) {
            return false;
        }
        SimpleFeature f = (SimpleFeature)o;
        boolean changed = this.contents.values().remove(f);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<SimpleFeature> removedFeatures = new ArrayList<SimpleFeature>(collection.size());
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                boolean removed = this.contents.values().remove(f);
                if (!removed) continue;
                changed = true;
                removedFeatures.add(f);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            DataUtilities.close(iterator);
        }
    }

    public boolean retainAll(Collection collection) {
        ArrayList<SimpleFeature> removedFeatures = new ArrayList<SimpleFeature>(this.contents.size() - collection.size());
        boolean modified = false;
        Iterator<SimpleFeature> it = this.contents.values().iterator();
        while (it.hasNext()) {
            SimpleFeature f = it.next();
            if (collection.contains(f)) continue;
            it.remove();
            modified = true;
            removedFeatures.add(f);
        }
        return modified;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public Object[] toArray() {
        return this.contents.values().toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.contents.values().toArray(a != null ? a : new Object[this.contents.size()]);
    }

    public void close(FeatureIterator<SimpleFeature> close) {
        if (close instanceof FeatureIteratorImpl) {
            FeatureIteratorImpl wrapper = (FeatureIteratorImpl)close;
            wrapper.close();
        }
    }

    public void close(Iterator close) {
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        final SimpleFeatureIterator iterator = this.features();
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){

            @Override
            public SimpleFeatureType getFeatureType() {
                return TreeSetFeatureCollection.this.getSchema();
            }

            @Override
            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                return (SimpleFeature)iterator.next();
            }

            @Override
            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            @Override
            public void close() throws IOException {
                TreeSetFeatureCollection.this.close(iterator);
            }
        };
    }

    public int getCount() throws IOException {
        return this.contents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureCollection collection() throws IOException {
        TreeSetFeatureCollection copy = new TreeSetFeatureCollection(null, this.getSchema());
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(this.contents.size());
        try (SimpleFeatureIterator iterator = this.features();){
            while (iterator.hasNext()) {
                SimpleFeature duplicate;
                SimpleFeature feature = (SimpleFeature)iterator.next();
                try {
                    duplicate = SimpleFeatureBuilder.copy(feature);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to copy " + feature.getID(), e);
                }
                list.add(duplicate);
            }
        }
        copy.addAll(list);
        return copy;
    }

    public Set<String> fids() {
        return Collections.unmodifiableSet(this.contents.keySet());
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        CollectionFeatureSource temp = new CollectionFeatureSource(this);
        return temp.getFeatures(filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        Query subQuery = new Query(this.getSchema().getTypeName());
        subQuery.setSortBy(new SortBy[]{order});
        CollectionFeatureSource temp = new CollectionFeatureSource(this);
        return temp.getFeatures(subQuery);
    }

    public void purge() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }
}

