/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialRddTool;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.IndexType;

public final class IndexBuilder<T extends Geometry>
implements FlatMapFunction<Iterator<T>, SpatialIndex> {
    IndexType indexType;

    public IndexBuilder(IndexType indexType) {
        this.indexType = indexType;
    }

    public Iterator<SpatialIndex> call(Iterator<T> objectIterator) throws Exception {
        Serializable spatialIndex = this.indexType == IndexType.RTREE ? new STRtree() : new Quadtree();
        while (objectIterator.hasNext()) {
            Geometry spatialObject = (Geometry)objectIterator.next();
            spatialIndex.insert(spatialObject.getEnvelopeInternal(), spatialObject);
        }
        HashSet<Serializable> result = new HashSet<Serializable>();
        spatialIndex.query(new Envelope(0.0, 0.0, 0.0, 0.0));
        result.add(spatialIndex);
        return result.iterator();
    }
}

