/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialRDD;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.datasyslab.geospark.geometryObjects.Circle;
import org.datasyslab.geospark.spatialRDD.LineStringRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;

public class CircleRDD
extends SpatialRDD<Circle> {
    public CircleRDD(JavaRDD<Circle> circleRDD) {
        this.rawSpatialRDD = circleRDD;
    }

    public CircleRDD(JavaRDD<Circle> circleRDD, String sourceEpsgCRSCode, String targetEpsgCRSCode) {
        this.rawSpatialRDD = circleRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCRSCode);
    }

    public CircleRDD(SpatialRDD spatialRDD, Double Radius) {
        final Double radius = Radius;
        this.rawSpatialRDD = spatialRDD.rawSpatialRDD.map((Function)new Function<Object, Object>(){

            public Object call(Object v1) {
                return new Circle((Geometry)v1, radius);
            }
        });
        this.CRStransformation = spatialRDD.CRStransformation;
        this.sourceEpsgCode = spatialRDD.sourceEpsgCode;
        this.targetEpgsgCode = spatialRDD.targetEpgsgCode;
    }

    public PointRDD getCenterPointAsSpatialRDD() {
        return new PointRDD((JavaRDD<Point>)this.rawSpatialRDD.map((Function)new Function<Circle, Point>(){

            public Point call(Circle circle) {
                return (Point)circle.getCenterGeometry();
            }
        }));
    }

    public PolygonRDD getCenterPolygonAsSpatialRDD() {
        return new PolygonRDD((JavaRDD<Polygon>)this.rawSpatialRDD.map((Function)new Function<Circle, Polygon>(){

            public Polygon call(Circle circle) {
                return (Polygon)circle.getCenterGeometry();
            }
        }));
    }

    public LineStringRDD getCenterLineStringRDDAsSpatialRDD() {
        return new LineStringRDD((JavaRDD<LineString>)this.rawSpatialRDD.map((Function)new Function<Circle, LineString>(){

            public LineString call(Circle circle) {
                return (LineString)circle.getCenterGeometry();
            }
        }));
    }

    public RectangleRDD getCenterRectangleRDDAsSpatialRDD() {
        return new RectangleRDD((JavaRDD<Polygon>)this.rawSpatialRDD.map((Function)new Function<Circle, Polygon>(){

            public Polygon call(Circle circle) {
                return (Polygon)circle.getCenterGeometry();
            }
        }));
    }
}

