/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;
import java.util.List;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadRectangle;
import org.datasyslab.geospark.spatialPartitioning.quadtree.StandardQuadTree;

public class QuadtreePartitioning
implements Serializable {
    private final StandardQuadTree<Integer> partitionTree;

    public QuadtreePartitioning(List<Envelope> samples, Envelope boundary, int partitions) throws Exception {
        this(samples, boundary, partitions, -1);
    }

    public QuadtreePartitioning(List<Envelope> samples, Envelope boundary, int partitions, int minTreeLevel) throws Exception {
        int maxLevel = partitions;
        int maxItemsPerNode = samples.size() / partitions;
        this.partitionTree = new StandardQuadTree(new QuadRectangle(boundary), 0, maxItemsPerNode, maxLevel);
        if (minTreeLevel > 0) {
            this.partitionTree.forceGrowUp(minTreeLevel);
        }
        for (Envelope sample : samples) {
            this.partitionTree.insert(new QuadRectangle(sample), 1);
        }
        this.partitionTree.assignPartitionIds();
    }

    public StandardQuadTree getPartitionTree() {
        return this.partitionTree;
    }
}

