/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import org.apache.log4j.Logger;
import org.apache.spark.serializer.KryoRegistrator;
import org.datasyslab.geospark.geometryObjects.Circle;
import org.datasyslab.geospark.geometryObjects.GeometrySerde;
import org.datasyslab.geospark.geometryObjects.SpatialIndexSerde;

public class GeoSparkKryoRegistrator
implements KryoRegistrator {
    static final Logger log = Logger.getLogger(GeoSparkKryoRegistrator.class);

    public void registerClasses(Kryo kryo) {
        GeometrySerde serializer = new GeometrySerde();
        SpatialIndexSerde indexSerializer = new SpatialIndexSerde(serializer);
        log.info((Object)"Registering custom serializers for geometry types");
        kryo.register(Point.class, (Serializer)serializer);
        kryo.register(LineString.class, (Serializer)serializer);
        kryo.register(Polygon.class, (Serializer)serializer);
        kryo.register(MultiPoint.class, (Serializer)serializer);
        kryo.register(MultiLineString.class, (Serializer)serializer);
        kryo.register(MultiPolygon.class, (Serializer)serializer);
        kryo.register(GeometryCollection.class, (Serializer)serializer);
        kryo.register(Circle.class, (Serializer)serializer);
        kryo.register(Envelope.class, (Serializer)serializer);
        kryo.register(Quadtree.class, (Serializer)indexSerializer);
        kryo.register(STRtree.class, (Serializer)indexSerializer);
    }
}

