/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.joinJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.datasyslab.geospark.joinJudgement.DedupParams;
import org.datasyslab.geospark.joinJudgement.JudgementBase;

public class RightIndexLookupJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase
implements FlatMapFunction2<Iterator<T>, Iterator<SpatialIndex>, Pair<T, U>>,
Serializable {
    public RightIndexLookupJudgement(boolean considerBoundaryIntersection, @Nullable DedupParams dedupParams) {
        super(considerBoundaryIntersection, dedupParams);
    }

    public Iterator<Pair<T, U>> call(Iterator<T> streamShapes, Iterator<SpatialIndex> indexIterator) throws Exception {
        ArrayList<Pair> result = new ArrayList<Pair>();
        if (!indexIterator.hasNext() || !streamShapes.hasNext()) {
            return result.iterator();
        }
        this.initPartition();
        SpatialIndex treeIndex = indexIterator.next();
        while (streamShapes.hasNext()) {
            Geometry streamShape = (Geometry)streamShapes.next();
            List candidates = treeIndex.query(streamShape.getEnvelopeInternal());
            for (Geometry candidate : candidates) {
                if (!this.match(streamShape, candidate)) continue;
                result.add(Pair.of((Object)streamShape, (Object)candidate));
            }
        }
        return result.iterator();
    }
}

