/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.shapes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReaderFactory;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShpRecord;

public class PrimitiveShape
implements Serializable {
    private final byte[] primitiveRecord;
    private final ShapeType shapeType;
    private String attributes = null;

    public PrimitiveShape(ShpRecord record) {
        this.primitiveRecord = record.getBytes().getBytes();
        this.shapeType = ShapeType.getType(record.getTypeID());
    }

    public byte[] getPrimitiveRecord() {
        return this.primitiveRecord;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Geometry getShape(GeometryFactory geometryFactory) throws IOException, TypeUnknownException {
        ShapeParser parser = this.shapeType.getParser(geometryFactory);
        ByteBuffer shapeBuffer = ByteBuffer.wrap(this.primitiveRecord);
        Geometry shape = parser.parseShape(ShapeReaderFactory.fromByteBuffer(shapeBuffer));
        if (this.attributes != null) {
            shape.setUserData(this.attributes);
        }
        return shape;
    }
}

