/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.boundary;

import java.io.Serializable;
import java.util.Arrays;

public class BoundBox
implements Serializable {
    double[] bounds = null;

    public BoundBox(double[] bounds) {
        this.bounds = Arrays.copyOf(bounds, bounds.length);
    }

    public BoundBox(BoundBox otherbox) {
        this.bounds = otherbox.copyBounds();
    }

    public BoundBox() {
        this.bounds = new double[8];
    }

    public void set(int i, double value) {
        this.bounds[i] = value;
    }

    public double[] copyBounds() {
        return Arrays.copyOf(this.bounds, this.bounds.length);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < this.bounds.length; ++i) {
            strBuilder.append(this.bounds[i] + ", ");
        }
        return strBuilder.toString();
    }

    public void setXMin(double value) {
        this.bounds[0] = value;
    }

    public void setYMin(double value) {
        this.bounds[1] = value;
    }

    public void setXMax(double value) {
        this.bounds[2] = value;
    }

    public void setYMax(double value) {
        this.bounds[3] = value;
    }

    public void setZMin(double value) {
        this.bounds[4] = value;
    }

    public void setZMax(double value) {
        this.bounds[5] = value;
    }

    public void setMMin(double value) {
        this.bounds[6] = value;
    }

    public void setMMax(double value) {
        this.bounds[7] = value;
    }

    public double getXMin() {
        return this.bounds[0];
    }

    public double getXMax() {
        return this.bounds[2];
    }

    public double getYMin() {
        return this.bounds[1];
    }

    public double getYMax() {
        return this.bounds[3];
    }

    public double getZMin() {
        return this.bounds[4];
    }

    public double getZMax() {
        return this.bounds[5];
    }

    public double getMMin() {
        return this.bounds[6];
    }

    public double getMMax() {
        return this.bounds[7];
    }

    public static BoundBox mergeBoundBox(BoundBox box1, BoundBox box2) {
        BoundBox box = new BoundBox();
        box.setXMin(Math.min(box1.getXMin(), box2.getXMin()));
        box.setXMax(Math.max(box1.getXMax(), box2.getXMax()));
        box.setYMin(Math.min(box1.getYMin(), box2.getYMin()));
        box.setYMax(Math.max(box1.getYMax(), box2.getYMax()));
        box.setZMin(Math.min(box1.getZMin(), box2.getZMin()));
        box.setZMax(Math.max(box1.getZMax(), box2.getZMax()));
        box.setMMin(Math.min(box1.getMMin(), box2.getMMin()));
        box.setMMax(Math.max(box1.getMMax(), box2.getMMax()));
        return box;
    }
}

