/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;

public class LineStringFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, LineString> {
    public LineStringFormatMapper(FileDataSplitter Splitter2, boolean carryInputData) {
        super(Splitter2, carryInputData);
    }

    public LineStringFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter2, boolean carryInputData) {
        super(startOffset, endOffset, Splitter2, carryInputData);
    }

    public Iterator<LineString> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<LineString> result = new ArrayList<LineString>();
        block4: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            switch (this.splitter) {
                case GEOJSON: {
                    Geometry geometry = this.readGeoJSON(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
                case WKT: {
                    Geometry geometry = this.readWkt(line);
                    this.addGeometry(geometry, result);
                    continue block4;
                }
            }
            Coordinate[] coordinates = this.readCoordinates(line);
            LineString lineString = this.factory.createLineString(coordinates);
            if (this.carryInputData) {
                lineString.setUserData(line);
            }
            result.add(lineString);
        }
        return result.iterator();
    }

    private void addGeometry(Geometry geometry, List<LineString> result) {
        if (geometry instanceof MultiLineString) {
            this.addMultiGeometry((MultiLineString)geometry, result);
        } else {
            result.add((LineString)geometry);
        }
    }
}

