/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.enums.GeometryType;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class FormatMapper
implements Serializable {
    protected final int startOffset;
    protected final int endOffset;
    protected final FileDataSplitter splitter;
    protected final boolean carryInputData;
    protected GeometryType geometryType = null;
    protected transient GeometryFactory factory = new GeometryFactory();
    protected transient GeoJSONReader geoJSONReader = new GeoJSONReader();
    protected transient WKTReader wktReader = new WKTReader();

    public FormatMapper(int startOffset, int endOffset, FileDataSplitter splitter, boolean carryInputData) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.splitter = splitter;
        this.carryInputData = carryInputData;
    }

    public FormatMapper(FileDataSplitter splitter, boolean carryInputData) {
        this(0, -1, splitter, carryInputData);
    }

    public FormatMapper(int startOffset, int endOffset, FileDataSplitter splitter, boolean carryInputData, GeometryType geometryType) {
        this(startOffset, endOffset, splitter, carryInputData);
        this.geometryType = geometryType;
    }

    public FormatMapper(FileDataSplitter splitter, boolean carryInputData, GeometryType geometryType) {
        this(splitter, carryInputData);
        this.geometryType = geometryType;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.factory = new GeometryFactory();
        this.wktReader = new WKTReader();
        this.geoJSONReader = new GeoJSONReader();
    }

    public Geometry readGeoJSON(String geoJson) {
        Geometry geometry;
        if (geoJson.contains("Feature")) {
            Feature feature = (Feature)GeoJSONFactory.create(geoJson);
            geometry = this.geoJSONReader.read(feature.getGeometry());
        } else {
            geometry = this.geoJSONReader.read(geoJson);
        }
        if (this.carryInputData) {
            geometry.setUserData(geoJson);
        }
        return geometry;
    }

    public Geometry readWkt(String line) throws ParseException {
        String[] columns = line.split(this.splitter.getDelimiter());
        Geometry geometry = this.wktReader.read(columns[this.startOffset]);
        if (this.carryInputData) {
            geometry.setUserData(line);
        }
        return geometry;
    }

    public Coordinate[] readCoordinates(String line) {
        String[] columns = line.split(this.splitter.getDelimiter());
        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : columns.length - 1;
        Coordinate[] coordinates = new Coordinate[(actualEndOffset - this.startOffset + 1) / 2];
        for (int i = this.startOffset; i <= actualEndOffset; i += 2) {
            coordinates[i / 2] = new Coordinate(Double.parseDouble(columns[i]), Double.parseDouble(columns[i + 1]));
        }
        return coordinates;
    }

    public <T extends Geometry> void addMultiGeometry(GeometryCollection multiGeometry, List<T> result) {
        for (int i = 0; i < multiGeometry.getNumGeometries(); ++i) {
            Geometry geometry = multiGeometry.getGeometryN(i);
            geometry.setUserData(multiGeometry.getUserData());
            result.add(geometry);
        }
    }

    public Geometry readGeometry(String line) throws ParseException {
        switch (this.splitter) {
            case WKT: {
                return this.readWkt(line);
            }
            case GEOJSON: {
                return this.readGeoJSON(line);
            }
        }
        if (this.geometryType == null) {
            throw new IllegalArgumentException("[GeoSpark][FormatMapper] You must specify GeometryType when you use delimiter rather WKT or GeoJSON");
        }
        return this.createGeometry(this.readCoordinates(line), this.geometryType);
    }

    private Geometry createGeometry(Coordinate[] coordinates, GeometryType geometryType) {
        GeometryFactory geometryFactory = new GeometryFactory();
        switch (geometryType) {
            case POINT: {
                return geometryFactory.createPoint(coordinates[0]);
            }
            case POLYGON: {
                return geometryFactory.createPolygon(coordinates);
            }
            case LINESTRING: {
                return geometryFactory.createLineString(coordinates);
            }
        }
        return geometryFactory.createPoint(coordinates[0]);
    }
}

