/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;

public class NonRobustLineIntersector
extends LineIntersector {
    public static boolean isSameSignAndNonZero(double a, double b) {
        if (a == 0.0 || b == 0.0) {
            return false;
        }
        return a < 0.0 && b < 0.0 || a > 0.0 && b > 0.0;
    }

    @Override
    public void computeIntersection(Coordinate p, Coordinate p1, Coordinate p2) {
        this.isProper = false;
        double a1 = p2.y - p1.y;
        double b1 = p1.x - p2.x;
        double c1 = p2.x * p1.y - p1.x * p2.y;
        double r = a1 * p.x + b1 * p.y + c1;
        if (r != 0.0) {
            this.result = 0;
            return;
        }
        double dist = this.rParameter(p1, p2, p);
        if (dist < 0.0 || dist > 1.0) {
            this.result = 0;
            return;
        }
        this.isProper = true;
        if (p.equals(p1) || p.equals(p2)) {
            this.isProper = false;
        }
        this.result = 1;
    }

    @Override
    protected int computeIntersect(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        this.isProper = false;
        double a1 = p2.y - p1.y;
        double b1 = p1.x - p2.x;
        double c1 = p2.x * p1.y - p1.x * p2.y;
        double r3 = a1 * p3.x + b1 * p3.y + c1;
        double r4 = a1 * p4.x + b1 * p4.y + c1;
        if (r3 != 0.0 && r4 != 0.0 && NonRobustLineIntersector.isSameSignAndNonZero(r3, r4)) {
            return 0;
        }
        double a2 = p4.y - p3.y;
        double b2 = p3.x - p4.x;
        double c2 = p4.x * p3.y - p3.x * p4.y;
        double r1 = a2 * p1.x + b2 * p1.y + c2;
        double r2 = a2 * p2.x + b2 * p2.y + c2;
        if (r1 != 0.0 && r2 != 0.0 && NonRobustLineIntersector.isSameSignAndNonZero(r1, r2)) {
            return 0;
        }
        double denom = a1 * b2 - a2 * b1;
        if (denom == 0.0) {
            return this.computeCollinearIntersection(p1, p2, p3, p4);
        }
        double numX = b1 * c2 - b2 * c1;
        this.pa.x = numX / denom;
        double numY = a2 * c1 - a1 * c2;
        this.pa.y = numY / denom;
        this.isProper = true;
        if (this.pa.equals(p1) || this.pa.equals(p2) || this.pa.equals(p3) || this.pa.equals(p4)) {
            this.isProper = false;
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(this.pa);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        double t4;
        Coordinate q4;
        double t3;
        Coordinate q3;
        double r4;
        double r1 = 0.0;
        double r2 = 1.0;
        double r3 = this.rParameter(p1, p2, p3);
        if (r3 < (r4 = this.rParameter(p1, p2, p4))) {
            q3 = p3;
            t3 = r3;
            q4 = p4;
            t4 = r4;
        } else {
            q3 = p4;
            t3 = r4;
            q4 = p3;
            t4 = r3;
        }
        if (t3 > r2 || t4 < r1) {
            return 0;
        }
        if (q4 == p1) {
            this.pa.setCoordinate(p1);
            return 1;
        }
        if (q3 == p2) {
            this.pa.setCoordinate(p2);
            return 1;
        }
        this.pa.setCoordinate(p1);
        if (t3 > r1) {
            this.pa.setCoordinate(q3);
        }
        this.pb.setCoordinate(p2);
        if (t4 < r2) {
            this.pb.setCoordinate(q4);
        }
        return 2;
    }

    private double rParameter(Coordinate p1, Coordinate p2, Coordinate p) {
        double dy;
        double dx = Math.abs(p2.x - p1.x);
        double r = dx > (dy = Math.abs(p2.y - p1.y)) ? (p.x - p1.x) / (p2.x - p1.x) : (p.y - p1.y) / (p2.y - p1.y);
        return r;
    }
}

