/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.datanucleus.maven.AbstractDataNucleusMojo;

public abstract class AbstractSchemaToolMojo
extends AbstractDataNucleusMojo {
    private static final String TOOL_NAME_SCHEMA_TOOL = "org.datanucleus.store.schema.SchemaTool";
    private String props;
    private Properties toolProperties;
    protected String catalogName;
    protected String schemaName;
    protected String ddlFile;
    protected boolean completeDdl;
    protected boolean includeAutoStart;
    private List classpathElements;

    @Override
    List getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected void executeDataNucleusTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        this.executeSchemaTool(pluginArtifacts, files);
    }

    private void executeSchemaTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        ArrayList<String> cpEntries = new ArrayList<String>();
        for (Artifact artifact : pluginArtifacts) {
            try {
                String artifactPath = artifact.getFile().getCanonicalPath();
                if (cpEntries.contains(artifactPath)) continue;
                cpEntries.add(artifactPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        for (String entry : this.getUniqueClasspathElements()) {
            if (cpEntries.contains(entry)) continue;
            cpEntries.add(entry);
        }
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it = cpEntries.iterator();
        while (it.hasNext()) {
            cpBuffer.append((String)it.next());
            if (!it.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        if (this.fork) {
            URL log4jURL;
            Commandline cl = new Commandline();
            cl.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), "java").getAbsolutePath());
            cl.createArg().setValue("-cp");
            cl.createArg().setValue(cpBuffer.toString());
            Properties systemProperties = System.getProperties();
            if (this.toolProperties != null) {
                Set<Object> toolPropertyKeys = this.toolProperties.keySet();
                for (String string : toolPropertyKeys) {
                    if (!systemProperties.containsKey(string)) continue;
                    this.toolProperties.put(string, systemProperties.getProperty(string));
                    this.getLog().warn((CharSequence)("Property '" + string + "' value specified in pom configuration will be overridden."));
                }
                for (String string : toolPropertyKeys) {
                    String val = this.toolProperties.getProperty(string) != null ? this.toolProperties.getProperty(string) : "";
                    cl.createArg().setValue("-D" + string + "=" + val);
                }
            }
            if ((log4jURL = this.getLog4JConfiguration()) != null) {
                cl.createArg().setValue("-Dlog4j.configuration=" + log4jURL);
            } else {
                URL log4j2URL = this.getLog4JConfiguration();
                if (log4j2URL != null) {
                    cl.createArg().setValue("-Dlog4j.configurationFile=" + log4j2URL);
                } else {
                    URL uRL = this.getJdkLogConfiguration();
                    if (uRL != null) {
                        cl.createArg().setValue("-Djava.util.logging.config.file=" + uRL);
                    }
                }
            }
            cl.createArg().setValue(TOOL_NAME_SCHEMA_TOOL);
            this.prepareModeSpecificCommandLineArguments(cl, null);
            if (this.verbose) {
                cl.createArg().setValue("-v");
            }
            boolean usingPU = false;
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                usingPU = true;
                cl.createArg().setLine("-pu " + this.persistenceUnitName);
            }
            if (this.ignoreMetaDataForMissingClasses) {
                cl.createArg().setValue("-ignoreMetaDataForMissingClasses");
            }
            cl.createArg().setLine("-api " + this.api);
            if (this.props != null) {
                cl.createArg().setLine("-props " + this.props);
            }
            if (!usingPU) {
                for (File file : files) {
                    cl.createArg().setValue(file.getAbsolutePath());
                }
            }
            this.executeCommandLine(cl);
        } else {
            ArrayList<String> args = new ArrayList<String>();
            this.prepareModeSpecificCommandLineArguments(null, args);
            if (this.verbose) {
                args.add("-v");
            }
            boolean usingPU = false;
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                usingPU = true;
                args.add("-pu");
                args.add(this.persistenceUnitName);
            }
            if (this.ignoreMetaDataForMissingClasses) {
                args.add("-ignoreMetaDataForMissingClasses");
            }
            args.add("-api");
            args.add(this.api);
            if (this.props != null) {
                args.add("-props");
                args.add(this.props);
            }
            if (!usingPU) {
                for (File file : files) {
                    args.add(file.getAbsolutePath());
                }
            }
            this.executeInJvm(TOOL_NAME_SCHEMA_TOOL, args, cpEntries, false);
        }
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1, List var2);

    @Override
    protected String getToolName() {
        return TOOL_NAME_SCHEMA_TOOL;
    }
}

