/**********************************************************************
Copyright (c) 2017 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.api.jdo.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Extension annotation specifying either this field/method or use a surrogate column as storing the creation user for this object.
 * Only applies if specified on a String.
 */
@Target({ElementType.FIELD, ElementType.METHOD, ElementType.TYPE}) 
@Retention(RetentionPolicy.RUNTIME)
public @interface CreateUser
{
    /**
     * Name of the create user column in the table for this class when this is a surrogate (class-level) column.
     * @return The create user column name
     */
    String column() default "CREATE_USER";

    /**
     * Length of the create user column.
     * @return Length of the create user column.
     */
    int columnLength() default -1;
}