/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.AttributeConverter;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchPlan;
import javax.jdo.annotations.ForeignKey;
import javax.jdo.annotations.ForeignKeyAction;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.PersistenceModifier;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.SequenceStrategy;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.VersionStrategy;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOTypeConverter;
import org.datanucleus.api.jdo.JDOTypeConverterUtils;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.metadata.JDOAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOAnnotationReader
extends AbstractAnnotationReader {
    AnnotationObject persistenceCapableDefaults = null;

    public JDOAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.jdo", "org.datanucleus.api.jdo.annotations"});
        this.persistenceCapableDefaults = this.getAnnotationObjectsForAnnotations(PersistenceCapableModel.class.getSimpleName(), PersistenceCapableModel.class.getAnnotations())[0];
        this.addSupportedDuplicateAnnotations(PersistenceCapable.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        InterfaceMetaData cmd = null;
        AnnotationObject pcAnnotation = this.isClassPersistable(annotations);
        if (pcAnnotation != null) {
            cmd = cls.isInterface() ? pmd.newInterfaceMetadata(ClassUtils.getClassNameForClass((Class)cls)) : pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
            this.processPersistenceCapableAnnotation(cls, (AbstractClassMetaData)cmd, pcAnnotation.getNameValueMap());
        } else if (this.isClassPersistenceAware(annotations)) {
            cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_AWARE);
        } else if (this.doesClassHaveNamedQueries(annotations)) {
            cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.NON_PERSISTENT);
        } else {
            return null;
        }
        this.processNamedQueries((AbstractClassMetaData)cmd, cls, annotations);
        if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return cmd;
        }
        for (AnnotationObject annotation : annotations) {
            String name;
            Index[] values;
            FileMetaData filemd;
            String strategy;
            String annName = annotation.getName();
            if (annName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE)) continue;
            Map annotationValues = annotation.getNameValueMap();
            if (annName.equals(JDOAnnotationUtils.EMBEDDED_ONLY)) {
                cmd.setEmbeddedOnly(true);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.VERSION)) {
                VersionStrategy versionStrategy = (VersionStrategy)annotationValues.get("strategy");
                String string = JDOAnnotationUtils.getVersionStrategyString(versionStrategy);
                String indexed = (String)annotationValues.get("indexed");
                String column = (String)annotationValues.get("column");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                VersionMetaData vermd = new VersionMetaData();
                vermd.setStrategy(string);
                vermd.setColumnName(column);
                vermd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                if (columnArray != null && columnArray.length > 0) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columnArray[0]);
                    vermd.setColumnMetaData(colmd);
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)vermd, (Extension[])annotationValues.get("extensions"));
                vermd.setParent((MetaData)cmd);
                cmd.setVersionMetaData(vermd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.DATASTORE_IDENTITY)) {
                strategy = JDOAnnotationUtils.getValueGenerationStrategyString((IdGeneratorStrategy)annotationValues.get("strategy"));
                String string = (String)annotationValues.get("customStrategy");
                if (!StringUtils.isWhitespace((String)string)) {
                    strategy = string;
                }
                String sequence = (String)annotationValues.get("sequence");
                String column = (String)annotationValues.get("column");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                IdentityMetaData idmd = new IdentityMetaData();
                idmd.setColumnName(column);
                idmd.setValueStrategy(ValueGenerationStrategy.getIdentityStrategy((String)strategy));
                idmd.setSequence(sequence);
                if (columnArray != null && columnArray.length > 0) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columnArray[0]);
                    idmd.setColumnMetaData(colmd);
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)idmd, (Extension[])annotationValues.get("extensions"));
                idmd.setParent((MetaData)cmd);
                cmd.setIdentityMetaData(idmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                String pkName = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("column");
                Column[] columns = (Column[])annotationValues.get("columns");
                PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                pkmd.setName(pkName);
                pkmd.setColumnName(string);
                if (columns != null && columns.length > 0) {
                    for (Column column : columns) {
                        pkmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)pkmd, (Extension[])annotationValues.get("extensions"));
                pkmd.setParent((MetaData)cmd);
                cmd.setPrimaryKeyMetaData(pkmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.JOINS)) {
                Join[] js = (Join[])annotationValues.get("value");
                if (js == null || js.length <= 0) continue;
                for (Join join : js) {
                    JoinMetaData joinmd = cmd.newJoinMetaData();
                    joinmd.setTable(join.table());
                    joinmd.setColumnName(join.column());
                    joinmd.setIndexed(IndexedValue.getIndexedValue((String)join.indexed()));
                    joinmd.setOuter(MetaDataUtils.getBooleanForString((String)join.outer(), (boolean)false));
                    joinmd.setUnique(join.unique());
                    joinmd.setDeleteAction(JDOAnnotationUtils.getForeignKeyActionString(join.deleteAction()));
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)joinmd, join.extensions());
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.JOIN)) {
                JoinMetaData joinmd = cmd.newJoinMetaData();
                joinmd.setTable((String)annotationValues.get("table"));
                joinmd.setColumnName((String)annotationValues.get("column"));
                joinmd.setIndexed(IndexedValue.getIndexedValue((String)((String)annotationValues.get("indexed"))));
                joinmd.setOuter(MetaDataUtils.getBooleanForString((String)((String)annotationValues.get("outer")), (boolean)false));
                joinmd.setUnique((String)annotationValues.get("unique"));
                joinmd.setDeleteAction(((ForeignKeyAction)annotationValues.get("deleteAction")).toString());
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)joinmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INHERITANCE)) {
                InheritanceMetaData inhmd;
                strategy = JDOAnnotationUtils.getInheritanceStrategyString((InheritanceStrategy)annotationValues.get("strategy"));
                String string = (String)annotationValues.get("customStrategy");
                if (!StringUtils.isWhitespace((String)string)) {
                    strategy = string;
                }
                if ((inhmd = cmd.getInheritanceMetaData()) == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                inhmd.setStrategy(strategy);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.DISCRIMINATOR)) {
                DiscriminatorStrategy discriminatorStrategy = (DiscriminatorStrategy)annotationValues.get("strategy");
                String string = JDOAnnotationUtils.getDiscriminatorStrategyString(discriminatorStrategy);
                String column = (String)annotationValues.get("column");
                String indexed = (String)annotationValues.get("indexed");
                String string2 = (String)annotationValues.get("value");
                Column[] columns = (Column[])annotationValues.get("columns");
                InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetadata();
                dismd.setColumnName(column);
                dismd.setValue(string2);
                dismd.setStrategy(string);
                dismd.setIndexed(indexed);
                if (columns == null || columns.length <= 0) continue;
                ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
                dismd.setColumnMetaData(colmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHPLANS)) {
                void var17_77;
                FetchPlan[] fetchPlanArray;
                filemd = (FileMetaData)pmd.getParent();
                FetchPlan[] column = fetchPlanArray = (FetchPlan[])annotationValues.get("value");
                int indexed = column.length;
                boolean bl = false;
                while (var17_77 < indexed) {
                    FetchPlan plan = column[var17_77];
                    FetchPlanMetaData fpmd = filemd.newFetchPlanMetadata(plan.name());
                    fpmd.setFetchSize(plan.fetchSize());
                    fpmd.setMaxFetchDepth(plan.maxFetchDepth());
                    int numGroups = plan.fetchGroups().length;
                    for (int k = 0; k < numGroups; ++k) {
                        fpmd.addFetchGroup(new FetchGroupMetaData(plan.fetchGroups()[k]));
                    }
                    ++var17_77;
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHPLAN)) {
                String[] fpFetchGroups;
                filemd = (FileMetaData)pmd.getParent();
                FetchPlanMetaData fetchPlanMetaData = filemd.newFetchPlanMetadata((String)annotationValues.get("name"));
                fetchPlanMetaData.setFetchSize(((Integer)annotationValues.get("fetchSize")).intValue());
                fetchPlanMetaData.setMaxFetchDepth(((Integer)annotationValues.get("maxFetchDepth")).intValue());
                for (String fpFetchGroup : fpFetchGroups = (String[])annotationValues.get("fetchGroups")) {
                    fetchPlanMetaData.addFetchGroup(new FetchGroupMetaData(fpFetchGroup));
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHGROUPS)) {
                FetchGroup[] groups;
                for (FetchGroup fetchGroup : groups = (FetchGroup[])annotationValues.get("value")) {
                    FetchGroupMetaData fgmd = cmd.newFetchGroupMetaData(fetchGroup.name());
                    if (!StringUtils.isWhitespace((String)fetchGroup.postLoad())) {
                        fgmd.setPostLoad(Boolean.valueOf(fetchGroup.postLoad()));
                    }
                    int numFields = fetchGroup.members().length;
                    for (int k = 0; k < numFields; ++k) {
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)fgmd, fetchGroup.members()[k].name());
                        fgmmd.setRecursionDepth(fetchGroup.members()[k].recursionDepth());
                        fgmd.addMember(fgmmd);
                    }
                    int numGroups = fetchGroup.fetchGroups().length;
                    for (int k = 0; k < numGroups; ++k) {
                        fgmd.addFetchGroup(new FetchGroupMetaData(fetchGroup.fetchGroups()[k]));
                    }
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHGROUP)) {
                Persistent[] fields;
                FetchGroupMetaData fgmd = cmd.newFetchGroupMetaData((String)annotationValues.get("name"));
                String string = (String)annotationValues.get("postLoad");
                if (!StringUtils.isWhitespace((String)string)) {
                    fgmd.setPostLoad(Boolean.valueOf(string));
                }
                if ((fields = (Persistent[])annotationValues.get("members")) == null) continue;
                for (Persistent field : fields) {
                    FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)fgmd, field.name());
                    fgmmd.setRecursionDepth(field.recursionDepth());
                    fgmd.addMember(fgmmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.SEQUENCE)) {
                void var17_83;
                String seqName = (String)annotationValues.get("name");
                String string = JDOAnnotationUtils.getSequenceStrategyString((SequenceStrategy)annotationValues.get("strategy"));
                String seqSeq = (String)annotationValues.get("datastoreSequence");
                Class seqFactory = (Class)annotationValues.get("factoryClass");
                Object var17_81 = null;
                if (seqFactory != null && seqFactory != Void.TYPE) {
                    String string3 = seqFactory.getName();
                }
                Integer seqSize = (Integer)annotationValues.get("allocationSize");
                Integer seqStart = (Integer)annotationValues.get("initialValue");
                if (StringUtils.isWhitespace((String)seqName)) {
                    throw new InvalidClassMetaDataException("044155", new Object[]{cmd.getFullClassName()});
                }
                SequenceMetaData seqmd = new SequenceMetaData(seqName, string);
                seqmd.setFactoryClass((String)var17_83);
                seqmd.setDatastoreSequence(seqSeq);
                if (seqSize != null) {
                    seqmd.setAllocationSize(seqSize.intValue());
                }
                if (seqStart != null) {
                    seqmd.setInitialValue(seqStart.intValue());
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)seqmd, (Extension[])annotationValues.get("extensions"));
                cmd.getPackageMetaData().addSequence(seqmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INDICES)) {
                values = (Index[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Index index : values) {
                    IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(index.name(), index.table(), "" + index.unique(), index.members(), index.columns());
                    if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044204", (Object[])new Object[]{cls.getName()}));
                        continue;
                    }
                    cmd.addIndex(idxmd);
                    idxmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INDEX)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String unique = (String)annotationValues.get("unique");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(name, string, unique, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)idxmd, (Extension[])annotationValues.get("extensions"));
                if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044204", (Object[])new Object[]{cls.getName()}));
                    continue;
                }
                cmd.addIndex(idxmd);
                idxmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.UNIQUES)) {
                values = (Unique[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Index index : values) {
                    UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(index.name(), index.table(), "" + index.deferred(), index.members(), index.columns());
                    if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044205", (Object[])new Object[]{cls.getName()}));
                        continue;
                    }
                    cmd.addUniqueConstraint(unimd);
                    unimd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.UNIQUE)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String deferred = (String)annotationValues.get("deferred");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(name, string, deferred, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)unimd, (Extension[])annotationValues.get("extensions"));
                if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044205", (Object[])new Object[]{cls.getName()}));
                    continue;
                }
                cmd.addUniqueConstraint(unimd);
                unimd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FOREIGNKEYS)) {
                values = (ForeignKey[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Index index : values) {
                    String deleteAction = JDOAnnotationUtils.getForeignKeyActionString(index.deleteAction());
                    String updateAction = JDOAnnotationUtils.getForeignKeyActionString(index.updateAction());
                    ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(index.name(), index.table(), index.unique(), "" + index.deferred(), deleteAction, updateAction, index.members(), index.columns());
                    if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044206", (Object[])new Object[]{cls.getName()}));
                        continue;
                    }
                    cmd.addForeignKey(fkmd);
                    fkmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String unique = (String)annotationValues.get("unique");
                String deferred = (String)annotationValues.get("deferred");
                String string4 = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                String[] members = (String[])annotationValues.get("members");
                Column[] columns = (Column[])annotationValues.get("columns");
                ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(name, string, unique, deferred, string4, updateAction, members, columns);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)fkmd, (Extension[])annotationValues.get("extensions"));
                if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn((Object)Localiser.msg((String)"044206", (Object[])new Object[]{cls.getName()}));
                    continue;
                }
                cmd.addForeignKey(fkmd);
                fkmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.COLUMNS)) {
                Column[] cols = (Column[])annotationValues.get("value");
                if (cols == null || cols.length <= 0) continue;
                for (Column column : cols) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column);
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)colmd, column.extensions());
                    colmd.setParent((MetaData)cmd);
                    cmd.addUnmappedColumn(colmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.CACHEABLE)) {
                String cache = (String)annotationValues.get("value");
                if (cache == null || !cache.equalsIgnoreCase("false")) continue;
                cmd.setCacheable(false);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.EXTENSIONS)) {
                values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Index index : values) {
                    String vendorName = index.vendorName();
                    if (StringUtils.isWhitespace((String)vendorName)) {
                        throw new InvalidMetaDataException("044160", new Object[]{vendorName, index.key().toString(), index.value().toString()});
                    }
                    if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                    cmd.addExtension(index.key().toString(), index.value().toString());
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.EXTENSION)) {
                String vendorName = (String)annotationValues.get("vendorName");
                if (StringUtils.isWhitespace((String)vendorName)) {
                    throw new InvalidMetaDataException("044160", new Object[]{vendorName, annotationValues.get("key"), annotationValues.get("value")});
                }
                if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                cmd.addExtension((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE) || annName.equals(JDOAnnotationUtils.QUERIES) || annName.equals(JDOAnnotationUtils.QUERY)) continue;
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044203", (Object[])new Object[]{cls.getName(), annotation.getName()}));
        }
        NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044200", (Object[])new Object[]{cls.getName(), "JDO"}));
        return cmd;
    }

    private void processPersistenceCapableAnnotation(Class cls, AbstractClassMetaData cmd, Map<String, Object> annotationValues) {
        Persistent[] members;
        String schName;
        String catName;
        String identityType = JDOAnnotationUtils.getIdentityTypeString((javax.jdo.annotations.IdentityType)annotationValues.get("identityType"));
        cmd.setIdentityType(IdentityType.getIdentityType((String)identityType));
        Class idClass = (Class)annotationValues.get("objectIdClass");
        if (idClass != null && idClass != Void.TYPE) {
            cmd.setObjectIdClass(NucleusJDOHelper.getObjectIdClassForInputIdClass(idClass.getName()));
        }
        cmd.setEmbeddedOnly((String)annotationValues.get("embeddedOnly"));
        cmd.setCacheable((String)annotationValues.get("cacheable"));
        String serializeRead = (String)annotationValues.get("serializeRead");
        if (serializeRead != null) {
            cmd.setSerializeRead(serializeRead.equals("true"));
        }
        cmd.setRequiresExtent((String)annotationValues.get("requiresExtent"));
        if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.alwaysDetachable")) {
            cmd.setDetachable(true);
        } else {
            cmd.setDetachable((String)annotationValues.get("detachable"));
        }
        JDOAnnotationUtils.addExtensionsToMetaData((MetaData)cmd, (Extension[])annotationValues.get("extensions"));
        String tblName = (String)annotationValues.get("table");
        if (!StringUtils.isWhitespace((String)tblName)) {
            cmd.setTable(tblName);
        }
        if (!StringUtils.isWhitespace((String)(catName = (String)annotationValues.get("catalog")))) {
            cmd.setCatalog(catName);
        }
        if (!StringUtils.isWhitespace((String)(schName = (String)annotationValues.get("schema")))) {
            cmd.setSchema(schName);
        }
        if ((members = (Persistent[])annotationValues.get("members")) != null) {
            for (Persistent member : members) {
                String memberName = member.name();
                if (memberName.indexOf(46) > 0) {
                    memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                }
                boolean isField = this.isMemberOfClassAField(cls, memberName);
                AbstractMemberMetaData fmd = this.getFieldMetaDataForPersistent((MetaData)cmd, member, isField);
                cmd.addMember(fmd);
            }
        }
    }

    protected void processNamedQueries(AbstractClassMetaData cmd, Class cls, AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            Map annotationValues = annotation.getNameValueMap();
            String annName = annotation.getName();
            if (annName.equals(JDOAnnotationUtils.QUERIES)) {
                Query[] qs;
                for (Query query : qs = (Query[])annotationValues.get("value")) {
                    String resultClassName;
                    String lang = JDOAnnotationUtils.getQueryLanguageName(query.language());
                    if (!StringUtils.isWhitespace((String)lang)) {
                        if (lang.equals("javax.jdo.query.JDOQL")) {
                            lang = QueryLanguage.JDOQL.toString();
                        } else if (lang.equals("javax.jdo.query.SQL")) {
                            lang = QueryLanguage.SQL.toString();
                        } else if (lang.equals("javax.jdo.query.JPQL")) {
                            lang = QueryLanguage.JPQL.toString();
                        }
                    }
                    String string = resultClassName = query.resultClass() != null && query.resultClass() != Void.TYPE ? query.resultClass().getName() : null;
                    if (StringUtils.isWhitespace((String)query.name())) {
                        throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                    }
                    QueryMetaData qmd = new QueryMetaData(query.name());
                    qmd.setScope(cls.getName());
                    qmd.setLanguage(lang);
                    qmd.setUnmodifiable(query.unmodifiable());
                    qmd.setResultClass(resultClassName);
                    qmd.setUnique(query.unique());
                    qmd.setFetchPlanName(query.fetchPlan());
                    qmd.setQuery(query.value());
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)qmd, query.extensions());
                    cmd.addQuery(qmd);
                    qmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (!annName.equals(JDOAnnotationUtils.QUERY)) continue;
            String unmodifiable = "" + annotationValues.get("unmodifiable");
            Class resultClassValue = (Class)annotationValues.get("resultClass");
            String resultClassName = resultClassValue != null && resultClassValue != Void.TYPE ? resultClassValue.getName() : null;
            String lang = JDOAnnotationUtils.getQueryLanguageName((String)annotationValues.get("language"));
            if (!StringUtils.isWhitespace((String)lang)) {
                if (lang.equals("javax.jdo.query.JDOQL")) {
                    lang = QueryLanguage.JDOQL.toString();
                } else if (lang.equals("javax.jdo.query.SQL")) {
                    lang = QueryLanguage.SQL.toString();
                } else if (lang.equals("javax.jdo.query.JPQL")) {
                    lang = QueryLanguage.JPQL.toString();
                }
            }
            if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
            }
            QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
            qmd.setScope(cls.getName());
            qmd.setLanguage(lang);
            qmd.setUnmodifiable(unmodifiable);
            qmd.setResultClass(resultClassName);
            qmd.setUnique((String)annotationValues.get("unique"));
            qmd.setFetchPlanName((String)annotationValues.get("fetchPlan"));
            qmd.setQuery((String)annotationValues.get("value"));
            JDOAnnotationUtils.addExtensionsToMetaData((MetaData)qmd, (Extension[])annotationValues.get("extensions"));
            cmd.addQuery(qmd);
            qmd.setParent((MetaData)cmd);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        PropertyMetaData mmd = null;
        boolean primaryKey = false;
        boolean serialised = false;
        boolean embeddedMember = false;
        boolean nonPersistentField = false;
        boolean transactionalField = false;
        String cacheable = null;
        Class[] elementTypes = null;
        String embeddedElement = null;
        String serializedElement = null;
        String dependentElement = null;
        Class[] keyTypes = null;
        String embeddedKey = null;
        String serializedKey = null;
        String dependentKey = null;
        Class[] valueTypes = null;
        String embeddedValue = null;
        String serializedValue = null;
        String dependentValue = null;
        String embeddedOwnerField = null;
        String embeddedNullIndicatorColumn = null;
        String embeddedNullIndicatorValue = null;
        Persistent[] embeddedMembers = null;
        Persistent[] embeddedElementMembers = null;
        Persistent[] embeddedKeyMembers = null;
        Persistent[] embeddedValueMembers = null;
        ColumnMetaData[] colmds = null;
        JoinMetaData joinmd = null;
        ElementMetaData elemmd = null;
        KeyMetaData keymd = null;
        ValueMetaData valuemd = null;
        OrderMetaData ordermd = null;
        IndexMetaData idxmd = null;
        UniqueMetaData unimd = null;
        ForeignKeyMetaData fkmd = null;
        HashMap<String, String> extensions = null;
        Class convertConverterCls = null;
        for (AnnotationObject annotation : annotations) {
            String name;
            Column[] embeddedMappings;
            JDOTypeConverter typeConv;
            Class dbType;
            TypeManager typeMgr;
            Boolean disableConversion;
            Class converterCls;
            String uniqueName;
            String unique;
            String indexName;
            String string = annotation.getName();
            Map annotationValues = annotation.getNameValueMap();
            if (string.equals(JDOAnnotationUtils.PERSISTENT)) {
                FieldPersistenceModifier modifier;
                String pkStr = "" + annotationValues.get("primaryKey");
                Boolean pk = null;
                if (!StringUtils.isWhitespace((String)pkStr)) {
                    pk = Boolean.valueOf(pkStr);
                }
                String dfgStr = (String)annotationValues.get("defaultFetchGroup");
                Boolean dfg = null;
                if (!StringUtils.isWhitespace((String)dfgStr)) {
                    dfg = Boolean.valueOf(dfgStr);
                }
                String string2 = JDOAnnotationUtils.getNullValueString((NullValue)annotationValues.get("nullValue"));
                String embStr = (String)annotationValues.get("embedded");
                Boolean embedded = null;
                if (!StringUtils.isWhitespace((String)embStr)) {
                    embedded = Boolean.valueOf(embStr);
                }
                String serStr = (String)annotationValues.get("serialized");
                Boolean serialized = null;
                if (!StringUtils.isWhitespace((String)serStr)) {
                    serialized = Boolean.valueOf(serStr);
                }
                String depStr = (String)annotationValues.get("dependent");
                Boolean dependent = null;
                if (!StringUtils.isWhitespace((String)depStr)) {
                    dependent = Boolean.valueOf(depStr);
                }
                String valueStrategy = JDOAnnotationUtils.getValueGenerationStrategyString((IdGeneratorStrategy)annotationValues.get("valueStrategy"));
                String customValueStrategy = (String)annotationValues.get("customValueStrategy");
                if (!StringUtils.isWhitespace((String)customValueStrategy)) {
                    valueStrategy = customValueStrategy;
                }
                if ((modifier = JDOAnnotationUtils.getFieldPersistenceModifier((PersistenceModifier)annotationValues.get("persistenceModifier"))) == null) {
                    modifier = FieldPersistenceModifier.PERSISTENT;
                }
                String sequence = (String)annotationValues.get("sequence");
                String mappedBy = (String)annotationValues.get("mappedBy");
                String table = (String)annotationValues.get("table");
                String column = (String)annotationValues.get("column");
                String loadFetchGroup = (String)annotationValues.get("loadFetchGroup");
                String fieldTypeName = null;
                int recursionDepth = (Integer)annotationValues.get("recursionDepth");
                cacheable = (String)annotationValues.get("cacheable");
                Class[] fieldTypes = (Class[])annotationValues.get("types");
                if (fieldTypes != null && fieldTypes.length > 0) {
                    StringBuilder typeStr = new StringBuilder();
                    for (Class fieldType : fieldTypes) {
                        if (typeStr.length() > 0) {
                            typeStr.append(',');
                        }
                        if (fieldType == null || fieldType == Void.TYPE) continue;
                        typeStr.append(fieldType.getName());
                    }
                    fieldTypeName = typeStr.toString();
                }
                dependentElement = (String)annotationValues.get("dependentElement");
                serializedElement = (String)annotationValues.get("serializedElement");
                embeddedElement = (String)annotationValues.get("embeddedElement");
                dependentKey = (String)annotationValues.get("dependentKey");
                serializedKey = (String)annotationValues.get("serializedKey");
                embeddedKey = (String)annotationValues.get("embeddedKey");
                dependentValue = (String)annotationValues.get("dependentValue");
                serializedValue = (String)annotationValues.get("serializedValue");
                embeddedValue = (String)annotationValues.get("embeddedValue");
                Class converterCls2 = (Class)annotationValues.get("converter");
                if (converterCls2 == AttributeConverter.UseDefault.class) {
                    converterCls2 = null;
                }
                Boolean disableConversion2 = (Boolean)annotationValues.get("useDefaultConversion");
                Object object = mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
                if (this.isPersistenceContext()) {
                    if (disableConversion2 != null && disableConversion2.booleanValue()) {
                        mmd.setTypeConverterDisabled();
                    } else if (converterCls2 != null) {
                        TypeManager typeMgr2 = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr2.getTypeConverterForName(converterCls2.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter((PersistenceNucleusContext)this.mmgr.getNucleusContext(), converterCls2);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls2, member.getType());
                            Class dbType2 = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls2, attrType, null);
                            JDOTypeConverter typeConv2 = new JDOTypeConverter(conv);
                            typeMgr2.registerConverter(converterCls2.getName(), typeConv2, attrType, dbType2, false, null);
                        }
                        mmd.setTypeConverterName(converterCls2.getName());
                    }
                }
                if (modifier != null) {
                    mmd.setPersistenceModifier(modifier);
                }
                if (dfg != null) {
                    mmd.setDefaultFetchGroup(dfg.booleanValue());
                }
                if (pk != null) {
                    mmd.setPrimaryKey(pk.booleanValue());
                }
                if (embedded != null) {
                    mmd.setEmbedded(embedded.booleanValue());
                }
                if (serialized != null) {
                    mmd.setSerialised(serialized.booleanValue());
                }
                if (dependent != null) {
                    mmd.setDependent(dependent.booleanValue());
                }
                mmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue((String)string2));
                mmd.setMappedBy(mappedBy);
                mmd.setColumn(column);
                mmd.setTable(table);
                mmd.setRecursionDepth(recursionDepth);
                mmd.setLoadFetchGroup(loadFetchGroup);
                mmd.setValueStrategy(valueStrategy);
                mmd.setSequence(sequence);
                mmd.setFieldTypes(fieldTypeName);
                Column[] columns2 = (Column[])annotationValues.get("columns");
                if (columns2 != null && columns2.length > 0) {
                    for (Column col : columns2) {
                        mmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(col));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)mmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                primaryKey = true;
                if (cmd.getIdentityType() != IdentityType.DATASTORE) continue;
                cmd.setIdentityType(IdentityType.APPLICATION);
                continue;
            }
            if (string.equals(JDOAnnotationUtils.SERIALIZED)) {
                serialised = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.NOTPERSISTENT)) {
                nonPersistentField = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.TRANSACTIONAL)) {
                transactionalField = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.COLUMNS)) {
                Column[] cols = (Column[])annotationValues.get("value");
                if (cols == null || cols.length <= 0) continue;
                colmds = new ColumnMetaData[cols.length];
                for (int j = 0; j < cols.length; ++j) {
                    colmds[j] = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(cols[j]);
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)colmds[j], cols[j].extensions());
                }
                continue;
            }
            if (string.equals(JDOAnnotationUtils.COLUMN)) {
                colmds = new ColumnMetaData[]{JDOAnnotationUtils.getColumnMetaDataForAnnotations(annotationValues)};
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)colmds[0], (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.JOIN)) {
                String joinColumn = (String)annotationValues.get("column");
                String joinOuter = (String)annotationValues.get("outer");
                String deleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String pkName = (String)annotationValues.get("primaryKey");
                String string3 = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String indexed2 = (String)annotationValues.get("indexed");
                String indexName2 = (String)annotationValues.get("index");
                String unique2 = (String)annotationValues.get("unique");
                String uniqueName2 = (String)annotationValues.get("uniqueKey");
                String generatePK = (String)annotationValues.get("generatePrimaryKey");
                if (!StringUtils.isWhitespace((String)uniqueName2)) {
                    unique2 = "true";
                }
                if (!StringUtils.isWhitespace((String)indexName2)) {
                    indexed2 = "true";
                }
                Column[] joinColumns = (Column[])annotationValues.get("columns");
                joinmd = new JoinMetaData();
                joinmd.setColumnName(joinColumn);
                joinmd.setOuter(MetaDataUtils.getBooleanForString((String)joinOuter, (boolean)false));
                joinmd.setIndexed(IndexedValue.getIndexedValue((String)indexed2));
                joinmd.setUnique(unique2);
                joinmd.setDeleteAction(deleteAction);
                if (!StringUtils.isWhitespace((String)pkName)) {
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                    pkmd.setName(pkName);
                    joinmd.setPrimaryKeyMetaData(pkmd);
                } else if (generatePK != null && generatePK.equalsIgnoreCase("true")) {
                    joinmd.setPrimaryKeyMetaData(new PrimaryKeyMetaData());
                }
                if (!StringUtils.isWhitespace((String)string3)) {
                    ForeignKeyMetaData joinFkmd = joinmd.getForeignKeyMetaData();
                    if (joinFkmd == null) {
                        joinFkmd = new ForeignKeyMetaData();
                        joinFkmd.setName(string3);
                        joinmd.setForeignKeyMetaData(joinFkmd);
                    } else {
                        joinFkmd.setName(string3);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    joinmd.setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace((String)indexName2)) {
                    IndexMetaData joinIdxmd = joinmd.getIndexMetaData();
                    if (joinIdxmd == null) {
                        joinIdxmd = new IndexMetaData();
                        joinmd.setIndexMetaData(joinIdxmd);
                    }
                    joinIdxmd.setName(indexName2);
                }
                if (!StringUtils.isWhitespace((String)uniqueName2)) {
                    UniqueMetaData joinUnimd = joinmd.getUniqueMetaData();
                    if (joinUnimd == null) {
                        joinUnimd = new UniqueMetaData();
                        joinmd.setUniqueMetaData(joinUnimd);
                    }
                    joinUnimd.setName(uniqueName2);
                }
                if (joinColumns != null && joinColumns.length > 0) {
                    for (Column joinCol : joinColumns) {
                        joinmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(joinCol));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)joinmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.ELEMENT)) {
                Column[] elementColumns;
                void var51_127;
                elementTypes = (Class[])annotationValues.get("types");
                embeddedElement = (String)annotationValues.get("embedded");
                serializedElement = (String)annotationValues.get("serialized");
                dependentElement = (String)annotationValues.get("dependent");
                String elementDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String elementUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string4 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    String string5 = "true";
                }
                elemmd = new ElementMetaData();
                elemmd.setTable((String)annotationValues.get("table"));
                elemmd.setColumnName((String)annotationValues.get("column"));
                elemmd.setDeleteAction(elementDeleteAction);
                elemmd.setUpdateAction(elementUpdateAction);
                elemmd.setIndexed(IndexedValue.getIndexedValue((String)var51_127));
                elemmd.setUnique(MetaDataUtils.getBooleanForString((String)unique, (boolean)false));
                elemmd.setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace((String)fkName)) {
                    ForeignKeyMetaData elemFkmd = elemmd.getForeignKeyMetaData();
                    if (elemFkmd == null) {
                        elemFkmd = new ForeignKeyMetaData();
                        elemFkmd.setName(fkName);
                        elemmd.setForeignKeyMetaData(elemFkmd);
                    } else {
                        elemFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    elemmd.setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    IndexMetaData elemIdxmd = elemmd.getIndexMetaData();
                    if (elemIdxmd == null) {
                        elemIdxmd = new IndexMetaData();
                        elemmd.setIndexMetaData(elemIdxmd);
                    }
                    elemIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    UniqueMetaData elemUnimd = elemmd.getUniqueMetaData();
                    if (elemUnimd == null) {
                        elemUnimd = new UniqueMetaData();
                        elemmd.setUniqueMetaData(elemUnimd);
                    }
                    elemUnimd.setName(uniqueName);
                }
                if ((elementColumns = (Column[])annotationValues.get("columns")) != null && elementColumns.length > 0) {
                    for (Column elementCol : elementColumns) {
                        elemmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(elementCol));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        elemmd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter((PersistenceNucleusContext)this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getCollectionElementType((Class)member.getType(), (Type)member.getGenericType()));
                            dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, dbType, false, null);
                        }
                        elemmd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)elemmd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                try {
                    Discriminator disc = embeddedMappings[0].discriminatorColumnName();
                    if (disc != null) {
                        DiscriminatorMetaData dismd = embmd.newDiscriminatorMetadata();
                        dismd.setColumnName(disc.column());
                        dismd.setStrategy(JDOAnnotationUtils.getDiscriminatorStrategyString(disc.strategy()));
                    }
                }
                catch (Throwable disc) {
                    // empty catch block
                }
                elemmd.setEmbeddedMetaData(embmd);
                embeddedElementMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.KEY)) {
                Column[] keyColumns;
                void var51_130;
                keyTypes = (Class[])annotationValues.get("types");
                embeddedKey = (String)annotationValues.get("embedded");
                serializedKey = (String)annotationValues.get("serialized");
                dependentKey = (String)annotationValues.get("dependent");
                String keyDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String keyUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string6 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    String string7 = "true";
                }
                keymd = new KeyMetaData();
                keymd.setTable((String)annotationValues.get("table"));
                keymd.setColumnName((String)annotationValues.get("column"));
                keymd.setDeleteAction(keyDeleteAction);
                keymd.setUpdateAction(keyUpdateAction);
                keymd.setIndexed(IndexedValue.getIndexedValue((String)var51_130));
                keymd.setUnique(MetaDataUtils.getBooleanForString((String)unique, (boolean)false));
                keymd.setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace((String)fkName)) {
                    ForeignKeyMetaData keyFkmd = keymd.getForeignKeyMetaData();
                    if (keyFkmd == null) {
                        keyFkmd = new ForeignKeyMetaData();
                        keyFkmd.setName(fkName);
                        keymd.setForeignKeyMetaData(keyFkmd);
                    } else {
                        keyFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    keymd.setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    IndexMetaData keyIdxmd = keymd.getIndexMetaData();
                    if (keyIdxmd == null) {
                        keyIdxmd = new IndexMetaData();
                        keymd.setIndexMetaData(keyIdxmd);
                    }
                    keyIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    UniqueMetaData keyUnimd = keymd.getUniqueMetaData();
                    if (keyUnimd == null) {
                        keyUnimd = new UniqueMetaData();
                        keymd.setUniqueMetaData(keyUnimd);
                    }
                    keyUnimd.setName(uniqueName);
                }
                if ((keyColumns = (Column[])annotationValues.get("columns")) != null && keyColumns.length > 0) {
                    for (Column keyCol : keyColumns) {
                        keymd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(keyCol));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        keymd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter((PersistenceNucleusContext)this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getMapKeyType((Class)member.getType(), (Type)member.getGenericType()));
                            dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, dbType, false, null);
                        }
                        keymd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)keymd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                keymd.setEmbeddedMetaData(embmd);
                embeddedKeyMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.VALUE)) {
                Column[] valueColumns;
                void var51_133;
                valueTypes = (Class[])annotationValues.get("types");
                embeddedValue = (String)annotationValues.get("embedded");
                serializedValue = (String)annotationValues.get("serialized");
                dependentValue = (String)annotationValues.get("dependent");
                String valueDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String valueUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string8 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    String string9 = "true";
                }
                valuemd = new ValueMetaData();
                valuemd.setTable((String)annotationValues.get("table"));
                valuemd.setColumnName((String)annotationValues.get("column"));
                valuemd.setDeleteAction(valueDeleteAction);
                valuemd.setUpdateAction(valueUpdateAction);
                valuemd.setIndexed(IndexedValue.getIndexedValue((String)var51_133));
                valuemd.setUnique(MetaDataUtils.getBooleanForString((String)unique, (boolean)false));
                valuemd.setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace((String)fkName)) {
                    ForeignKeyMetaData valueFkmd = valuemd.getForeignKeyMetaData();
                    if (valueFkmd == null) {
                        valueFkmd = new ForeignKeyMetaData();
                        valueFkmd.setName(fkName);
                        valuemd.setForeignKeyMetaData(valueFkmd);
                    } else {
                        valueFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    valuemd.setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace((String)indexName)) {
                    IndexMetaData valueIdxmd = valuemd.getIndexMetaData();
                    if (valueIdxmd == null) {
                        valueIdxmd = new IndexMetaData();
                        valuemd.setIndexMetaData(valueIdxmd);
                    }
                    valueIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace((String)uniqueName)) {
                    UniqueMetaData valueUnimd = valuemd.getUniqueMetaData();
                    if (valueUnimd == null) {
                        valueUnimd = new UniqueMetaData();
                        valuemd.setUniqueMetaData(valueUnimd);
                    }
                    valueUnimd.setName(uniqueName);
                }
                if ((valueColumns = (Column[])annotationValues.get("columns")) != null && valueColumns.length > 0) {
                    for (Column valueCol : valueColumns) {
                        valuemd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(valueCol));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        valuemd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter((PersistenceNucleusContext)this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getMapValueType((Class)member.getType(), (Type)member.getGenericType()));
                            dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, dbType, false, null);
                        }
                        valuemd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)valuemd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                valuemd.setEmbeddedMetaData(embmd);
                embeddedValueMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.ORDER)) {
                ordermd = new OrderMetaData();
                ordermd.setColumnName((String)annotationValues.get("column"));
                ordermd.setMappedBy((String)annotationValues.get("mappedBy"));
                Column[] orderColumns = (Column[])annotationValues.get("columns");
                if (orderColumns != null && orderColumns.length > 0) {
                    for (Column column : orderColumns) {
                        ordermd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)ordermd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EMBEDDED)) {
                embeddedMember = true;
                embeddedOwnerField = (String)annotationValues.get("ownerMember");
                if (StringUtils.isWhitespace((String)embeddedOwnerField)) {
                    embeddedOwnerField = null;
                }
                if (StringUtils.isWhitespace((String)(embeddedNullIndicatorColumn = (String)annotationValues.get("nullIndicatorColumn")))) {
                    embeddedNullIndicatorColumn = null;
                }
                if (StringUtils.isWhitespace((String)(embeddedNullIndicatorValue = (String)annotationValues.get("nullIndicatorValue")))) {
                    embeddedNullIndicatorValue = null;
                }
                if ((embeddedMembers = (Persistent[])annotationValues.get("members")) == null || embeddedMembers.length != 0) continue;
                embeddedMembers = null;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.INDEX)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String unique3 = (String)annotationValues.get("unique");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                idxmd = JDOAnnotationUtils.getIndexMetaData(name, table, unique3, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)idxmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.UNIQUE)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String deferred = (String)annotationValues.get("deferred");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                unimd = JDOAnnotationUtils.getUniqueMetaData(name, table, deferred, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)unimd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String unique4 = (String)annotationValues.get("unique");
                String deferred = (String)annotationValues.get("deferred");
                String string10 = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                String updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                String[] members = (String[])annotationValues.get("members");
                Column[] columns3 = (Column[])annotationValues.get("columns");
                fkmd = JDOAnnotationUtils.getFKMetaData(name, table, unique4, deferred, string10, updateAction, members, columns3);
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)fkmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.CACHEABLE)) {
                String cache = (String)annotationValues.get("value");
                if (cache == null) continue;
                cacheable = cache;
                continue;
            }
            if (string.equals("javax.jdo.annotations.Convert")) {
                Boolean enabled;
                convertConverterCls = (Class)annotationValues.get("value");
                if (convertConverterCls == AttributeConverter.UseDefault.class) {
                    convertConverterCls = null;
                }
                if ((enabled = (Boolean)annotationValues.get("enabled")).booleanValue()) continue;
                convertConverterCls = null;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EXTENSIONS)) {
                Extension[] values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                extensions = new HashMap<String, String>(values.length);
                for (Extension extension : values) {
                    String vendorName = extension.vendorName();
                    if (StringUtils.isWhitespace((String)vendorName)) {
                        throw new InvalidMetaDataException("044160", new Object[]{vendorName, extension.key().toString(), extension.value().toString()});
                    }
                    if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                    extensions.put(extension.key().toString(), extension.value().toString());
                }
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EXTENSION)) {
                String vendorName = (String)annotationValues.get("vendorName");
                if (StringUtils.isWhitespace((String)vendorName)) {
                    throw new InvalidMetaDataException("044160", new Object[]{vendorName, annotationValues.get("key"), annotationValues.get("value")});
                }
                if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                extensions = new HashMap(1);
                extensions.put((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044211", (Object[])new Object[]{cmd.getFullClassName(), member.getName(), annotation.getName()}));
        }
        if (mmd == null && (transactionalField || nonPersistentField || primaryKey || colmds != null || serialised || embeddedOwnerField != null || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null || elemmd != null || keymd != null || valuemd != null || ordermd != null || idxmd != null || unimd != null || fkmd != null || joinmd != null || extensions != null || convertConverterCls != null)) {
            Object object = mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
            if (primaryKey) {
                mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                mmd.setPrimaryKey(primaryKey);
            }
            if (serialised) {
                mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
            }
        }
        if (mmd != null) {
            AbstractMemberMetaData embfmd;
            String memberName;
            cmd.addMember(mmd);
            if (primaryKey) {
                mmd.setPrimaryKey(true);
            }
            if (serialised) {
                mmd.setSerialised(true);
            }
            if (embeddedMember) {
                mmd.setEmbedded(true);
            }
            if (nonPersistentField) {
                mmd.setNotPersistent();
            }
            if (transactionalField) {
                mmd.setTransactional();
            }
            if (this.isPersistenceContext() && convertConverterCls != null) {
                TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                if (typeMgr.getTypeConverterForName(convertConverterCls.getName()) == null) {
                    AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter((PersistenceNucleusContext)this.mmgr.getNucleusContext(), convertConverterCls);
                    Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(convertConverterCls, member.getType());
                    Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(convertConverterCls, attrType, null);
                    JDOTypeConverter jDOTypeConverter = new JDOTypeConverter(conv);
                    typeMgr.registerConverter(convertConverterCls.getName(), jDOTypeConverter, attrType, dbType, false, null);
                }
                mmd.setTypeConverterName(convertConverterCls.getName());
            }
            if (embeddedMember && (embeddedOwnerField != null || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null)) {
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedOwnerField);
                embmd.setNullIndicatorColumn(embeddedNullIndicatorColumn);
                embmd.setNullIndicatorValue(embeddedNullIndicatorValue);
                mmd.setEmbeddedMetaData(embmd);
                if (embeddedMembers != null && embeddedMembers.length > 0) {
                    for (void var45_59 : embeddedMembers) {
                        Object memberName2 = var45_59.name();
                        if (((String)memberName2).indexOf(46) > 0) {
                            memberName2 = ((String)memberName2).substring(((String)memberName2).lastIndexOf(46) + 1);
                        }
                        AbstractMemberMetaData embfmd2 = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)var45_59, this.isMemberOfClassAField(member.getType(), (String)memberName2));
                        embmd.addMember(embfmd2);
                    }
                }
            }
            TypeManager typeManager = this.mmgr.getNucleusContext().getTypeManager();
            ContainerHandler containerHandler = typeManager.getContainerHandler(member.getType());
            ContainerMetaData contmd = null;
            if (containerHandler != null) {
                contmd = containerHandler.newMetaData();
            }
            if (contmd instanceof CollectionMetaData) {
                Class collectionElementType = null;
                StringBuilder stringBuilder = new StringBuilder();
                if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                    for (Class elementType : elementTypes) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(elementType.getName());
                    }
                    collectionElementType = elementTypes[0];
                } else {
                    collectionElementType = ClassUtils.getCollectionElementType((Class)member.getType(), (Type)member.getGenericType());
                }
                contmd = new CollectionMetaData();
                contmd.setParent((MetaData)mmd);
                CollectionMetaData collmd = (CollectionMetaData)contmd;
                collmd.setElementType(stringBuilder.toString());
                if (!StringUtils.isWhitespace((String)embeddedElement)) {
                    collmd.setEmbeddedElement(Boolean.valueOf(embeddedElement).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)serializedElement)) {
                    collmd.setSerializedElement(Boolean.valueOf(serializedElement).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)dependentElement)) {
                    collmd.setDependentElement(Boolean.valueOf(dependentElement).booleanValue());
                }
                if ((embeddedElementMembers != null || "true".equalsIgnoreCase(embeddedElement)) && elemmd == null) {
                    elemmd = new ElementMetaData();
                    mmd.setElementMetaData(elemmd);
                }
                if (elemmd != null && embeddedElementMembers != null) {
                    EmbeddedMetaData embmd = elemmd.getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedElement) && elemmd.getEmbeddedMetaData() == null) {
                        embmd = elemmd.newEmbeddedMetaData();
                    }
                    for (void var51_140 : embeddedElementMembers) {
                        memberName = var51_140.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)var51_140, this.isMemberOfClassAField(collectionElementType, memberName));
                        embmd.addMember(embfmd);
                    }
                }
            } else if (contmd instanceof ArrayMetaData) {
                StringBuilder elementTypeStr = new StringBuilder();
                if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                    for (Class elementType : elementTypes) {
                        if (elementTypeStr.length() > 0) {
                            elementTypeStr.append(',');
                        }
                        elementTypeStr.append(elementType.getName());
                    }
                } else {
                    elementTypeStr.append(member.getType().getComponentType().getName());
                }
                contmd = new ArrayMetaData();
                contmd.setParent((MetaData)mmd);
                ArrayMetaData arrayMetaData = (ArrayMetaData)contmd;
                arrayMetaData.setElementType(elementTypeStr.toString());
                if (!StringUtils.isWhitespace((String)embeddedElement)) {
                    arrayMetaData.setEmbeddedElement(Boolean.valueOf(embeddedElement).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)serializedElement)) {
                    arrayMetaData.setSerializedElement(Boolean.valueOf(serializedElement).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)dependentElement)) {
                    arrayMetaData.setDependentElement(Boolean.valueOf(dependentElement).booleanValue());
                }
            } else if (contmd instanceof MapMetaData) {
                EmbeddedMetaData embmd;
                void var45_67;
                Class mapKeyType = null;
                mapKeyType = keyTypes != null && keyTypes.length > 0 && keyTypes[0] != Void.TYPE ? keyTypes[0] : ClassUtils.getMapKeyType((Class)member.getType(), (Type)member.getGenericType());
                Object var45_64 = null;
                if (valueTypes != null && valueTypes.length > 0 && valueTypes[0] != Void.TYPE) {
                    Class clazz = valueTypes[0];
                } else {
                    Class clazz = ClassUtils.getMapValueType((Class)member.getType(), (Type)member.getGenericType());
                }
                contmd = new MapMetaData();
                contmd.setParent((MetaData)mmd);
                MapMetaData mapmd = (MapMetaData)contmd;
                mapmd.setKeyType(mapKeyType != null ? mapKeyType.getName() : null);
                if (!StringUtils.isWhitespace((String)embeddedKey)) {
                    mapmd.setEmbeddedKey(Boolean.valueOf(embeddedKey).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)serializedKey)) {
                    mapmd.setSerializedKey(Boolean.valueOf(serializedKey).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)dependentKey)) {
                    mapmd.setDependentKey(Boolean.valueOf(dependentKey).booleanValue());
                }
                mapmd.setValueType(var45_67 != null ? var45_67.getName() : null);
                if (!StringUtils.isWhitespace((String)embeddedValue)) {
                    mapmd.setEmbeddedValue(Boolean.valueOf(embeddedValue).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)serializedValue)) {
                    mapmd.setSerializedValue(Boolean.valueOf(serializedValue).booleanValue());
                }
                if (!StringUtils.isWhitespace((String)dependentValue)) {
                    mapmd.setDependentValue(Boolean.valueOf(dependentValue).booleanValue());
                }
                if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && keymd == null) {
                    keymd = new KeyMetaData();
                    mmd.setKeyMetaData(keymd);
                }
                if (keymd != null && embeddedKeyMembers != null) {
                    embmd = keymd.getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedKey) && keymd.getEmbeddedMetaData() == null) {
                        embmd = keymd.newEmbeddedMetaData();
                    }
                    for (void var51_142 : embeddedKeyMembers) {
                        memberName = var51_142.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)var51_142, this.isMemberOfClassAField(mapKeyType, memberName));
                        embmd.addMember(embfmd);
                    }
                }
                if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && valuemd == null) {
                    valuemd = new ValueMetaData();
                    mmd.setValueMetaData(valuemd);
                }
                if (valuemd != null && embeddedValueMembers != null) {
                    embmd = valuemd.getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedValue) && valuemd.getEmbeddedMetaData() == null) {
                        embmd = valuemd.newEmbeddedMetaData();
                    }
                    for (void var51_144 : embeddedValueMembers) {
                        memberName = var51_144.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)var51_144, this.isMemberOfClassAField((Class)var45_67, memberName));
                        embmd.addMember(embfmd);
                    }
                }
            }
            if (contmd != null) {
                mmd.setContainer(contmd);
                if (elemmd != null) {
                    elemmd.setParent((MetaData)mmd);
                    mmd.setElementMetaData(elemmd);
                    if (elemmd.getMappedBy() != null && mmd.getMappedBy() == null) {
                        mmd.setMappedBy(elemmd.getMappedBy());
                    }
                }
                if (keymd != null) {
                    keymd.setParent((MetaData)mmd);
                    mmd.setKeyMetaData(keymd);
                }
                if (valuemd != null) {
                    valuemd.setParent((MetaData)mmd);
                    mmd.setValueMetaData(valuemd);
                }
                if (ordermd != null) {
                    ordermd.setParent((MetaData)mmd);
                    mmd.setOrderMetaData(ordermd);
                }
            }
            if (joinmd != null) {
                mmd.setJoinMetaData(joinmd);
            }
            if (colmds != null) {
                for (ColumnMetaData colmd : colmds) {
                    mmd.addColumn(colmd);
                }
            }
            if (idxmd != null) {
                mmd.setIndexMetaData(idxmd);
            }
            if (unimd != null) {
                mmd.setUniqueMetaData(unimd);
            }
            if (fkmd != null) {
                mmd.setForeignKeyMetaData(fkmd);
            }
            if (cacheable != null && cacheable.equalsIgnoreCase("false")) {
                mmd.setCacheable(false);
            }
            if (extensions != null) {
                mmd.addExtensions(extensions);
            }
        }
        return mmd;
    }

    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
    }

    private AbstractMemberMetaData getFieldMetaDataForPersistent(MetaData parent, Persistent member, boolean isField) {
        FieldMetaData fmd;
        FieldPersistenceModifier modifier = JDOAnnotationUtils.getFieldPersistenceModifier(member.persistenceModifier());
        String nullValue = JDOAnnotationUtils.getNullValueString(member.nullValue());
        String valueStrategy = JDOAnnotationUtils.getValueGenerationStrategyString(member.valueStrategy());
        String fieldTypeName = null;
        Class[] fieldTypes = member.types();
        if (fieldTypes != null && fieldTypes.length > 0) {
            StringBuilder typeStr = new StringBuilder();
            for (Class fieldType : fieldTypes) {
                if (typeStr.length() > 0) {
                    typeStr.append(',');
                }
                if (fieldType == null || fieldType == Void.TYPE) continue;
                typeStr.append(fieldType.getName());
            }
            fieldTypeName = typeStr.toString();
        }
        Object object = fmd = isField ? new FieldMetaData(parent, member.name()) : new PropertyMetaData(parent, member.name());
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        if (!StringUtils.isWhitespace((String)member.defaultFetchGroup())) {
            fmd.setDefaultFetchGroup(Boolean.valueOf(member.defaultFetchGroup()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.primaryKey())) {
            fmd.setPrimaryKey(Boolean.valueOf(member.primaryKey()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.embedded())) {
            fmd.setEmbedded(Boolean.valueOf(member.embedded()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.serialized())) {
            fmd.setSerialised(Boolean.valueOf(member.serialized()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.dependent())) {
            fmd.setDependent(Boolean.valueOf(member.dependent()).booleanValue());
        }
        fmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue((String)nullValue));
        fmd.setMappedBy(member.mappedBy());
        fmd.setColumn(member.column());
        fmd.setTable(member.table());
        fmd.setLoadFetchGroup(member.loadFetchGroup());
        fmd.setValueStrategy(valueStrategy);
        fmd.setSequence(member.sequence());
        fmd.setFieldTypes(fieldTypeName);
        Column[] columns = member.columns();
        if (columns != null && columns.length > 0) {
            for (Column column : columns) {
                fmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
            }
        }
        return fmd;
    }

    private boolean isMemberOfClassAField(Class cls, String memberName) {
        try {
            cls.getDeclaredField(memberName);
        }
        catch (NoSuchFieldException nsfe) {
            return false;
        }
        return true;
    }

    protected AnnotationObject isClassPersistable(AnnotationObject[] annotations) {
        AnnotationObject result = null;
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE)) continue;
            result = result == null ? annotation : this.mergeAnnotation(this.persistenceCapableDefaults, result, annotation);
        }
        return result;
    }

    AnnotationObject mergeAnnotation(AnnotationObject defaults, AnnotationObject base, AnnotationObject dup) {
        Map baseEntry = base.getNameValueMap();
        Map dupEntry = dup.getNameValueMap();
        for (Map.Entry entry : defaults.getNameValueMap().entrySet()) {
            Object dupValue;
            String key = (String)entry.getKey();
            Object defaultValue = entry.getValue();
            if (this.valueEqual(defaultValue, dupValue = dupEntry.get(key))) continue;
            NucleusLogger.METADATA.warn((Object)("Merging duplicated PersistenceCapable annotation : using key=" + key + " with value=" + dupValue + " instead of " + baseEntry.get(key)));
            baseEntry.put(key, dupValue);
        }
        return base;
    }

    boolean valueEqual(Object defaultValue, Object dupValue) {
        if (defaultValue == null) {
            return dupValue == null;
        }
        if (defaultValue == Void.TYPE) {
            return dupValue == Void.TYPE;
        }
        if ("".equals(defaultValue)) {
            return "".equals(dupValue);
        }
        return defaultValue.equals(dupValue);
    }

    protected boolean isClassPersistenceAware(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveNamedQueries(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.QUERIES) && !annName.equals(JDOAnnotationUtils.QUERY)) continue;
            return true;
        }
        return false;
    }

    @PersistenceCapable
    protected class PersistenceCapableModel {
        protected PersistenceCapableModel() {
        }
    }
}

