/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JDOMetaDataHandler
extends AbstractMetaDataHandler {
    public JDOMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData();
        ((FileMetaData)this.metadata).setFilename(filename);
        ((FileMetaData)this.metadata).setMetaDataManager(mgr);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        String serializeReadAttr;
        String name = this.getAttr(attrs, "name");
        if (StringUtils.isWhitespace((String)name)) {
            throw new InvalidClassMetaDataException("044061", new Object[]{pmd.getName()});
        }
        ClassMetaData cmd = new ClassMetaData(pmd, name);
        cmd.setTable(this.getAttr(attrs, "table"));
        cmd.setCatalog(this.getAttr(attrs, "catalog"));
        cmd.setSchema(this.getAttr(attrs, "schema"));
        cmd.setRequiresExtent(this.getAttr(attrs, "requires-extent"));
        String detachableStr = this.getAttr(attrs, "detachable");
        if (this.mgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.alwaysDetachable")) {
            cmd.setDetachable(true);
        } else {
            cmd.setDetachable(detachableStr);
        }
        String objIdCls = this.getAttr(attrs, "objectid-class");
        if (!StringUtils.isWhitespace((String)objIdCls)) {
            cmd.setObjectIdClass(NucleusJDOHelper.getObjectIdClassForInputIdClass(objIdCls));
        }
        cmd.setEmbeddedOnly(this.getAttr(attrs, "embedded-only"));
        cmd.setPersistenceModifier(ClassPersistenceModifier.getClassPersistenceModifier((String)this.getAttr(attrs, "persistence-modifier")));
        cmd.setIdentityType(IdentityType.getIdentityType((String)this.getAttr(attrs, "identity-type")));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            cmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        if ((serializeReadAttr = this.getAttr(attrs, "serialize-read")) != null) {
            cmd.setSerializeRead(serializeReadAttr.equalsIgnoreCase("true"));
        }
        return cmd;
    }

    protected InterfaceMetaData newInterfaceObject(PackageMetaData pmd, Attributes attrs) {
        String disableConverterAttr;
        String converterAttr;
        String name = this.getAttr(attrs, "name");
        if (StringUtils.isWhitespace((String)name)) {
            throw new InvalidClassMetaDataException("044061", new Object[]{pmd.getName()});
        }
        InterfaceMetaData imd = new InterfaceMetaData(pmd, name);
        imd.setTable(this.getAttr(attrs, "table"));
        imd.setCatalog(this.getAttr(attrs, "catalog"));
        imd.setSchema(this.getAttr(attrs, "schema"));
        String detachableStr = this.getAttr(attrs, "detachable");
        if (this.mgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.alwaysDetachable")) {
            imd.setDetachable(true);
        } else {
            imd.setDetachable(detachableStr);
        }
        imd.setRequiresExtent(this.getAttr(attrs, "requires-extent"));
        String objIdCls = this.getAttr(attrs, "objectid-class");
        if (!StringUtils.isWhitespace((String)objIdCls)) {
            imd.setObjectIdClass(NucleusJDOHelper.getObjectIdClassForInputIdClass(objIdCls));
        }
        imd.setEmbeddedOnly(this.getAttr(attrs, "embedded-only"));
        imd.setIdentityType(IdentityType.getIdentityType((String)this.getAttr(attrs, "identity-type")));
        imd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            imd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        if ((converterAttr = this.getAttr(attrs, "converter")) != null) {
            // empty if block
        }
        if ((disableConverterAttr = this.getAttr(attrs, "disable-converter")) != null) {
            // empty if block
        }
        return imd;
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        String disableConverterAttr;
        String converterAttr;
        String depStr;
        String serStr;
        String embStr;
        String dfgStr;
        FieldMetaData fmd = new FieldMetaData(md, this.getAttr(attrs, "name"));
        String modStr = this.getAttr(attrs, "persistence-modifier");
        FieldPersistenceModifier modifier = FieldPersistenceModifier.getFieldPersistenceModifier((String)modStr);
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        fmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
        String pkStr = this.getAttr(attrs, "primary-key");
        if (!StringUtils.isWhitespace((String)pkStr)) {
            fmd.setPrimaryKey(Boolean.valueOf(pkStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(dfgStr = this.getAttr(attrs, "default-fetch-group")))) {
            fmd.setDefaultFetchGroup(Boolean.valueOf(dfgStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(embStr = this.getAttr(attrs, "embedded")))) {
            fmd.setEmbedded(Boolean.valueOf(embStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(serStr = this.getAttr(attrs, "serialized")))) {
            fmd.setSerialised(Boolean.valueOf(serStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(depStr = this.getAttr(attrs, "dependent")))) {
            fmd.setDependent(Boolean.valueOf(depStr).booleanValue());
        }
        fmd.setNullValue(NullValue.getNullValue((String)this.getAttr(attrs, "null-value")));
        fmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
        fmd.setColumn(this.getAttr(attrs, "column"));
        fmd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
        fmd.setUnique(this.getAttr(attrs, "unique"));
        fmd.setTable(this.getAttr(attrs, "table"));
        fmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
        fmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
        fmd.setValueStrategy(this.getAttr(attrs, "value-strategy"));
        fmd.setSequence(this.getAttr(attrs, "sequence"));
        fmd.setFieldTypes(this.getAttr(attrs, "field-type"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            fmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        if ((converterAttr = this.getAttr(attrs, "converter")) != null) {
            // empty if block
        }
        if ((disableConverterAttr = this.getAttr(attrs, "disable-converter")) != null) {
            // empty if block
        }
        return fmd;
    }

    protected PropertyMetaData newPropertyObject(MetaData md, Attributes attrs) {
        String depStr;
        String serStr;
        String embStr;
        String dfgStr;
        PropertyMetaData pmd = new PropertyMetaData(md, this.getAttr(attrs, "name"));
        String modStr = this.getAttr(attrs, "persistence-modifier");
        FieldPersistenceModifier modifier = FieldPersistenceModifier.getFieldPersistenceModifier((String)modStr);
        if (modifier != null) {
            pmd.setPersistenceModifier(modifier);
        }
        pmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
        String pkStr = this.getAttr(attrs, "primary-key");
        if (!StringUtils.isWhitespace((String)pkStr)) {
            pmd.setPrimaryKey(Boolean.valueOf(pkStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(dfgStr = this.getAttr(attrs, "default-fetch-group")))) {
            pmd.setDefaultFetchGroup(Boolean.valueOf(dfgStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(embStr = this.getAttr(attrs, "embedded")))) {
            pmd.setEmbedded(Boolean.valueOf(embStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(serStr = this.getAttr(attrs, "serialized")))) {
            pmd.setSerialised(Boolean.valueOf(serStr).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)(depStr = this.getAttr(attrs, "dependent")))) {
            pmd.setDependent(Boolean.valueOf(depStr).booleanValue());
        }
        pmd.setNullValue(NullValue.getNullValue((String)this.getAttr(attrs, "null-value")));
        pmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
        pmd.setColumn(this.getAttr(attrs, "column"));
        pmd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
        pmd.setUnique(this.getAttr(attrs, "unique"));
        pmd.setTable(this.getAttr(attrs, "table"));
        pmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
        pmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
        pmd.setValueStrategy(this.getAttr(attrs, "value-strategy"));
        pmd.setSequence(this.getAttr(attrs, "sequence"));
        pmd.setFieldTypes(this.getAttr(attrs, "field-type"));
        pmd.setFieldName(this.getAttr(attrs, "field-name"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            pmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        return pmd;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block167: {
            if (this.charactersBuffer.length() > 0) {
                String currentString = this.getString().trim();
                if (this.getStack() instanceof QueryMetaData) {
                    ((QueryMetaData)this.getStack()).setQuery(currentString.trim());
                }
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                AbstractMemberMetaData fmd;
                MetaData parent;
                ClassMetaData cmd;
                MetaData md;
                PackageMetaData pmd;
                FileMetaData filemd;
                if (localName.equals("jdo")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetadataFileType.JDO_FILE);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block167;
                }
                if (localName.equals("orm")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetadataFileType.JDO_ORM_FILE);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block167;
                }
                if (localName.equals("jdoquery")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetadataFileType.JDO_QUERY_FILE);
                    break block167;
                }
                if (localName.equals("fetch-plan")) {
                    filemd = (FileMetaData)this.metadata;
                    FetchPlanMetaData fpmd = filemd.newFetchPlanMetadata(this.getAttr(attrs, "name"));
                    fpmd.setMaxFetchDepth(this.getAttr(attrs, "max-fetch-depth"));
                    fpmd.setFetchSize(this.getAttr(attrs, "fetch-size"));
                    this.pushStack((MetaData)fpmd);
                    break block167;
                }
                if (localName.equals("package")) {
                    filemd = (FileMetaData)this.getStack();
                    PackageMetaData pmd2 = filemd.newPackageMetadata(this.getAttr(attrs, "name"));
                    pmd2.setCatalog(this.getAttr(attrs, "catalog"));
                    pmd2.setSchema(this.getAttr(attrs, "schema"));
                    this.pushStack((MetaData)pmd2);
                    break block167;
                }
                if (localName.equals("class")) {
                    pmd = (PackageMetaData)this.getStack();
                    ClassMetaData cmd2 = this.newClassObject(pmd, attrs);
                    pmd.addClass(cmd2);
                    this.pushStack((MetaData)cmd2);
                    break block167;
                }
                if (localName.equals("interface")) {
                    pmd = (PackageMetaData)this.getStack();
                    InterfaceMetaData imd = this.newInterfaceObject(pmd, attrs);
                    pmd.addInterface(imd);
                    this.pushStack((MetaData)imd);
                    break block167;
                }
                if (localName.equals("primary-key")) {
                    md = this.getStack();
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                    pkmd.setName(this.getAttr(attrs, "name"));
                    pkmd.setColumnName(this.getAttr(attrs, "column"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).setPrimaryKeyMetaData(pkmd);
                    } else if (md instanceof JoinMetaData) {
                        ((JoinMetaData)md).setPrimaryKeyMetaData(pkmd);
                    }
                    this.pushStack((MetaData)pkmd);
                    break block167;
                }
                if (localName.equals("implements")) {
                    cmd = (ClassMetaData)this.getStack();
                    ImplementsMetaData imd = new ImplementsMetaData(this.getAttr(attrs, "name"));
                    cmd.addImplements(imd);
                    this.pushStack((MetaData)imd);
                    break block167;
                }
                if (localName.equals("property")) {
                    parent = this.getStack();
                    if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject((MetaData)acmd, attrs);
                        acmd.addMember((AbstractMemberMetaData)propmd);
                        this.pushStack((MetaData)propmd);
                    } else if (parent instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd = (EmbeddedMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject((MetaData)emd, attrs);
                        emd.addMember((AbstractMemberMetaData)propmd);
                        this.pushStack((MetaData)propmd);
                    } else if (parent instanceof ImplementsMetaData) {
                        ImplementsMetaData implmd = (ImplementsMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject((MetaData)implmd, attrs);
                        implmd.addProperty(propmd);
                        this.pushStack((MetaData)propmd);
                    } else if (parent instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)parent;
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)fgmd, this.getAttr(attrs, "name"));
                        fgmmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
                        fgmmd.setProperty();
                        fgmd.addMember(fgmmd);
                        this.pushStack((MetaData)fgmmd);
                    }
                    break block167;
                }
                if (localName.equals("datastore-identity")) {
                    AbstractClassMetaData acmd = (AbstractClassMetaData)this.getStack();
                    IdentityMetaData idmd = new IdentityMetaData();
                    idmd.setColumnName(this.getAttr(attrs, "column"));
                    idmd.setValueStrategy(IdentityStrategy.getIdentityStrategy((String)this.getAttr(attrs, "strategy")));
                    idmd.setSequence(this.getAttr(attrs, "sequence"));
                    acmd.setIdentityMetaData(idmd);
                    this.pushStack((MetaData)idmd);
                    break block167;
                }
                if (localName.equals("inheritance")) {
                    parent = this.getStack();
                    AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                    InheritanceMetaData inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(this.getAttr(attrs, "strategy"));
                    acmd.setInheritanceMetaData(inhmd);
                    this.pushStack((MetaData)inhmd);
                    break block167;
                }
                if (localName.equals("discriminator")) {
                    md = this.getStack();
                    if (md instanceof InheritanceMetaData) {
                        InheritanceMetaData inhmd = (InheritanceMetaData)md;
                        DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetadata();
                        dismd.setColumnName(this.getAttr(attrs, "column"));
                        dismd.setValue(this.getAttr(attrs, "value"));
                        dismd.setStrategy(this.getAttr(attrs, "strategy"));
                        dismd.setIndexed(this.getAttr(attrs, "indexed"));
                        this.pushStack((MetaData)dismd);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData embmd = (EmbeddedMetaData)md;
                        DiscriminatorMetaData dismd = embmd.newDiscriminatorMetadata();
                        dismd.setColumnName(this.getAttr(attrs, "column"));
                        dismd.setValue(this.getAttr(attrs, "value"));
                        dismd.setStrategy(this.getAttr(attrs, "strategy"));
                        dismd.setIndexed(this.getAttr(attrs, "indexed"));
                        this.pushStack((MetaData)dismd);
                    }
                    break block167;
                }
                if (localName.equals("query")) {
                    MetaData emd = this.getStack();
                    String name = this.getAttr(attrs, "name");
                    String lang = this.getAttr(attrs, "language");
                    if (!StringUtils.isWhitespace((String)lang)) {
                        if (lang.equals("javax.jdo.query.JDOQL")) {
                            lang = QueryLanguage.JDOQL.toString();
                        } else if (lang.equals("javax.jdo.query.SQL")) {
                            lang = QueryLanguage.SQL.toString();
                        } else if (lang.equals("javax.jdo.query.JPQL")) {
                            lang = QueryLanguage.JPQL.toString();
                        }
                    }
                    if (emd instanceof ClassMetaData) {
                        ClassMetaData cmd3 = (ClassMetaData)emd;
                        if (StringUtils.isWhitespace((String)name)) {
                            throw new InvalidClassMetaDataException("044154", new Object[]{cmd3.getFullClassName()});
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setScope(cmd3.getFullClassName());
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        cmd3.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    } else if (emd instanceof InterfaceMetaData) {
                        InterfaceMetaData imd = (InterfaceMetaData)emd;
                        if (StringUtils.isWhitespace((String)name)) {
                            throw new InvalidClassMetaDataException("044154", new Object[]{imd.getFullClassName()});
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setScope(imd.getFullClassName());
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        imd.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    } else if (emd instanceof FileMetaData) {
                        FileMetaData filemd2 = (FileMetaData)emd;
                        QueryMetaData qmd = filemd2.newQueryMetadata(name);
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        this.pushStack((MetaData)qmd);
                    }
                    break block167;
                }
                if (localName.equals("sequence")) {
                    String seqStart;
                    pmd = (PackageMetaData)this.getStack();
                    SequenceMetaData seqmd = pmd.newSequenceMetadata(this.getAttr(attrs, "name"), this.getAttr(attrs, "strategy"));
                    seqmd.setFactoryClass(this.getAttr(attrs, "factory-class"));
                    seqmd.setDatastoreSequence(this.getAttr(attrs, "datastore-sequence"));
                    String seqSize = this.getAttr(attrs, "allocation-size");
                    if (seqSize != null) {
                        seqmd.setAllocationSize(seqSize);
                    }
                    if ((seqStart = this.getAttr(attrs, "initial-value")) != null) {
                        seqmd.setInitialValue(seqStart);
                    }
                    this.pushStack((MetaData)seqmd);
                    break block167;
                }
                if (localName.equals("field")) {
                    md = this.getStack();
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)md;
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData(md, this.getAttr(attrs, "name"));
                        fgmmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
                        fgmd.addMember(fgmmd);
                        this.pushStack((MetaData)fgmmd);
                        return;
                    }
                    FieldMetaData fmd2 = this.newFieldObject(md, attrs);
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd4 = (ClassMetaData)md;
                        cmd4.addMember((AbstractMemberMetaData)fmd2);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd = (EmbeddedMetaData)md;
                        emd.addMember((AbstractMemberMetaData)fmd2);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addMember(fmd2.getName());
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData imd = (IndexMetaData)md;
                        imd.addMember(fmd2.getName());
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData umd = (UniqueMetaData)md;
                        umd.addMember(fmd2.getName());
                    }
                    this.pushStack((MetaData)fmd2);
                    break block167;
                }
                if (localName.equals("join")) {
                    parent = this.getStack();
                    String tableName = this.getAttr(attrs, "table");
                    String columnName = this.getAttr(attrs, "column");
                    String outer = this.getAttr(attrs, "outer");
                    IndexedValue indexed = IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed"));
                    String unique = this.getAttr(attrs, "unique");
                    String deleteAction = this.getAttr(attrs, "delete-action");
                    JoinMetaData joinmd = null;
                    if (parent instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd3 = (AbstractMemberMetaData)parent;
                        joinmd = fmd3.newJoinMetadata();
                    } else if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd5 = (AbstractClassMetaData)parent;
                        joinmd = new JoinMetaData();
                        cmd5.addJoin(joinmd);
                    } else if (parent instanceof InheritanceMetaData) {
                        InheritanceMetaData inhmd = (InheritanceMetaData)parent;
                        joinmd = inhmd.newJoinMetadata();
                    } else {
                        throw new NucleusUserException("Error processing JDO XML metadata. Found \"join\" with parent " + StringUtils.toJVMIDString((Object)parent) + " - not supported");
                    }
                    joinmd.setTable(tableName);
                    joinmd.setColumnName(columnName);
                    joinmd.setOuter(MetaDataUtils.getBooleanForString((String)outer, (boolean)false));
                    joinmd.setIndexed(indexed);
                    joinmd.setUnique(unique);
                    joinmd.setDeleteAction(deleteAction);
                    this.pushStack((MetaData)joinmd);
                    break block167;
                }
                if (localName.equals("map")) {
                    String depValStr;
                    String serValStr;
                    String depKeyStr;
                    String serKeyStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    MapMetaData mapmd = fmd.newMapMetaData();
                    mapmd.setKeyType(this.getAttr(attrs, "key-type"));
                    String embKeyStr = this.getAttr(attrs, "embedded-key");
                    if (!StringUtils.isWhitespace((String)embKeyStr)) {
                        mapmd.setEmbeddedKey(Boolean.valueOf(embKeyStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(serKeyStr = this.getAttr(attrs, "serialized-key")))) {
                        mapmd.setSerializedKey(Boolean.valueOf(serKeyStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(depKeyStr = this.getAttr(attrs, "dependent-key")))) {
                        mapmd.setDependentKey(Boolean.valueOf(depKeyStr).booleanValue());
                    }
                    mapmd.setValueType(this.getAttr(attrs, "value-type"));
                    String embValStr = this.getAttr(attrs, "embedded-value");
                    if (!StringUtils.isWhitespace((String)embValStr)) {
                        mapmd.setEmbeddedValue(Boolean.valueOf(embValStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(serValStr = this.getAttr(attrs, "serialized-value")))) {
                        mapmd.setSerializedValue(Boolean.valueOf(serValStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(depValStr = this.getAttr(attrs, "dependent-value")))) {
                        mapmd.setDependentValue(Boolean.valueOf(depValStr).booleanValue());
                    }
                    this.pushStack((MetaData)mapmd);
                    break block167;
                }
                if (localName.equals("array")) {
                    String depElemStr;
                    String serElemStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ArrayMetaData arrmd = fmd.newArrayMetaData();
                    arrmd.setElementType(this.getAttr(attrs, "element-type"));
                    String embElemStr = this.getAttr(attrs, "embedded-element");
                    if (!StringUtils.isWhitespace((String)embElemStr)) {
                        arrmd.setEmbeddedElement(Boolean.valueOf(embElemStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(serElemStr = this.getAttr(attrs, "serialized-element")))) {
                        arrmd.setSerializedElement(Boolean.valueOf(serElemStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(depElemStr = this.getAttr(attrs, "dependent-element")))) {
                        arrmd.setDependentElement(Boolean.valueOf(depElemStr).booleanValue());
                    }
                    this.pushStack((MetaData)arrmd);
                    break block167;
                }
                if (localName.equals("collection")) {
                    String depElemStr;
                    String serElemStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    CollectionMetaData collmd = fmd.newCollectionMetaData();
                    collmd.setElementType(this.getAttr(attrs, "element-type"));
                    String embElemStr = this.getAttr(attrs, "embedded-element");
                    if (!StringUtils.isWhitespace((String)embElemStr)) {
                        collmd.setEmbeddedElement(Boolean.valueOf(embElemStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(serElemStr = this.getAttr(attrs, "serialized-element")))) {
                        collmd.setSerializedElement(Boolean.valueOf(serElemStr).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)(depElemStr = this.getAttr(attrs, "dependent-element")))) {
                        collmd.setDependentElement(Boolean.valueOf(depElemStr).booleanValue());
                    }
                    this.pushStack((MetaData)collmd);
                    break block167;
                }
                if (localName.equals("column")) {
                    md = this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setTarget(this.getAttr(attrs, "target"));
                    colmd.setTargetMember(this.getAttr(attrs, "target-field"));
                    colmd.setJdbcType(this.getAttr(attrs, "jdbc-type"));
                    colmd.setSqlType(this.getAttr(attrs, "sql-type"));
                    colmd.setLength(this.getAttr(attrs, "length"));
                    colmd.setScale(this.getAttr(attrs, "scale"));
                    colmd.setAllowsNull(this.getAttr(attrs, "allows-null"));
                    colmd.setDefaultValue(this.getAttr(attrs, "default-value"));
                    colmd.setInsertValue(this.getAttr(attrs, "insert-value"));
                    String pos = this.getAttr(attrs, "position");
                    if (pos != null) {
                        colmd.setPosition(pos);
                    }
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd4 = (AbstractMemberMetaData)md;
                        fmd4.addColumn(colmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elemd = (AbstractElementMetaData)md;
                        elemd.addColumn(colmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jnmd = (JoinMetaData)md;
                        jnmd.addColumn(colmd);
                    } else if (md instanceof IdentityMetaData) {
                        IdentityMetaData idmd = (IdentityMetaData)md;
                        idmd.setColumnMetaData(colmd);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addColumn(colmd);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData idxmd = (IndexMetaData)md;
                        idxmd.addColumn(colmd.getName());
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData unimd = (UniqueMetaData)md;
                        unimd.addColumn(colmd.getName());
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData ormd = (OrderMetaData)md;
                        ormd.addColumn(colmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setColumnMetaData(colmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setColumnMetaData(colmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd6 = (AbstractClassMetaData)md;
                        cmd6.addUnmappedColumn(colmd);
                    } else if (md instanceof PrimaryKeyMetaData) {
                        PrimaryKeyMetaData pkmd = (PrimaryKeyMetaData)md;
                        pkmd.addColumn(colmd);
                    }
                    this.pushStack((MetaData)colmd);
                    break block167;
                }
                if (localName.equals("element")) {
                    String disableConverterAttr;
                    String converterAttr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ElementMetaData elemmd = new ElementMetaData();
                    elemmd.setTable(this.getAttr(attrs, "table"));
                    elemmd.setColumnName(this.getAttr(attrs, "column"));
                    elemmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    elemmd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    elemmd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
                    elemmd.setUnique(MetaDataUtils.getBooleanForString((String)this.getAttr(attrs, "unique"), (boolean)false));
                    String mappedBy = this.getAttr(attrs, "mapped-by");
                    elemmd.setMappedBy(mappedBy);
                    if (!StringUtils.isWhitespace((String)mappedBy) && fmd.getMappedBy() == null) {
                        fmd.setMappedBy(mappedBy);
                    }
                    if ((converterAttr = this.getAttr(attrs, "converter")) != null) {
                        // empty if block
                    }
                    if ((disableConverterAttr = this.getAttr(attrs, "disable-converter")) != null) {
                        // empty if block
                    }
                    fmd.setElementMetaData(elemmd);
                    this.pushStack((MetaData)elemmd);
                    break block167;
                }
                if (localName.equals("key")) {
                    String disableConverterAttr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    KeyMetaData keymd = new KeyMetaData();
                    keymd.setTable(this.getAttr(attrs, "table"));
                    keymd.setColumnName(this.getAttr(attrs, "column"));
                    keymd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    keymd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    keymd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
                    keymd.setUnique(MetaDataUtils.getBooleanForString((String)this.getAttr(attrs, "unique"), (boolean)false));
                    keymd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    String converterAttr = this.getAttr(attrs, "converter");
                    if (converterAttr != null) {
                        // empty if block
                    }
                    if ((disableConverterAttr = this.getAttr(attrs, "disable-converter")) != null) {
                        // empty if block
                    }
                    fmd.setKeyMetaData(keymd);
                    this.pushStack((MetaData)keymd);
                    break block167;
                }
                if (localName.equals("value")) {
                    String disableConverterAttr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ValueMetaData valuemd = new ValueMetaData();
                    valuemd.setTable(this.getAttr(attrs, "table"));
                    valuemd.setColumnName(this.getAttr(attrs, "column"));
                    valuemd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    valuemd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    valuemd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
                    valuemd.setUnique(MetaDataUtils.getBooleanForString((String)this.getAttr(attrs, "unique"), (boolean)false));
                    valuemd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    String converterAttr = this.getAttr(attrs, "converter");
                    if (converterAttr != null) {
                        // empty if block
                    }
                    if ((disableConverterAttr = this.getAttr(attrs, "disable-converter")) != null) {
                        // empty if block
                    }
                    fmd.setValueMetaData(valuemd);
                    this.pushStack((MetaData)valuemd);
                    break block167;
                }
                if (localName.equals("fetch-group")) {
                    md = this.getStack();
                    FetchGroupMetaData fgmd = new FetchGroupMetaData(this.getAttr(attrs, "name"));
                    String postLoadStr = this.getAttr(attrs, "post-load");
                    if (!StringUtils.isWhitespace((String)postLoadStr)) {
                        fgmd.setPostLoad(Boolean.valueOf(postLoadStr));
                    }
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmdParent = (FetchGroupMetaData)md;
                        fgmdParent.addFetchGroup(fgmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd7 = (AbstractClassMetaData)md;
                        cmd7.addFetchGroup(fgmd);
                    } else if (md instanceof FetchPlanMetaData) {
                        FetchPlanMetaData fpmd = (FetchPlanMetaData)md;
                        fpmd.addFetchGroup(fgmd);
                    }
                    this.pushStack((MetaData)fgmd);
                    break block167;
                }
                if (localName.equals("extension")) {
                    md = this.getStack();
                    md.addExtension(this.getAttr(attrs, "vendor-name"), this.getAttr(attrs, "key"), this.getAttr(attrs, "value"));
                    break block167;
                }
                if (localName.equals("version")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    VersionMetaData vermd = cmd.newVersionMetadata();
                    String strategy = this.getAttr(attrs, "strategy");
                    if (!StringUtils.isWhitespace((String)strategy)) {
                        vermd.setStrategy(strategy);
                    }
                    vermd.setColumnName(this.getAttr(attrs, "column"));
                    vermd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
                    this.pushStack((MetaData)vermd);
                    break block167;
                }
                if (localName.equals("index")) {
                    md = this.getStack();
                    IndexMetaData idxmd = new IndexMetaData();
                    idxmd.setName(this.getAttr(attrs, "name"));
                    idxmd.setTable(this.getAttr(attrs, "table"));
                    String uniStr = this.getAttr(attrs, "unique");
                    if (!StringUtils.isWhitespace((String)uniStr)) {
                        idxmd.setUnique(Boolean.valueOf(uniStr).booleanValue());
                    }
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd8 = (AbstractClassMetaData)md;
                        cmd8.addIndex(idxmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd5 = (AbstractMemberMetaData)md;
                        fmd5.setIndexMetaData(idxmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setIndexMetaData(idxmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setIndexMetaData(idxmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData omd = (OrderMetaData)md;
                        omd.setIndexMetaData(idxmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setIndexMetaData(idxmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setIndexMetaData(idxmd);
                    }
                    this.pushStack((MetaData)idxmd);
                    break block167;
                }
                if (localName.equals("unique")) {
                    md = this.getStack();
                    UniqueMetaData unimd = new UniqueMetaData();
                    unimd.setName(this.getAttr(attrs, "name"));
                    unimd.setTable(this.getAttr(attrs, "table"));
                    String defStr = this.getAttr(attrs, "deferred");
                    if (!StringUtils.isWhitespace((String)defStr)) {
                        unimd.setDeferred(Boolean.valueOf(defStr).booleanValue());
                    }
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd9 = (AbstractClassMetaData)md;
                        cmd9.addUniqueConstraint(unimd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd6 = (AbstractMemberMetaData)md;
                        fmd6.setUniqueMetaData(unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setUniqueMetaData(unimd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setUniqueMetaData(unimd);
                    }
                    this.pushStack((MetaData)unimd);
                    break block167;
                }
                if (localName.equals("foreign-key")) {
                    md = this.getStack();
                    ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
                    fkmd.setName(this.getAttr(attrs, "name"));
                    fkmd.setTable(this.getAttr(attrs, "table"));
                    fkmd.setUnique(this.getAttr(attrs, "unique"));
                    fkmd.setDeferred(this.getAttr(attrs, "deferred"));
                    fkmd.setDeleteAction(ForeignKeyAction.getForeignKeyAction((String)this.getAttr(attrs, "delete-action")));
                    fkmd.setUpdateAction(ForeignKeyAction.getForeignKeyAction((String)this.getAttr(attrs, "update-action")));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd10 = (AbstractClassMetaData)md;
                        cmd10.addForeignKey(fkmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd7 = (AbstractMemberMetaData)md;
                        fmd7.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setForeignKeyMetaData(fkmd);
                    }
                    this.pushStack((MetaData)fkmd);
                    break block167;
                }
                if (localName.equals("order")) {
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setIndexed(IndexedValue.getIndexedValue((String)this.getAttr(attrs, "indexed")));
                    ordmd.setColumnName(this.getAttr(attrs, "column"));
                    ordmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    AbstractMemberMetaData fmd8 = (AbstractMemberMetaData)this.getStack();
                    fmd8.setOrderMetaData(ordmd);
                    this.pushStack((MetaData)ordmd);
                    break block167;
                }
                if (localName.equals("embedded")) {
                    md = this.getStack();
                    EmbeddedMetaData embmd = new EmbeddedMetaData();
                    embmd.setOwnerMember(this.getAttr(attrs, "owner-field"));
                    embmd.setNullIndicatorColumn(this.getAttr(attrs, "null-indicator-column"));
                    embmd.setNullIndicatorValue(this.getAttr(attrs, "null-indicator-value"));
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd9 = (AbstractMemberMetaData)md;
                        fmd9.setEmbeddedMetaData(embmd);
                    } else if (md instanceof KeyMetaData) {
                        KeyMetaData kmd = (KeyMetaData)md;
                        kmd.setEmbeddedMetaData(embmd);
                    } else if (md instanceof ValueMetaData) {
                        ValueMetaData vmd = (ValueMetaData)md;
                        vmd.setEmbeddedMetaData(embmd);
                    } else if (md instanceof ElementMetaData) {
                        ElementMetaData elmd = (ElementMetaData)md;
                        elmd.setEmbeddedMetaData(embmd);
                    }
                    this.pushStack((MetaData)embmd);
                    break block167;
                }
                String message = Localiser.msg((String)"044037", (Object[])new Object[]{qName});
                NucleusLogger.METADATA.error((Object)message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error((Object)Localiser.msg((String)"044042", (Object[])new Object[]{qName, this.getStack(), uri}), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("query")) {
                ((QueryMetaData)md).setQuery(currentString);
            }
        }
        if (localName.equals("package") || localName.equals("fetch-plan") || localName.equals("class") || localName.equals("interface") || localName.equals("implements") || localName.equals("property") || localName.equals("datastore-identity") || localName.equals("inheritance") || localName.equals("primary-key") || localName.equals("version") || localName.equals("unmapped") || localName.equals("query") || localName.equals("sequence") || localName.equals("field") || localName.equals("map") || localName.equals("element") || localName.equals("embedded") || localName.equals("key") || localName.equals("value") || localName.equals("array") || localName.equals("collection") || localName.equals("join") || localName.equals("index") || localName.equals("unique") || localName.equals("foreign-key") || localName.equals("order") || localName.equals("fetch-group") || localName.equals("column") || localName.equals("discriminator")) {
            this.popStack();
        }
    }
}

