/*
 * Decompiled with CFR 0.152.
 */
package org.databene.text;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelocalizingConverter
extends FixedSourceTypeConverter<String, String> {
    private static Log logger = LogFactory.getLog(DelocalizingConverter.class);
    private Map<Character, String> replacements;

    public DelocalizingConverter() throws IOException {
        super(String.class, String.class);
        this.init();
    }

    public String convert(String source) {
        String product = source;
        for (Map.Entry<Character, String> entry : this.replacements.entrySet()) {
            product = product.replace(String.valueOf(entry.getKey()), entry.getValue());
        }
        return product;
    }

    private void init() throws IOException {
        this.replacements = new HashMap<Character, String>();
        CSVLineIterator iterator = new CSVLineIterator("org/databene/text/DelocalizingConverter.csv", ',', "iso-8859-1");
        while (iterator.hasNext()) {
            String[] tokens = iterator.next();
            if (tokens == null) continue;
            this.addReplacements(tokens);
        }
    }

    private void addReplacements(String[] tokens) {
        if (tokens.length < 2) {
            throw new ConfigurationError("At least two tokens needed to define a replacement");
        }
        String replacement = tokens[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            if (token.length() != 1) {
                throw new ConfigurationError("Source token length must be 1, wrong for token: " + token);
            }
            this.addReplacement(token.charAt(0), replacement);
        }
    }

    private void addReplacement(char original, String replacement) {
        String preset = this.replacements.get(Character.valueOf(original));
        if (preset != null) {
            if (preset.equals(replacement)) {
                logger.warn((Object)("double definition of replacement: " + original + " -> " + replacement));
            } else {
                logger.error((Object)("ambiguous definition of replacement: " + original + " -> " + replacement + " / " + preset));
            }
        }
        this.replacements.put(Character.valueOf(original), replacement);
    }
}

