/*
 * Decompiled with CFR 0.152.
 */
package org.databene.regex;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.databene.commons.CharSet;
import org.databene.commons.LocaleUtil;
import org.databene.regex.AlternativePattern;
import org.databene.regex.CharSetPattern;
import org.databene.regex.Group;
import org.databene.regex.Quantifier;
import org.databene.regex.Regex;
import org.databene.regex.RegexPart;
import org.databene.regex.RegexTokenType;
import org.databene.regex.RegexTokenizer;
import org.databene.regex.SubPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexParser {
    private Locale locale;

    public RegexParser() {
        this(LocaleUtil.getFallbackLocale());
    }

    public RegexParser(Locale locale) {
        this.locale = locale;
    }

    public Regex parse(String pattern) throws ParseException {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            return new Regex(new RegexPart(new CharSetPattern(new HashSet<Character>()), new Quantifier(0, 0)));
        }
        RegexTokenizer tokenizer = new RegexTokenizer(pattern);
        return this.parseRegex(tokenizer);
    }

    public Set<Character> parseCharSet(String regex) throws ParseException {
        return this.parseCharSet(new RegexTokenizer(regex));
    }

    public Set<Character> parseCharSet(RegexTokenizer tokenizer) throws ParseException {
        if (!tokenizer.hasNext()) {
            return null;
        }
        RegexTokenType tokenType = tokenizer.next();
        if (tokenType == RegexTokenType.SET_START) {
            tokenizer.pushBack();
            return this.parseCustomClass(tokenizer);
        }
        if (tokenType == RegexTokenType.PREDEFINED_CLASS) {
            tokenizer.pushBack();
            return this.parsePredefinedClass(tokenizer);
        }
        if (tokenType == RegexTokenType.CHARACTER) {
            return new CharSet(tokenizer.cval).getSet();
        }
        if (tokenType == RegexTokenType.DIGIT) {
            return new CharSet(tokenizer.cval).getSet();
        }
        if (tokenType == RegexTokenType.GROUP_END) {
            tokenizer.pushBack();
            return null;
        }
        if (tokenType == RegexTokenType.ALTERNATIVE_SEPARATOR) {
            tokenizer.pushBack();
            return null;
        }
        throw new IllegalStateException("Unexpected token: " + (Object)((Object)tokenType));
    }

    private Regex parseRegex(RegexTokenizer tokenizer) throws ParseException {
        RegexPart part;
        ArrayList<RegexPart> parts = new ArrayList<RegexPart>();
        while ((part = this.parsePart(tokenizer)) != null) {
            parts.add(part);
        }
        RegexPart[] partArray = new RegexPart[parts.size()];
        return parts.size() > 0 ? new Regex(parts.toArray(partArray)) : null;
    }

    private RegexPart parsePart(RegexTokenizer tokenizer) throws ParseException {
        SubPattern pattern = this.parseSubPattern(tokenizer);
        if (pattern == null) {
            return null;
        }
        Quantifier quantifier = this.parseOptionalQuantifier(tokenizer);
        return new RegexPart(pattern, quantifier);
    }

    private SubPattern parseSubPattern(RegexTokenizer tokenizer) throws ParseException {
        SubPattern subPattern;
        if (tokenizer.next() == RegexTokenType.END) {
            return null;
        }
        if (tokenizer.ttype == RegexTokenType.ALTERNATIVE_SEPARATOR) {
            tokenizer.pushBack();
            return null;
        }
        if (tokenizer.ttype == RegexTokenType.GROUP_END) {
            tokenizer.pushBack();
            return null;
        }
        if (tokenizer.ttype == RegexTokenType.GROUP_START) {
            tokenizer.pushBack();
            subPattern = this.parseGroup(tokenizer);
        } else {
            tokenizer.pushBack();
            subPattern = new CharSetPattern(this.parseCharSet(tokenizer));
        }
        if (subPattern == null) {
            return null;
        }
        return subPattern;
    }

    private SubPattern parseGroup(RegexTokenizer tokenizer) throws ParseException {
        Regex subExpression;
        tokenizer.assertNext(RegexTokenType.GROUP_START);
        ArrayList<Regex> subExpressions = new ArrayList<Regex>();
        while ((subExpression = this.parseRegex(tokenizer)) != null) {
            subExpressions.add(subExpression);
            if (tokenizer.next() == RegexTokenType.ALTERNATIVE_SEPARATOR) continue;
            tokenizer.pushBack();
        }
        tokenizer.assertNext(RegexTokenType.GROUP_END);
        switch (subExpressions.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new Group((Regex)subExpressions.get(0));
            }
        }
        return new AlternativePattern(subExpressions);
    }

    private Set<Character> parseCustomClass(RegexTokenizer tokenizer) throws ParseException {
        boolean additive;
        CharSet set = new CharSet(this.locale);
        RegexTokenType type = tokenizer.next();
        if (type != RegexTokenType.SET_START) {
            throw new ParseException("Expected '[', found: " + (Object)((Object)type), tokenizer.index());
        }
        type = tokenizer.next();
        if (type == RegexTokenType.NEGATION) {
            additive = false;
            set.addAnyCharacters();
        } else {
            additive = true;
            tokenizer.pushBack();
        }
        while (this.parseRange(tokenizer, set, additive)) {
        }
        type = tokenizer.next();
        if (type != RegexTokenType.SET_END) {
            throw new ParseException("Expected ']', found: " + (Object)((Object)type), tokenizer.index());
        }
        return set.getSet();
    }

    private boolean parseRange(RegexTokenizer tokenizer, CharSet set, boolean additive) throws ParseException {
        RegexTokenType type = tokenizer.next();
        if (type == RegexTokenType.SET_END) {
            tokenizer.pushBack();
            return false;
        }
        if (type == RegexTokenType.PREDEFINED_CLASS) {
            tokenizer.pushBack();
            if (additive) {
                this.addPredefCharClass(set, tokenizer);
            } else {
                this.removePredefCharClass(set, tokenizer);
            }
            return true;
        }
        tokenizer.pushBack();
        tokenizer.next();
        char min = tokenizer.cval;
        type = tokenizer.next();
        if (type != RegexTokenType.CHARACTER || tokenizer.cval != '-') {
            tokenizer.pushBack();
            set.add(min);
            return true;
        }
        tokenizer.next();
        char max = tokenizer.cval;
        if (additive) {
            set.addRange(min, max);
        } else {
            set.removeRange(min, max);
        }
        return true;
    }

    private Set<Character> parsePredefinedClass(RegexTokenizer tokenizer) throws ParseException {
        CharSet set = new CharSet(this.locale);
        return this.addPredefCharClass(set, tokenizer).getSet();
    }

    private CharSet addPredefCharClass(CharSet set, RegexTokenizer tokenizer) throws ParseException {
        tokenizer.assertNext(RegexTokenType.PREDEFINED_CLASS);
        char charClass = tokenizer.cval;
        return set.add(RegexParser.getPredefCharClass(charClass, this.locale));
    }

    private CharSet removePredefCharClass(CharSet set, RegexTokenizer tokenizer) throws ParseException {
        tokenizer.assertNext(RegexTokenType.PREDEFINED_CLASS);
        char charClass = tokenizer.cval;
        return set.remove(RegexParser.getPredefCharClass(charClass, this.locale));
    }

    private static Set<Character> getPredefCharClass(char charClass, Locale locale) {
        switch (charClass) {
            case '.': {
                return CharSet.getAnyCharacters();
            }
            case 'd': {
                return CharSet.getDigits();
            }
            case 'D': {
                return CharSet.getNonDigits();
            }
            case 's': {
                return CharSet.getWhitespaces();
            }
            case 'S': {
                return CharSet.getNonWhitespaces();
            }
            case 'w': {
                return CharSet.getWordChars((Locale)locale);
            }
            case 'W': {
                return CharSet.getNonWordChars();
            }
        }
        throw new IllegalArgumentException("Unsupported character class: " + charClass);
    }

    private Quantifier parseOptionalQuantifier(RegexTokenizer tokenizer) throws ParseException {
        int max;
        if (!tokenizer.hasNext()) {
            return new Quantifier(1, 1);
        }
        RegexTokenType type = tokenizer.next();
        if (type == RegexTokenType.QUANTIFIER) {
            switch (tokenizer.cval) {
                case '?': {
                    return new Quantifier(0, 1);
                }
                case '*': {
                    return new Quantifier(0, -1);
                }
                case '+': {
                    return new Quantifier(1, -1);
                }
            }
        }
        if (type != RegexTokenType.QUANTIFIER_START) {
            tokenizer.pushBack();
            return new Quantifier(1, 1);
        }
        tokenizer.assertNext(RegexTokenType.DIGIT);
        tokenizer.pushBack();
        int min = this.parseInt(tokenizer);
        type = tokenizer.next();
        if (type == RegexTokenType.CHARACTER && tokenizer.cval == ',') {
            if (tokenizer.next() == RegexTokenType.DIGIT) {
                tokenizer.pushBack();
                max = this.parseInt(tokenizer);
            } else {
                max = -1;
                tokenizer.pushBack();
            }
        } else {
            max = min;
            tokenizer.pushBack();
        }
        tokenizer.assertNext(RegexTokenType.QUANTIFIER_END);
        return new Quantifier(min, max);
    }

    private int parseInt(RegexTokenizer tokenizer) throws ParseException {
        int result = 0;
        while (tokenizer.next() == RegexTokenType.DIGIT) {
            result = result * 10 + tokenizer.cval - 48;
        }
        tokenizer.pushBack();
        return result;
    }
}

