/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.xls;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.commons.converter.NoOpConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSLineIterator
implements HeavyweightIterator<Object[]> {
    private HSSFWorkbook workbook;
    private Iterator<Row> rowIterator;
    private String[] headers;
    private Converter<String, ? extends Object> preprocessor;

    public XLSLineIterator(String uri) throws IOException {
        this(uri, 0);
    }

    public XLSLineIterator(String uri, int sheetIndex) throws IOException {
        this(uri, sheetIndex, null);
    }

    public XLSLineIterator(String uri, int sheetIndex, Converter<String, ? extends Object> preprocessor) throws IOException {
        if (preprocessor == null) {
            preprocessor = new NoOpConverter();
        }
        this.preprocessor = preprocessor;
        this.workbook = new HSSFWorkbook(IOUtil.getInputStreamForURI((String)uri));
        HSSFSheet sheet = this.workbook.getSheetAt(sheetIndex);
        this.rowIterator = sheet.rowIterator();
        Row headerRow = this.rowIterator.next();
        ArrayBuilder builder = new ArrayBuilder(String.class);
        for (int cellnum = 0; cellnum <= headerRow.getLastCellNum(); ++cellnum) {
            Cell cell = headerRow.getCell(cellnum);
            if (cell == null || cell.getCellType() == 3) continue;
            builder.append((Object)cell.getRichStringCellValue().getString());
        }
        this.headers = (String[])builder.toArray();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void close() {
        this.workbook = null;
        this.rowIterator = null;
        this.headers = new String[0];
    }

    public boolean hasNext() {
        return this.rowIterator.hasNext();
    }

    public Object[] next() {
        Row row = this.rowIterator.next();
        Object[] result = new Object[this.headers.length];
        for (int cellnum = 0; cellnum < this.headers.length; ++cellnum) {
            result[cellnum] = this.resolveCellValue(row.getCell(cellnum));
        }
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    private Object resolveCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return this.preprocessor.convert((Object)cell.getRichStringCellValue().getString());
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 3: 
            case 5: {
                return cell.getRichStringCellValue().getString();
            }
            case 2: {
                FormulaEvaluator evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 1: {
                        return this.preprocessor.convert((Object)cellValue.getStringValue());
                    }
                    case 0: {
                        return cellValue.getNumberValue();
                    }
                    case 4: {
                        return cellValue.getBooleanValue();
                    }
                    case 3: 
                    case 5: {
                        return null;
                    }
                }
                throw new IllegalStateException("Unexpected cell type: " + cellValue.getCellType());
            }
        }
        throw new ConfigurationError("Not a supported cell type: " + cell.getCellType());
    }
}

