/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.flat;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.format.PadFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileLineIterator
implements HeavyweightIterator<String[]> {
    private PadFormat[] formats;
    private boolean ignoreEmptyLines;
    private ReaderLineIterator lineIterator;
    private int lineCount;
    private String[] nextLine;

    public FlatFileLineIterator(String uri, PadFormat[] formats) throws IOException {
        this(uri, formats, SystemInfo.getFileEncoding());
    }

    public FlatFileLineIterator(String uri, PadFormat[] formats, String encoding) throws IOException {
        this(uri, formats, false, encoding);
    }

    public FlatFileLineIterator(String uri, PadFormat[] formats, boolean ignoreEmptyLines) throws IOException {
        this(uri, formats, ignoreEmptyLines, SystemInfo.getFileEncoding());
    }

    public FlatFileLineIterator(String uri, PadFormat[] formats, boolean ignoreEmptyLines, String encoding) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), formats, ignoreEmptyLines);
    }

    public FlatFileLineIterator(Reader reader, PadFormat[] formats) {
        this(reader, formats, false);
    }

    public FlatFileLineIterator(Reader reader, PadFormat[] formats, boolean ignoreEmptyLines) {
        this.lineIterator = new ReaderLineIterator(reader);
        this.formats = formats;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.lineCount = 0;
        this.nextLine = this.fetchNextLine();
    }

    public boolean hasNext() {
        return this.nextLine != null;
    }

    public String[] next() {
        String[] result = this.nextLine;
        if (this.lineIterator != null) {
            this.nextLine = this.fetchNextLine();
            ++this.lineCount;
        } else {
            this.nextLine = null;
        }
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void close() {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        this.lineIterator = null;
    }

    public int lineCount() {
        return this.lineCount;
    }

    private String[] fetchNextLine() {
        try {
            if (this.lineIterator == null) {
                return null;
            }
            String[] cells = new String[this.formats.length];
            int offset = 0;
            String line = null;
            boolean success = false;
            while (this.lineIterator.hasNext()) {
                ++this.lineCount;
                line = this.lineIterator.next();
                if (line.length() <= 0 && this.ignoreEmptyLines) continue;
                success = true;
                break;
            }
            if (!success) {
                this.close();
                return null;
            }
            if (StringUtil.isEmpty(line)) {
                return new String[0];
            }
            for (int i = 0; i < this.formats.length; ++i) {
                PadFormat format = this.formats[i];
                String cell = line.substring(offset, Math.min(offset + format.getLength(), line.length()));
                cells[i] = (String)format.parseObject(cell);
                offset += format.getLength();
            }
            return cells;
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected error. ", e);
        }
    }
}

