/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.databene.commons.Heavyweight;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.document.csv.CSVTokenType;

public class CSVTokenizer
implements Heavyweight {
    public static final char DEFAULT_SEPARATOR = ',';
    private PushbackReader reader;
    private char separator;
    public CSVTokenType ttype;
    public CSVTokenType lastType;
    public String cell;
    public int line;
    public int startColumn;
    public int endColumn;
    private int cursor;

    public CSVTokenizer(String uri) throws IOException {
        this(uri, ',');
    }

    public CSVTokenizer(String uri, char separator) throws IOException {
        this(uri, separator, SystemInfo.getFileEncoding());
    }

    public CSVTokenizer(String uri, char separator, String encoding) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), separator);
    }

    public CSVTokenizer(Reader reader) {
        this(reader, ',');
    }

    public CSVTokenizer(Reader reader, char separator) {
        this.reader = new PushbackReader(new BufferedReader(reader));
        this.separator = separator;
        this.line = 1;
        this.cursor = 1;
    }

    public CSVTokenType next() throws IOException {
        this.lastType = this.ttype;
        if (this.reader == null) {
            return this.setState(CSVTokenType.EOF, null);
        }
        if (this.lastType == CSVTokenType.EOL) {
            ++this.line;
            this.cursor = 1;
            this.endColumn = 1;
            this.startColumn = 1;
        } else {
            this.startColumn = this.endColumn = this.cursor;
        }
        int c = this.read();
        if (c == -1) {
            this.close();
            return this.setState(CSVTokenType.EOF, null);
        }
        if (c == this.separator) {
            return this.setState(CSVTokenType.CELL, "");
        }
        if (c == 13) {
            c = this.read();
            if (c != 10) {
                this.unread(c);
            }
            return this.setState(CSVTokenType.EOL, null);
        }
        if (c == 10) {
            return this.setState(CSVTokenType.EOL, null);
        }
        if (c == 34) {
            this.unread(c);
            return this.parseQuotes();
        }
        StringBuilder buffer = new StringBuilder().append((char)c);
        boolean escapeMode = false;
        while ((c = this.read()) != -1 && c != 13 && c != 10) {
            if (escapeMode) {
                c = this.unescape((char)c);
                escapeMode = false;
            } else if (c == 92) {
                escapeMode = true;
                continue;
            }
            if (c == this.separator) {
                this.endColumn = this.cursor - 2;
                return this.setState(CSVTokenType.CELL, buffer.toString());
            }
            buffer.append((char)c);
        }
        if (c == 13 || c == 10) {
            this.unread(c);
        }
        this.endColumn = this.cursor - 1;
        return this.setState(CSVTokenType.CELL, buffer.toString());
    }

    private char unescape(char c) {
        switch (c) {
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
        }
        return c;
    }

    private CSVTokenType parseQuotes() throws IOException {
        int c;
        this.read();
        StringBuilder buffer = new StringBuilder();
        while (true) {
            boolean done;
            if ((c = this.read()) != -1 && c != 34) {
                buffer.append((char)c);
                continue;
            }
            if (c == 34) {
                c = this.read();
                if (c == 34) {
                    buffer.append('\"');
                    done = false;
                } else {
                    done = true;
                }
            } else {
                done = true;
            }
            if (done) break;
        }
        if (c == 13 || c == 10) {
            this.unread(c);
            this.endColumn = this.cursor - 1;
        } else {
            this.endColumn = this.cursor - 2;
        }
        return this.setState(CSVTokenType.CELL, buffer.toString());
    }

    public void skipLine() throws IOException {
        int c;
        while ((c = this.read()) != -1 && c != 13 && c != 10) {
        }
        switch (c) {
            case -1: {
                return;
            }
            case 10: {
                return;
            }
            case 13: {
                int c2 = this.read();
                if (c2 != 10) {
                    this.unread(c2);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void unread(int c) throws IOException {
        this.reader.unread(c);
        --this.cursor;
    }

    private int read() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.cursor;
        }
        return c;
    }

    public void close() {
        if (this.reader != null) {
            IOUtil.close((Reader)this.reader);
        }
        this.reader = null;
    }

    public CSVTokenType lastTtype() {
        return this.lastType;
    }

    private CSVTokenType setState(CSVTokenType tokenType, String cell) {
        this.cell = cell;
        this.ttype = tokenType;
        return this.ttype;
    }
}

