/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.PropertyMutatorFactory;
import org.databene.commons.mutator.NamedMutator;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVToJavaBeanMapper<E>
implements Iterator<E> {
    private CSVLineIterator iterator;
    private Class<E> type;
    private String emptyValue;
    private NamedMutator[] mutators;

    public CSVToJavaBeanMapper(Reader reader, Class<E> type) throws IOException {
        this(reader, type, ',', null);
    }

    public CSVToJavaBeanMapper(Reader reader, Class<E> type, char separator, String emptyValue) throws IOException {
        this.iterator = new CSVLineIterator(reader, separator);
        this.type = type;
        this.emptyValue = emptyValue;
        String[] attributeNames = this.iterator.next();
        this.mutators = new NamedMutator[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.mutators[i] = PropertyMutatorFactory.getPropertyMutator(type, (String)attributeName, (boolean)false);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        int i = 0;
        try {
            String[] line = this.iterator.next();
            Object bean = BeanUtil.newInstance(this.type, (Object[])new Object[0]);
            int columns = Math.min(line.length, this.mutators.length);
            for (i = 0; i < columns; ++i) {
                String value = line[i];
                if (value.length() == 0) {
                    value = this.emptyValue;
                }
                this.mutators[i].setValue(bean, (Object)value);
            }
            return (E)bean;
        }
        catch (UpdateFailedException e) {
            throw new ConfigurationError("Failed to set property '" + this.mutators[i].getName() + "' on class " + this.type);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

