/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.databene.commons.CollectionUtil;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.document.csv.CSVLineHandler;
import org.databene.document.csv.CSVTokenType;
import org.databene.document.csv.CSVTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVLineIterator
implements HeavyweightIterator<String[]> {
    public static final char DEFAULT_SEPARATOR = ',';
    private CSVTokenizer tokenizer;
    private String[] nextLine;
    private boolean ignoreEmptyLines;
    private int lineCount;
    private boolean eol;

    public CSVLineIterator(String uri) throws IOException {
        this(uri, ',');
    }

    public CSVLineIterator(String uri, char separator) throws IOException {
        this(uri, separator, false);
    }

    public CSVLineIterator(String uri, char separator, String encoding) throws IOException {
        this(uri, separator, false, encoding);
    }

    public CSVLineIterator(String uri, char separator, boolean ignoreEmptyLines) throws IOException {
        this(uri, separator, ignoreEmptyLines, SystemInfo.getFileEncoding());
    }

    public CSVLineIterator(String uri, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), separator, ignoreEmptyLines);
    }

    public CSVLineIterator(Reader reader) throws IOException {
        this(reader, ',', false);
    }

    public CSVLineIterator(Reader reader, char separator) throws IOException {
        this(reader, separator, false);
    }

    public CSVLineIterator(Reader reader, char separator, boolean ignoreEmptyLines) throws IOException {
        this.tokenizer = new CSVTokenizer(reader, separator);
        this.nextLine = this.parseNextLine();
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.lineCount = 0;
        this.eol = false;
    }

    public boolean hasNext() {
        return this.nextLine != null;
    }

    public String[] next() {
        if (!this.hasNext()) {
            throw new IllegalStateException(this.getClass().getName() + " is not available any more. Check hasNext() for availability before calling next()");
        }
        try {
            String[] result = this.nextLine;
            if (this.tokenizer != null) {
                this.nextLine = this.parseNextLine();
                ++this.lineCount;
            } else {
                this.nextLine = null;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void close() {
        if (this.tokenizer != null) {
            this.tokenizer.close();
        }
        this.tokenizer = null;
    }

    public int lineCount() {
        return this.lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(String uri, char separator, String encoding, boolean ignoreEmptyLines, CSVLineHandler lineHandler) throws IOException {
        CSVLineIterator iterator = null;
        try {
            iterator = new CSVLineIterator(uri, separator, ignoreEmptyLines, encoding);
            while (iterator.hasNext()) {
                lineHandler.handle(iterator.next());
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    private String[] parseNextLine() throws IOException {
        ArrayList<String> list;
        CSVTokenType tokenType;
        if (this.tokenizer == null) {
            return null;
        }
        do {
            list = new ArrayList<String>();
            while ((tokenType = this.tokenizer.next()) == CSVTokenType.CELL) {
                list.add(this.tokenizer.cell);
            }
            if (tokenType != CSVTokenType.EOF) continue;
            this.close();
        } while (tokenType != CSVTokenType.EOF && this.ignoreEmptyLines && list.size() == 0);
        if (list.size() > 0) {
            this.eol = tokenType == CSVTokenType.EOL;
            return (String[])CollectionUtil.toArray(list, String.class);
        }
        if (this.eol && !this.ignoreEmptyLines) {
            return new String[0];
        }
        return null;
    }
}

