/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.databene.gui.swing.table.item.FieldConnector;
import org.databene.gui.swing.table.item.ItemModel;

public class ItemColumnTableModel
extends AbstractTableModel
implements ListDataListener {
    private ItemModel itemModel;
    private FieldConnector headerConnector;

    public ItemColumnTableModel(ItemModel model, FieldConnector headerConnector) {
        this.setItemModel(model, headerConnector);
    }

    public ItemModel getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(ItemModel model, FieldConnector headerConnector) {
        this.itemModel = model;
        if (this.itemModel != null) {
            model.getItems().addListDataListener(this);
        }
        this.headerConnector = headerConnector;
        this.fireTableStructureChanged();
    }

    public FieldConnector getHeaderConnector() {
        return this.headerConnector;
    }

    public int getRowCount() {
        if (this.itemModel == null) {
            return 0;
        }
        return this.itemModel.getConnectors().getSize();
    }

    public int getColumnCount() {
        if (this.itemModel == null) {
            return 0;
        }
        return 1 + this.itemModel.getItems().getSize();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return null;
        }
        FieldConnector connector = this.getConnector(rowIndex);
        if (columnIndex == 0) {
            return connector.getDisplayName();
        }
        return connector.getValueFor(this.getItem(columnIndex));
    }

    public String getColumnName(int columnIndex) {
        if (this.itemModel == null) {
            return null;
        }
        return (String)this.headerConnector.getValueFor(this.getItem(columnIndex));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return false;
        }
        return this.getConnector(rowIndex).getEditor() != null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return;
        }
        Object item = this.getItem(columnIndex);
        this.itemModel.mutateField(item, this.getConnector(rowIndex), value);
    }

    public void intervalAdded(ListDataEvent e) {
        this.fireTableDataChanged();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.fireTableDataChanged();
    }

    public void contentsChanged(ListDataEvent e) {
        this.fireTableDataChanged();
    }

    private Object getItem(int column) {
        if (this.itemModel == null) {
            return null;
        }
        return this.itemModel.getItems().getElementAt(column - 1);
    }

    private FieldConnector getConnector(int rowIndex) {
        return (FieldConnector)this.itemModel.getConnectors().getElementAt(rowIndex);
    }
}

