/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.databene.gui.swing.table.item.FieldConnector;

public class ItemColumn
extends TableColumn {
    public ItemColumn(int index, int minWidth, ListModel connectorListModel) {
        super(index);
        if (minWidth == 0) {
            minWidth = 64;
        }
        this.setMinWidth(minWidth);
        this.setPreferredWidth(minWidth);
        this.setConnectorListModel(connectorListModel);
    }

    public void setConnectorListModel(ListModel connectorListModel) {
        this.setCellRenderer(new Renderer(connectorListModel));
        this.setCellEditor(new Editor(connectorListModel));
    }

    private class Editor
    implements TableCellEditor {
        private ListModel connectorListModel;
        private TableCellEditor currentEditor;

        public Editor(ListModel connectorListModel) {
            this.connectorListModel = connectorListModel;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.connectorListModel == null) {
                throw new RuntimeException("connectorListModel has not been initialized");
            }
            FieldConnector connector = (FieldConnector)this.connectorListModel.getElementAt(row);
            this.currentEditor = connector.getEditor();
            return this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.currentEditor.addCellEditorListener(l);
        }

        public void cancelCellEditing() {
            this.currentEditor.cancelCellEditing();
        }

        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }

        public boolean isCellEditable(EventObject anEvent) {
            return this.currentEditor.isCellEditable(anEvent);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.currentEditor.removeCellEditorListener(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return this.currentEditor.shouldSelectCell(anEvent);
        }

        public boolean stopCellEditing() {
            return this.currentEditor.stopCellEditing();
        }
    }

    private class Renderer
    implements TableCellRenderer {
        private ListModel connectorListModel;

        public Renderer(ListModel connectorListModel) {
            this.connectorListModel = connectorListModel;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.connectorListModel == null) {
                throw new RuntimeException("connectorListModel has not been initialized");
            }
            FieldConnector connector = (FieldConnector)this.connectorListModel.getElementAt(row);
            TableCellRenderer renderer = connector.getRenderer();
            return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

