/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.databene.gui.swing.table.item.FieldConnector;
import org.databene.gui.swing.table.item.ItemModel;

public class ConnectorColumnTableModel
extends AbstractTableModel {
    private ItemModel itemModel;

    public ConnectorColumnTableModel(ItemModel model) {
        this.setItemModel(model);
    }

    public ItemModel getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(ItemModel model) {
        this.itemModel = model;
        if (this.itemModel != null) {
            model.getItems().addListDataListener(new Listener());
        }
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.itemModel == null) {
            return 0;
        }
        return this.itemModel.getItems().getSize();
    }

    public int getColumnCount() {
        if (this.itemModel == null) {
            return 0;
        }
        return this.itemModel.getConnectors().getSize();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return null;
        }
        Object item = this.getItem(rowIndex);
        if (item == null) {
            return null;
        }
        return this.getConnector(columnIndex).getValueFor(item);
    }

    private FieldConnector getConnector(int columnIndex) {
        return (FieldConnector)this.itemModel.getConnectors().getElementAt(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        if (this.itemModel == null) {
            return null;
        }
        return this.getConnector(columnIndex).getDisplayName();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return false;
        }
        return this.getConnector(columnIndex).getEditor() != null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.itemModel == null) {
            return;
        }
        Object item = this.getItem(rowIndex);
        this.itemModel.mutateField(item, this.getConnector(columnIndex), value);
    }

    private Object getItem(int row) {
        if (this.itemModel == null) {
            return null;
        }
        return this.itemModel.getItems().getElementAt(row);
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent e) {
            ConnectorColumnTableModel.this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            ConnectorColumnTableModel.this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        public void contentsChanged(ListDataEvent e) {
            ConnectorColumnTableModel.this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
        }
    }
}

