/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.databene.gui.swing.table.item.ItemModel;
import org.databene.gui.swing.table.item.adapter.ConnectorColumnModel;
import org.databene.gui.swing.table.item.adapter.ConnectorColumnTableModel;

public class ConnectorColumnTable
extends JTable {
    public ConnectorColumnTable(ItemModel model) {
        super(new ConnectorColumnTableModel(model), new ConnectorColumnModel(model != null ? model.getConnectors() : null));
        this.setAutoCreateColumnsFromModel(true);
        this.setRowHeight(16);
        this.setShowHorizontalLines(false);
        this.getColumnModel().addColumnModelListener(new Listener());
    }

    public void setItemModel(ItemModel itemModel) {
        ((ConnectorColumnTableModel)this.getModel()).setItemModel(itemModel);
        ListModel connectors = itemModel != null ? itemModel.getConnectors() : null;
        this.setConnectors(connectors);
    }

    public ItemModel getItemModel() {
        return ((ConnectorColumnTableModel)this.getModel()).getItemModel();
    }

    public void createDefaultColumnsFromModel() {
        if (this.getItemModel() != null) {
            this.setConnectors(this.getItemModel().getConnectors());
        }
    }

    public int rowAtPoint(int x, int y) {
        return super.rowAtPoint(new Point(x, y));
    }

    public ListSelectionModel getSelectionModel() {
        return super.getSelectionModel();
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component component = super.prepareEditor(editor, row, column);
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).selectAll();
        }
        return component;
    }

    private void setConnectors(ListModel connectors) {
        ConnectorColumnModel columnModel = (ConnectorColumnModel)this.getColumnModel();
        columnModel.setConnectors(connectors);
        this.initColumnWidths();
    }

    private void initColumnWidths() {
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        ConnectorColumnModel columnModel = (ConnectorColumnModel)this.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn tColumn = this.getColumnModel().getColumn(i);
            Component comp = headerRenderer.getTableCellRendererComponent(this, tColumn.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width;
            comp = tColumn.getCellRenderer().getTableCellRendererComponent(this, null, false, false, 0, 0);
            int cellWidth = comp.getPreferredSize().width;
            tColumn.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    private class Listener
    implements TableColumnModelListener {
        private Listener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            ConnectorColumnTable.this.initColumnWidths();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

