/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item.adapter;

import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.databene.gui.swing.table.item.FieldConnector;
import org.databene.gui.swing.table.item.adapter.ConnectorTableColumn;

public class ConnectorColumnModel
extends DefaultTableColumnModel {
    private ListModel connectors;
    private Listener listener = new Listener();

    public ConnectorColumnModel(ListModel connectors) {
        this.setConnectors(connectors);
    }

    public void setConnectors(ListModel connectors) {
        if (this.connectors != null) {
            this.connectors.removeListDataListener(this.listener);
        }
        ListModel listModel = this.connectors = connectors != null ? connectors : null;
        if (this.connectors != null) {
            this.connectors.addListDataListener(this.listener);
        }
        this.rebuildColumns();
    }

    public TableColumn getColumn(int columnIndex) {
        return super.getColumn(columnIndex);
    }

    private void rebuildColumns() {
        int i;
        for (i = this.tableColumns.size() - 1; i >= 0; --i) {
            TableColumn tableColumn = (TableColumn)this.tableColumns.get(i);
            this.removeColumn(tableColumn);
        }
        if (this.connectors != null) {
            for (i = 0; i < this.connectors.getSize(); ++i) {
                FieldConnector connector = (FieldConnector)this.connectors.getElementAt(i);
                this.addConnectorColumn(connector, i);
            }
        }
    }

    private void addConnectorColumn(FieldConnector connector, int i) {
        ConnectorTableColumn tColumn = new ConnectorTableColumn(connector, i);
        super.addColumn(tColumn);
    }

    private void insertConnectorColumn(FieldConnector connector, int i) {
        ConnectorTableColumn tColumn = new ConnectorTableColumn(connector, i);
        this.insertTableColumn(tColumn, i);
    }

    private void insertTableColumn(TableColumn column, int index) {
        if (column == null) {
            throw new IllegalArgumentException("column is null");
        }
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            TableColumn col = (TableColumn)this.tableColumns.get(i);
            int modelIndex = col.getModelIndex();
            if (modelIndex < index) continue;
            col.setModelIndex(modelIndex + 1);
        }
        this.tableColumns.insertElementAt(column, index);
        column.addPropertyChangeListener(this);
        this.totalColumnWidth = -1;
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    private void removeTableColumn(int index) {
        super.removeColumn(this.getColumn(index));
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            TableColumn col = (TableColumn)this.tableColumns.get(i);
            int modelIndex = col.getModelIndex();
            if (modelIndex <= index) continue;
            col.setModelIndex(modelIndex - 1);
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent e) {
            for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                ConnectorColumnModel.this.insertConnectorColumn((FieldConnector)ConnectorColumnModel.this.connectors.getElementAt(i), i);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                ConnectorColumnModel.this.removeTableColumn(i);
            }
        }

        public void contentsChanged(ListDataEvent e) {
            ConnectorColumnModel.this.rebuildColumns();
        }
    }
}

