/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.table.item;

import java.util.List;
import javax.swing.AbstractListModel;
import org.databene.gui.swing.table.item.ConfigurableListModel;
import org.databene.gui.swing.table.item.ConnectorListener;
import org.databene.gui.swing.table.item.FieldConnector;

public class DefaultConnectorListModel
extends AbstractListModel
implements ConfigurableListModel {
    private List connectors;
    private ColumnListener columnListener;
    private Object displaySettings;

    public DefaultConnectorListModel(List connectors) {
        this(connectors, null);
    }

    public DefaultConnectorListModel(List connectors, Object displaySettings) {
        this.connectors = connectors;
        this.displaySettings = displaySettings;
        this.columnListener = new ColumnListener();
        this.registerColumnListener();
    }

    public void dispose() {
        this.unregisterColumnListener();
        this.columnListener = null;
        this.connectors = null;
    }

    public Object getConfiguration() {
        return this.displaySettings;
    }

    public int getSize() {
        return this.connectors.size();
    }

    public Object getElementAt(int index) {
        return this.connectors.get(index);
    }

    private void registerColumnListener() {
        for (int i = 0; i < this.connectors.size(); ++i) {
            FieldConnector accessor = (FieldConnector)this.connectors.get(i);
            accessor.addConnectorListener(this.columnListener);
        }
    }

    private void unregisterColumnListener() {
        for (int i = 0; i < this.connectors.size(); ++i) {
            FieldConnector accessor = (FieldConnector)this.connectors.get(i);
            accessor.removeConnectorListener(this.columnListener);
        }
    }

    private class ColumnListener
    implements ConnectorListener {
        private ColumnListener() {
        }

        public void connectorChanged(FieldConnector accessor) {
            int index = DefaultConnectorListModel.this.connectors.indexOf(accessor);
            DefaultConnectorListModel.this.fireContentsChanged(DefaultConnectorListModel.this, index, index);
        }
    }
}

