/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.delegate;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.databene.commons.BeanUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ObservableBean;
import org.databene.commons.converter.ToStringConverter;

public class PropertyTextField
extends JTextField {
    private static final long serialVersionUID = -6986676080916477887L;
    private Object bean;
    private String propertyName;
    private ToStringConverter toStringConverter;
    boolean locked;

    public PropertyTextField(Object bean, String propertyName, int length) {
        super(length);
        this.bean = bean;
        this.propertyName = propertyName;
        this.toStringConverter = new ToStringConverter();
        this.locked = true;
        Listener listener = new Listener();
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(propertyName, (PropertyChangeListener)listener);
        }
        this.getDocument().addDocumentListener(listener);
        this.locked = false;
        this.refresh();
    }

    void refresh() {
        if (!this.locked) {
            this.locked = true;
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            String text = this.toStringConverter.convert(propertyValue);
            text = StringUtil.escape((String)text);
            if (!this.getText().equals(text)) {
                this.setText(text);
            }
            this.locked = false;
        }
    }

    void update() {
        if (!this.locked) {
            String text;
            this.locked = true;
            Document document = this.getDocument();
            try {
                text = document.getText(0, document.getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            text = StringUtil.escape((String)text);
            if (!text.equals(BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName))) {
                BeanUtil.setPropertyValue((Object)this.bean, (String)this.propertyName, (Object)text);
            }
            this.locked = false;
        }
    }

    class Listener
    implements PropertyChangeListener,
    DocumentListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyTextField.this.refresh();
        }

        public void changedUpdate(DocumentEvent evt) {
            PropertyTextField.this.update();
        }

        public void insertUpdate(DocumentEvent evt) {
            PropertyTextField.this.update();
        }

        public void removeUpdate(DocumentEvent evt) {
            PropertyTextField.this.update();
        }
    }
}

