/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.delegate;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.bean.ObservableBean;
import org.databene.commons.ui.I18NSupport;
import org.databene.gui.swing.FileList;

public class PropertyFileList
extends FileList {
    private static final long serialVersionUID = -1259803129031396860L;
    private Object bean;
    private String propertyName;
    boolean locked;

    public PropertyFileList(Object bean, String propertyName, I18NSupport i18n) {
        super(i18n);
        this.bean = bean;
        this.propertyName = propertyName;
        this.locked = true;
        this.refresh();
        Listener listener = new Listener();
        this.model.addListDataListener(listener);
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(propertyName, (PropertyChangeListener)listener);
        }
        this.locked = false;
    }

    void refresh() {
        if (!this.locked) {
            this.locked = true;
            Object propertyValue = BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            Object[] files = (File[])propertyValue;
            if (!CollectionUtil.ofEqualContent(this.getFiles(), (Object[])files)) {
                this.setFiles((File[])files);
            }
            this.locked = false;
        }
    }

    void update() {
        if (!this.locked) {
            this.locked = true;
            Object[] modelFiles = (File[])BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            List<File> viewFiles = this.getFiles();
            if (!CollectionUtil.ofEqualContent(viewFiles, (Object[])modelFiles)) {
                File[] files = (File[])CollectionUtil.toArray(viewFiles, File.class);
                BeanUtil.setPropertyValue((Object)this.bean, (String)this.propertyName, (Object)files);
            }
            this.locked = false;
        }
    }

    class Listener
    implements PropertyChangeListener,
    ListDataListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyFileList.this.refresh();
        }

        public void contentsChanged(ListDataEvent evt) {
            PropertyFileList.this.update();
        }

        public void intervalAdded(ListDataEvent evt) {
            PropertyFileList.this.update();
        }

        public void intervalRemoved(ListDataEvent evt) {
            PropertyFileList.this.update();
        }
    }
}

