/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing.delegate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import org.databene.commons.BeanUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.bean.ObservableBean;

public class PropertyCheckBox
extends JCheckBox {
    private static final long serialVersionUID = 2502918170512919334L;
    private Object bean;
    private String propertyName;
    boolean locked;

    public PropertyCheckBox(Object bean, String propertyName, String label) {
        super(label);
        this.bean = bean;
        this.propertyName = propertyName;
        this.locked = true;
        Listener listener = new Listener();
        if (bean instanceof ObservableBean) {
            ((ObservableBean)bean).addPropertyChangeListener(propertyName, (PropertyChangeListener)listener);
        }
        this.getModel().addActionListener(listener);
        this.locked = false;
        this.refresh();
    }

    void refresh() {
        if (!this.locked) {
            this.locked = true;
            boolean propertyValue = (Boolean)BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            boolean selected = this.isSelected();
            if (selected != propertyValue) {
                this.setSelected(propertyValue);
            }
            this.locked = false;
        }
    }

    void update() {
        if (!this.locked) {
            this.locked = true;
            Boolean propertyValue = (Boolean)BeanUtil.getPropertyValue((Object)this.bean, (String)this.propertyName);
            Boolean selected = this.isSelected();
            if (!NullSafeComparator.equals((Object)selected, (Object)propertyValue)) {
                BeanUtil.setPropertyValue((Object)this.bean, (String)this.propertyName, (Object)selected);
            }
            this.locked = false;
        }
    }

    class Listener
    implements PropertyChangeListener,
    ActionListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyCheckBox.this.refresh();
        }

        public void actionPerformed(ActionEvent arg0) {
            PropertyCheckBox.this.update();
        }
    }
}

