/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ui.I18NSupport;
import org.databene.gui.swing.ArrayListModel;
import org.databene.gui.swing.FilePathListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileList
extends JPanel {
    private static final long serialVersionUID = -5042653089516904515L;
    private I18NSupport i18n;
    private JList list;
    protected ArrayListModel model;
    private JFileChooser chooser;

    public FileList(I18NSupport i18n) {
        super(new BorderLayout());
        this.i18n = i18n;
        this.model = new ArrayListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(1);
        this.list.setCellRenderer(new FilePathListCellRenderer());
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add(this.createButtonPane(), "East");
        this.chooser = new JFileChooser(".");
        this.chooser.setMultiSelectionEnabled(true);
    }

    public List<File> getFiles() {
        return this.model.getAll();
    }

    public void setFiles(File[] files) {
        this.model.setAll(files);
    }

    public List<File> getSelectedFiles() {
        return CollectionUtil.toListOfType((Object[])this.list.getSelectedValues());
    }

    void add() {
        int action = this.chooser.showOpenDialog(this);
        if (action == 0) {
            File[] selectedFiles;
            for (File file : selectedFiles = this.chooser.getSelectedFiles()) {
                this.model.add(file);
            }
        }
    }

    void remove() {
        int[] selectedIndices = this.list.getSelectedIndices();
        if (selectedIndices != null && selectedIndices.length > 0) {
            for (int i = selectedIndices.length - 1; i >= 0; --i) {
                this.model.remove(selectedIndices[i]);
            }
        }
    }

    void up() {
        ListSelectionModel selectionModel = this.list.getSelectionModel();
        int from = selectionModel.getMinSelectionIndex();
        int to = selectionModel.getMaxSelectionIndex();
        if (from > 0) {
            File top = (File)this.model.getElementAt(from - 1);
            for (int i = from; i <= to; ++i) {
                this.model.set(i - 1, (File)this.model.getElementAt(i));
            }
            this.model.set(to, top);
            selectionModel.setSelectionInterval(from - 1, to - 1);
        }
    }

    void down() {
        ListSelectionModel selectionModel = this.list.getSelectionModel();
        int from = selectionModel.getMinSelectionIndex();
        int to = selectionModel.getMaxSelectionIndex();
        if (from >= 0 && to < this.model.getSize() - 1) {
            File bottom = (File)this.model.getElementAt(to + 1);
            for (int i = to; i >= from; --i) {
                this.model.set(i + 1, (File)this.model.getElementAt(i));
            }
            this.model.set(from, bottom);
            selectionModel.setSelectionInterval(from + 1, to + 1);
        }
    }

    private Component createButtonPane() {
        Box box = Box.createVerticalBox();
        box.add(new JButton(new AddAction()));
        box.add(new JButton(new RemoveAction()));
        box.add(new JButton(new UpAction()));
        box.add(new JButton(new DownAction()));
        return box;
    }

    private class DownAction
    extends ItemAction {
        public DownAction() {
            super("down");
        }

        public void actionPerformed(ActionEvent evt) {
            FileList.this.down();
        }
    }

    private class UpAction
    extends ItemAction {
        public UpAction() {
            super("up");
        }

        public void actionPerformed(ActionEvent evt) {
            FileList.this.up();
        }
    }

    private class RemoveAction
    extends ItemAction {
        public RemoveAction() {
            super("remove");
        }

        public void actionPerformed(ActionEvent evt) {
            FileList.this.remove();
        }
    }

    class AddAction
    extends I18NAction {
        public AddAction() {
            super("add");
        }

        public void actionPerformed(ActionEvent evt) {
            FileList.this.add();
        }
    }

    abstract class ItemAction
    extends I18NAction
    implements ListSelectionListener {
        public ItemAction(String name, Icon icon) {
            super(name, icon);
            FileList.this.list.getSelectionModel().addListSelectionListener(this);
            this.setEnabled(false);
        }

        public ItemAction(String name) {
            this(name, null);
        }

        public void valueChanged(ListSelectionEvent evt) {
            this.setEnabled(FileList.this.list.getSelectedValues().length > 0);
        }
    }

    abstract class I18NAction
    extends AbstractAction {
        public I18NAction(String name, Icon icon) {
            super(FileList.this.i18n.getString(name), icon);
        }

        public I18NAction(String name) {
            super(FileList.this.i18n.getString(name));
        }
    }
}

