/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CompositeListModel
extends AbstractListModel {
    private static final long serialVersionUID = 6500619424821631785L;
    private List<ListModel> subListModels;
    private List<Object> items;
    private ListDataListener listener;

    public CompositeListModel(ListModel ... subListModels) {
        this.subListModels = new ArrayList<ListModel>(subListModels.length);
        this.items = new ArrayList<Object>();
        this.listener = new Listener();
        for (ListModel subModel : subListModels) {
            this.addSubListModel(subModel);
        }
    }

    public void addSubListModel(ListModel listModel) {
        int index0 = this.items.size();
        this.subListModels.add(listModel);
        this.synch();
        int index1 = index0 + listModel.getSize() - 1;
        listModel.addListDataListener(this.listener);
        this.fireIntervalAdded(this, index0, index1);
    }

    public int getSize() {
        return this.items.size();
    }

    public Object getElementAt(int index) {
        return index < this.items.size() ? this.items.get(index) : null;
    }

    private void synch() {
        this.items.clear();
        for (ListModel subListModel : this.subListModels) {
            for (int j = 0; j < subListModel.getSize(); ++j) {
                Object item = subListModel.getElementAt(j);
                this.items.add(item);
            }
        }
    }

    private int indexOfFirstElement(ListModel listModel) {
        int base = 0;
        for (ListModel test : this.subListModels) {
            if (test == listModel) break;
            base += test.getSize();
        }
        return base;
    }

    class Listener
    implements ListDataListener {
        Listener() {
        }

        public void contentsChanged(ListDataEvent e) {
            CompositeListModel.this.synch();
            CompositeListModel.this.fireContentsChanged(CompositeListModel.this, 0, CompositeListModel.this.items.size() - 1);
        }

        public void intervalAdded(ListDataEvent e) {
            ListModel listModel = (ListModel)e.getSource();
            int base = CompositeListModel.this.indexOfFirstElement(listModel);
            int index0 = base + e.getIndex0();
            int index1 = base + e.getIndex1();
            CompositeListModel.this.synch();
            CompositeListModel.this.fireIntervalAdded(CompositeListModel.this, index0, index1);
        }

        public void intervalRemoved(ListDataEvent e) {
            ListModel listModel = (ListModel)e.getSource();
            int base = CompositeListModel.this.indexOfFirstElement(listModel);
            int index0 = base + e.getIndex0();
            int index1 = base + e.getIndex1();
            CompositeListModel.this.synch();
            CompositeListModel.this.fireIntervalRemoved(CompositeListModel.this, index0, index1);
        }
    }
}

