/*
 * Decompiled with CFR 0.152.
 */
package org.databene.gui.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class AlignedPane
extends JPanel
implements SwingConstants {
    private static final long serialVersionUID = -5911452561809191394L;
    private int orientation;
    private GridBagConstraints gbc;
    private int columns;

    public static AlignedPane createHorizontalPane() {
        return new AlignedPane(0, 0);
    }

    public static AlignedPane createVerticalPane() {
        return AlignedPane.createVerticalPane(2);
    }

    public static AlignedPane createVerticalPane(int columns) {
        return new AlignedPane(1, columns);
    }

    protected AlignedPane() {
        this(1, 2);
    }

    protected AlignedPane(int orientation, int columns) {
        this.columns = columns;
        this.orientation = orientation;
        if (orientation == 1) {
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 2, 2);
        } else if (orientation == 0) {
            this.setLayout(new FlowLayout());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addElement(String title, Component component) {
        this.addElement(title, component, 1);
    }

    public void addElement(String title, Component component, int gridwidth) {
        JLabel label = new JLabel(title);
        if (this.orientation == 0) {
            this.add(label);
            this.add(component);
        } else {
            this.addElement(label, 1);
            this.addElement(component, gridwidth);
        }
    }

    public void addElement(Component component) {
        this.addElement(component, 1);
    }

    public void addElement(Component component, int gridwidth) {
        if (this.orientation == 0) {
            this.add(component);
        } else {
            this.gbc.weightx = !(component instanceof JLabel) ? 1 : 0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = gridwidth;
            this.add(component, this.gbc);
            ++this.gbc.gridx;
        }
    }

    public void endRow() {
        if (this.orientation == 1 && this.gbc.gridx > 0) {
            this.newRow();
        }
    }

    private void newRow() {
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
    }

    public void addRow(String title, Component component) {
        JLabel label = new JLabel(title);
        if (this.orientation == 0) {
            this.add(label);
            this.add(component);
        } else {
            this.endRow();
            this.addElement(title, component, this.columns - 1);
            this.endRow();
        }
    }

    public void addRow(Component component) {
        if (this.orientation == 0) {
            this.add(component, this.gbc);
            ++this.gbc.gridx;
        } else {
            this.endRow();
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = this.columns;
            this.add(component, this.gbc);
            ++this.gbc.gridx;
            this.newRow();
        }
    }

    public void addTallRow(Component component) {
        if (this.orientation == 0) {
            this.add(component);
        } else {
            this.endRow();
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.gbc.gridwidth = this.columns;
            this.add(component, this.gbc);
            this.endRow();
        }
    }

    public void addSeparator() {
        this.addLabelRow(" ");
    }

    public void addLabelRow(String text) {
        this.addRow(new JLabel(text));
    }
}

