/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import org.dashj.bls.BLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLSJniLibrary {
    private static final Logger log = LoggerFactory.getLogger(BLSJniLibrary.class);
    public static String LIBRARY_NAME = "dashjbls";
    public static String VERSION = "1.2.5-SNAPSHOT";
    private static boolean isLibraryLoaded = false;

    public static boolean isIsLibraryLoaded() {
        return isLibraryLoaded;
    }

    public static void loadLibrary() {
        BLSJniLibrary.loadLibrary(true);
    }

    public static void loadLibrary(boolean throwExceptionOnFailure) {
        block2: {
            try {
                System.loadLibrary(LIBRARY_NAME);
                log.info("{} was loaded successfully", (Object)LIBRARY_NAME);
                isLibraryLoaded = true;
            }
            catch (SecurityException | UnsatisfiedLinkError x) {
                isLibraryLoaded = false;
                log.error("{} was not loaded successfully", (Object)LIBRARY_NAME);
                if (!throwExceptionOnFailure) break block2;
                throw new RuntimeException(x.getMessage(), x);
            }
        }
    }

    public static void init() {
        BLSJniLibrary.init(true);
    }

    public static void init(boolean throwExceptionOnFailure) {
        log.info("Initializing BLS JNI Library");
        if (!isLibraryLoaded) {
            BLSJniLibrary.loadLibrary(throwExceptionOnFailure);
        }
        if (isLibraryLoaded) {
            BLS.init();
        }
    }
}

