/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.kieserver.dataset.editor.impl;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.kieserver.dataset.editor.RemoteDataSetDefAttributesEditor;
import org.dashbuilder.client.kieserver.resources.i18n.KieServerClientConstants;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.dashbuilder.kieserver.KieServerConnectionInfoProvider;
import org.dashbuilder.kieserver.RemoteDataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.mvp.UberView;

@Dependent
public class RemoteDataSetDefAttributesEditorImpl
implements IsWidget,
RemoteDataSetDefAttributesEditor {
    DropDownEditor queryTarget;
    DropDownEditor serverTemplateId;
    ValueBoxEditor<String> dataSource;
    ValueBoxEditor<String> dbSQL;
    public View view;
    private Caller<KieServerConnectionInfoProvider> kieServerConnectionInfoProvider;

    @Inject
    public RemoteDataSetDefAttributesEditorImpl(DropDownEditor queryTarget, DropDownEditor serverTemplateId, ValueBoxEditor<String> dataSource, ValueBoxEditor<String> dbSQL, View view, Caller<KieServerConnectionInfoProvider> specManagementService) {
        this.queryTarget = queryTarget;
        this.serverTemplateId = serverTemplateId;
        this.dataSource = dataSource;
        this.dbSQL = dbSQL;
        this.view = view;
        this.kieServerConnectionInfoProvider = specManagementService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.queryTarget.view, this.serverTemplateId.view, this.dataSource.view, this.dbSQL.view);
        this.queryTarget.setSelectHint(KieServerClientConstants.INSTANCE.remoteQueryTargetHint());
        List entries = Stream.of("CUSTOM", "PROCESS", "TASK", "BA_TASK", "PO_TASK", "JOBS", "FILTERED_PROCESS", "FILTERED_BA_TASK", "FILTERED_PO_TASK").map(s -> this.queryTarget.newEntry(s, s)).collect(Collectors.toList());
        this.queryTarget.setEntries(entries);
        this.queryTarget.addHelpContent(KieServerClientConstants.INSTANCE.remoteQueryTarget(), KieServerClientConstants.INSTANCE.remoteQueryTargetDescription(), Placement.RIGHT);
        this.serverTemplateId.setSelectHint(KieServerClientConstants.INSTANCE.remoteServerTemplateHint());
        ((KieServerConnectionInfoProvider)this.kieServerConnectionInfoProvider.call(serverTemplates -> this.onServerTemplateLoad((List<String>)serverTemplates))).serverTemplates();
        this.serverTemplateId.addHelpContent(KieServerClientConstants.INSTANCE.remoteServerTemplate(), KieServerClientConstants.INSTANCE.remoteServerTemplateDescription(), Placement.RIGHT);
        this.dataSource.addHelpContent(KieServerClientConstants.INSTANCE.remoteDataSetEditor(), KieServerClientConstants.INSTANCE.remoteDatasourceDescription(), Placement.BOTTOM);
        this.dbSQL.addHelpContent(KieServerClientConstants.INSTANCE.remoteDataSetEditor(), KieServerClientConstants.INSTANCE.remoteDatasourceDescription(), Placement.BOTTOM);
    }

    private void onServerTemplateLoad(List<String> templates) {
        List entries = templates.stream().map(st -> this.serverTemplateId.newEntry(st, st)).collect(Collectors.toList());
        this.serverTemplateId.setEntries(entries);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DropDownEditor queryTarget() {
        return this.queryTarget;
    }

    public DropDownEditor serverTemplateId() {
        return this.serverTemplateId;
    }

    @Override
    public ValueBoxEditor<String> dataSource() {
        return this.dataSource;
    }

    public ValueBoxEditor<String> dbSQL() {
        return this.dbSQL;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setDelegate(EditorDelegate<RemoteDataSetDef> delegate) {
    }

    public void setValue(RemoteDataSetDef value) {
        this.queryTarget.setValue(value.getQueryTarget());
        this.serverTemplateId.setValue(value.getServerTemplateId());
    }

    public static interface View
    extends UberView<RemoteDataSetDefAttributesEditorImpl> {
        public void initWidgets(DropDownEditor.View var1, DropDownEditor.View var2, ValueBoxEditor.View var3, ValueBoxEditor.View var4);
    }
}

