/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.factory.page;

import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.dsl.factory.component.ComponentFactory;
import org.dashbuilder.dsl.factory.page.ColumnBuilder;
import org.dashbuilder.dsl.factory.page.PageBuilder;
import org.dashbuilder.dsl.factory.page.RowBuilder;
import org.dashbuilder.dsl.model.Column;
import org.dashbuilder.dsl.model.Component;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.dsl.model.Row;

public class PageFactory {
    private PageFactory() {
    }

    public static PageBuilder pageBuilder(String name) {
        return PageBuilder.newBuilder(name);
    }

    public static RowBuilder rowBuilder(String height) {
        return RowBuilder.newBuilder(height);
    }

    public static ColumnBuilder columnBuilder() {
        return ColumnBuilder.newBuilder();
    }

    public static ColumnBuilder columnBuilder(String span) {
        return ColumnBuilder.newBuilder(span);
    }

    public static ColumnBuilder columnBuilder(String span, Component ... components) {
        return ColumnBuilder.newBuilder(span).components(components);
    }

    public static Page page(String name, Row ... rows) {
        return PageBuilder.newBuilder(name).rows(rows).build();
    }

    public static Column column(String span, Component ... components) {
        return ColumnBuilder.newBuilder(span).components(components).build();
    }

    public static Column column(Component ... components) {
        return ColumnBuilder.newBuilder().components(components).build();
    }

    public static Column column(Component component) {
        return ColumnBuilder.newBuilder().components(component).build();
    }

    public static Column column(DisplayerSettings settings) {
        return ColumnBuilder.newBuilder().components(ComponentFactory.displayer(settings)).build();
    }

    public static Column column(Row row) {
        return ColumnBuilder.newBuilder().row(row).build();
    }

    public static Column column(Row ... rows) {
        return ColumnBuilder.newBuilder().rows(rows).build();
    }

    public static Row row(Column ... columns) {
        return RowBuilder.newBuilder().columns(columns).build();
    }

    public static Column column(String html) {
        return ColumnBuilder.newBuilder().component(ComponentFactory.html(html)).build();
    }

    public static Row row(String html) {
        return PageFactory.row(ComponentFactory.html(html));
    }

    public static Row row(Component component) {
        return PageFactory.row(PageFactory.column(component));
    }

    public static Row row(DisplayerSettings settings) {
        return PageFactory.row(PageFactory.column(settings));
    }
}

