/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.component.ExternalComponentDispatcher;
import org.dashbuilder.displayer.client.component.ExternalComponentListener;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.dashbuilder.displayer.external.ExternalFilterRequest;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ExternalComponentPresenter
implements ExternalComponentListener {
    private static final String COMPONENT_SERVER_PATH = "dashbuilder/component";
    final String componentRuntimeId = DOM.createUniqueId();
    private Consumer<ExternalFilterRequest> filterConsumer;
    @Inject
    View view;
    @Inject
    ExternalComponentDispatcher dispatcher;
    @Inject
    ExternalComponentMessageHelper messageHelper;

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.dispatcher.register(this);
    }

    @PreDestroy
    public void destroy() {
        this.dispatcher.unregister(this);
    }

    @Override
    public String getId() {
        return this.componentRuntimeId;
    }

    @Override
    public void onFilter(ExternalFilterRequest filterRequest) {
        if (this.filterConsumer != null) {
            this.filterConsumer.accept(filterRequest);
        }
    }

    @Override
    public void prepare() {
        this.view.makeReady();
    }

    @Override
    public void onConfigurationIssue(String message) {
        this.view.configurationIssue(message);
    }

    @Override
    public void configurationOk() {
        this.view.configurationOk();
    }

    public void withComponent(String componentId) {
        String url = this.buildUrl(componentId);
        this.view.setComponentURL(url);
    }

    public void withComponent(String componentId, String partition) {
        String url = this.buildUrl(componentId, partition);
        this.view.setComponentURL(url);
    }

    @Override
    public void sendMessage(ExternalComponentMessage message) {
        this.messageHelper.withId(message, this.componentRuntimeId);
        this.view.postMessage(message);
    }

    public View getView() {
        return this.view;
    }

    public void setFilterConsumer(Consumer<ExternalFilterRequest> filterConsumer) {
        this.filterConsumer = filterConsumer;
    }

    public String getComponentId() {
        return this.componentRuntimeId;
    }

    private String buildUrl(String componentId) {
        return this.buildUrl(componentId, "");
    }

    private String buildUrl(String componentId, String partition) {
        return String.join((CharSequence)"/", GWT.getHostPageBaseURL(), COMPONENT_SERVER_PATH, partition, componentId, "index.html");
    }

    public static interface View
    extends UberView<ExternalComponentPresenter> {
        public void setComponentURL(String var1);

        public void postMessage(ExternalComponentMessage var1);

        public void makeReady();

        public void configurationIssue(String var1);

        public void configurationOk();
    }
}

