/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.component.function;

import elemental2.dom.DomGlobal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.component.function.ExternalComponentFunction;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@ApplicationScoped
public class ComponentFunctionLocator {
    @Inject
    SyncBeanManager beanManager;
    List<ExternalComponentFunction> functions;

    @PostConstruct
    void loadFunctions() {
        this.functions = this.beanManager.lookupBeans(ExternalComponentFunction.class).stream().map(SyncBeanDef::getInstance).collect(Collectors.toList());
        DomGlobal.console.log(new Object[]{"Registered " + this.functions.size() + " functions"});
    }

    public Optional<ExternalComponentFunction> findFunctionByName(String name) {
        return this.functions.stream().filter(f -> name.equals(f.getName())).findAny();
    }
}

