/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.external.model.ComponentParameter;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ExternalComponentService;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;

@Dependent
public class ExternalComponentPropertiesEditor
implements IsWidget {
    CommonConstants i18n = CommonConstants.INSTANCE;
    private static final String DEFAULT_CATEGORY = "Component Properties";
    @Inject
    View view;
    @Inject
    Caller<ExternalComponentService> externalComponentService;
    @Inject
    BusyIndicatorView loading;
    private ExternalComponent currentComp;
    Map<String, String> settings;
    Consumer<Map<String, String>> onPropertiesChange;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void init(String componentId, Map<String, String> settings, Consumer<Map<String, String>> onPropertiesChange) {
        this.settings = new HashMap<String, String>(settings);
        this.onPropertiesChange = onPropertiesChange;
        if (componentId == null) {
            this.view.componentNotFound();
        } else {
            this.loading.showBusyIndicator(this.i18n.loadingComponent());
            ((ExternalComponentService)this.externalComponentService.call(comp -> this.loadProperties((Optional<ExternalComponent>)comp))).byId(componentId);
        }
    }

    private void loadProperties(Optional<ExternalComponent> compOp) {
        this.loading.hideBusyIndicator();
        if (compOp.isPresent()) {
            this.currentComp = compOp.get();
            this.loadProperties();
        } else {
            this.view.componentNotFound();
        }
    }

    private void loadProperties() {
        List parameters = this.currentComp.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            this.view.noPropertiesComponent();
        } else {
            HashMap<String, PropertyEditorCategory> categories = new HashMap<String, PropertyEditorCategory>();
            categories.put(DEFAULT_CATEGORY, new PropertyEditorCategory(DEFAULT_CATEGORY));
            parameters.forEach(this::initializeSetting);
            this.notifyPropertyChange();
            for (ComponentParameter param : parameters) {
                PropertyEditorCategory category = (PropertyEditorCategory)categories.get(DEFAULT_CATEGORY);
                if (param.getCategory() != null) {
                    String catName = param.getCategory();
                    category = categories.computeIfAbsent(catName, PropertyEditorCategory::new);
                }
                category.withField(this.buildField(param));
            }
            this.view.addCategories(categories.values());
        }
    }

    public void onPropertyChange(String key, String value) {
        this.settings.put(key, value);
        this.notifyPropertyChange();
    }

    private void notifyPropertyChange() {
        if (this.onPropertiesChange != null) {
            this.onPropertiesChange.accept(this.settings);
        }
    }

    private PropertyEditorFieldInfo buildField(ComponentParameter p) {
        String fieldKey = p.getName();
        String currentValue = this.settings.get(fieldKey);
        PropertyEditorType type = this.getType(p.getType());
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo(p.getLabel(), p.getDefaultValue(), type);
        field.withKey(fieldKey);
        if (field.getType() == PropertyEditorType.COMBO) {
            field.withComboValues(p.getComboValues());
        }
        if (currentValue != null) {
            field.setCurrentStringValue(currentValue);
        }
        return field;
    }

    private PropertyEditorType getType(String type) {
        return Stream.of(PropertyEditorType.values()).filter(t -> t.name().equalsIgnoreCase(type)).findFirst().orElse(PropertyEditorType.TEXT);
    }

    private void initializeSetting(ComponentParameter p) {
        String componentProperty = this.settings.get(p.getName());
        if (componentProperty == null) {
            this.settings.put(p.getName(), p.getDefaultValue());
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void setExternalComponentService(Caller<ExternalComponentService> externalComponentService) {
        this.externalComponentService = externalComponentService;
    }

    public static interface View
    extends UberView<ExternalComponentPropertiesEditor> {
        public void componentNotFound();

        public void addCategories(Collection<PropertyEditorCategory> var1);

        public void noPropertiesComponent();
    }
}

