/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ExternalComponentPresenter {
    private static final String COMPONENT_SERVER_PATH = "dashbuilder/component";
    private static final String COMPONENT_RUNTIME_ID_PROP = "component_id";
    final String componentRuntimeId = DOM.createUniqueId();
    private Consumer<ExternalComponentMessage> messageConsumer;
    @Inject
    View view;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void withComponent(String componentId) {
        String url = this.buildUrl(componentId);
        this.view.setComponentURL(url);
    }

    public void withComponent(String componentId, String partition) {
        String url = this.buildUrl(componentId, partition);
        this.view.setComponentURL(url);
    }

    public void sendMessage(ExternalComponentMessage message) {
        message.setProperty(COMPONENT_RUNTIME_ID_PROP, (Object)this.componentRuntimeId);
        this.view.postMessage(message);
    }

    public void receiveMessage(ExternalComponentMessage message) {
        Object destinationId = message.getProperty(COMPONENT_RUNTIME_ID_PROP);
        if (!this.componentRuntimeId.equals(destinationId)) {
            return;
        }
        if (this.messageConsumer != null) {
            this.messageConsumer.accept(message);
        }
    }

    public View getView() {
        return this.view;
    }

    public void setMessageConsumer(Consumer<ExternalComponentMessage> messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    public String getComponentId() {
        return this.componentRuntimeId;
    }

    private String buildUrl(String componentId) {
        return this.buildUrl(componentId, "");
    }

    private String buildUrl(String componentId, String partition) {
        return String.join((CharSequence)"/", GWT.getHostPageBaseURL(), COMPONENT_SERVER_PATH, partition, componentId, "index.html");
    }

    public static interface View
    extends UberView<ExternalComponentPresenter> {
        public void setComponentURL(String var1);

        public void postMessage(ExternalComponentMessage var1);
    }
}

