/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.sourcecode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringTemplateBuilder;
import org.dashbuilder.displayer.client.resources.i18n.SourceCodeValidatorConstants;
import org.dashbuilder.displayer.client.widgets.sourcecode.JsEvaluator;
import org.dashbuilder.displayer.client.widgets.sourcecode.JsValidator;

@Dependent
public class DefaultJsValidator
implements JsValidator {
    public static final String[] _jsMalicious = new String[]{"document.", "window.", "eval(", "eval ", "eval\t", "eval\n", ".innerHTML"};
    protected JsEvaluator jsEvaluator;
    protected StringTemplateBuilder codeBuilder;
    protected StringTemplateBuilder restoreBuilder;
    Map<String, String> _variables;

    @Inject
    public DefaultJsValidator(JsEvaluator jsEvaluator) {
        this.jsEvaluator = jsEvaluator;
        this.codeBuilder = new StringTemplateBuilder();
        this.restoreBuilder = new StringTemplateBuilder("__", "__");
        this._variables = new HashMap<String, String>();
    }

    @Override
    public String validate(String jsTemplate, Collection<String> allowedVariables) {
        for (String keyword : _jsMalicious) {
            int idx = jsTemplate.toLowerCase().indexOf(keyword.toLowerCase());
            if (idx < 0) continue;
            int end = jsTemplate.indexOf("\n", idx);
            end = end != -1 && end - idx < 30 ? end : idx + 30;
            String expr = jsTemplate.substring(idx, end >= jsTemplate.length() ? jsTemplate.length() : end);
            return SourceCodeValidatorConstants.INSTANCE.js_keyword_not_allowed(expr);
        }
        try {
            this.codeBuilder.setTemplate(jsTemplate);
            for (String key : this.codeBuilder.keys()) {
                String var = this.codeBuilder.asVar(key);
                if (allowedVariables == null || allowedVariables.contains(var)) continue;
                return SourceCodeValidatorConstants.INSTANCE.js_variable_not_found(var);
            }
            String js = this.replaceVariables(jsTemplate);
            this.jsEvaluator.evaluate(js);
            js = this.isolateLines(js);
            this.jsEvaluator.evaluate(js);
            return null;
        }
        catch (Exception e) {
            String error = e.getMessage();
            return this.restoreVariables(error);
        }
    }

    public String replaceVariables(String code) {
        StringBuilder header = new StringBuilder();
        header.append("function __alert(msg) {};\n");
        this.codeBuilder.setTemplate(code.replace("alert", "__alert"));
        this._variables.clear();
        int idx = 0;
        for (String key : this.codeBuilder.keys()) {
            String var = "var" + idx++;
            this._variables.put(var, key);
            header.append("var __" + var + "__ = document.createElement(\"div\");\n");
            this.codeBuilder.replace(key, "__" + var + "__");
        }
        String body = this.codeBuilder.build();
        return header + body;
    }

    public String restoreVariables(String code) {
        this.restoreBuilder.setTemplate(code);
        for (String var : this._variables.keySet()) {
            this.restoreBuilder.replace(var, this.codeBuilder.getKeyPrefix() + this._variables.get(var) + this.codeBuilder.getKeySufix());
        }
        return this.restoreBuilder.build();
    }

    public String isolateLines(String code) {
        String[] lines;
        StringBuilder out = new StringBuilder();
        for (String line : lines = code.split("\n")) {
            String string = line = (line = line.trim()).contains("else ") ? line.replace("else ", "") : line;
            if (line.startsWith("{") && !line.endsWith("}") && this.occurrences(line, "{") > this.occurrences(line, "}")) {
                line = line.substring(1);
            }
            if (!line.startsWith("{") && line.endsWith("}") && this.occurrences(line, "{") < this.occurrences(line, "}")) {
                line = line.substring(0, line.length() - 1);
            }
            if (line.endsWith("{")) {
                line = line + "}";
            }
            if (line.startsWith("}")) {
                line = "{" + line;
            }
            if (line.equals("") || line.equals("{}") || line.equals("{};")) continue;
            out.append(line).append("\n");
        }
        return out.toString();
    }

    public int occurrences(String str, String target) {
        int idx = 0;
        int count = 0;
        while (idx != -1 && idx < str.length()) {
            if ((idx = str.indexOf(target, idx)) == -1) continue;
            ++count;
            idx += target.length();
        }
        return count;
    }
}

