/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.date.TimeInstant;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.FunctionParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeInstantEditor;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class TimeFrameEditor
implements FunctionParameterEditor {
    View view;
    SyncBeanManager beanManager;
    TimeFrame timeFrame = null;
    TimeInstantEditor fromEditor;
    TimeInstantEditor toEditor;
    Command onChangeCommand = new Command(){

        public void execute() {
        }
    };

    @Inject
    public TimeFrameEditor(View view, SyncBeanManager beanManager) {
        this.view = view;
        this.beanManager = beanManager;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public TimeInstantEditor getFromEditor() {
        return this.fromEditor;
    }

    public TimeInstantEditor getToEditor() {
        return this.toEditor;
    }

    public void init(TimeFrame tf, Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
        this.timeFrame = tf != null ? tf : TimeFrame.parse((String)"begin[year] till end[year]");
        this.fromEditor = (TimeInstantEditor)this.beanManager.lookupBean(TimeInstantEditor.class, new Annotation[0]).newInstance();
        this.fromEditor.init(this.timeFrame.getFrom(), new Command(){

            public void execute() {
                TimeFrameEditor.this.fromEditor.getTimeInstant().setFirstMonthOfYear(TimeFrameEditor.this.getFirstMonthOfYear());
                TimeFrameEditor.this.timeFrame.setFrom(TimeFrameEditor.this.fromEditor.getTimeInstant());
                TimeFrameEditor.this.changeFirstMonthAvailability();
                TimeFrameEditor.this.fireChanges();
            }
        });
        this.toEditor = (TimeInstantEditor)this.beanManager.lookupBean(TimeInstantEditor.class, new Annotation[0]).newInstance();
        this.toEditor.init(this.timeFrame.getTo(), new Command(){

            public void execute() {
                TimeFrameEditor.this.toEditor.getTimeInstant().setFirstMonthOfYear(TimeFrameEditor.this.getFirstMonthOfYear());
                TimeFrameEditor.this.timeFrame.setTo(TimeFrameEditor.this.toEditor.getTimeInstant());
                TimeFrameEditor.this.changeFirstMonthAvailability();
                TimeFrameEditor.this.fireChanges();
            }
        });
        this.view.init(this);
        this.initFirstMonthSelector();
        this.changeFirstMonthAvailability();
    }

    protected void initFirstMonthSelector() {
        this.view.clearFirstMonthSelector();
        Month current = this.getFirstMonthOfYear();
        Month[] entries = Month.values();
        for (int i = 0; i < entries.length; ++i) {
            Month entry = entries[i];
            this.view.addFirstMonthItem(entry);
            if (current == null || !current.equals((Object)entry)) continue;
            this.view.setSelectedFirstMonthIndex(i);
        }
    }

    protected void changeFirstMonthAvailability() {
        this.view.hideFirstMonthSelector();
        if (this.isFirstMonthAvailable()) {
            this.view.showFirstMonthSelector();
        }
    }

    public boolean isFirstMonthAvailable() {
        DateIntervalType intervalType;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return true;
        }
        TimeInstant instantTo = this.timeFrame.getTo();
        TimeInstant.TimeMode modeTo = instantTo.getTimeMode();
        return modeTo != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex();
    }

    public Month getFirstMonthOfYear() {
        DateIntervalType intervalType;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return instantFrom.getFirstMonthOfYear();
        }
        TimeInstant instantTo = this.timeFrame.getTo();
        TimeInstant.TimeMode modeTo = instantTo.getTimeMode();
        if (modeTo != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return instantTo.getFirstMonthOfYear();
        }
        return null;
    }

    public void setFirstMonthOfYear(Month month) {
        DateIntervalType intervalType;
        TimeInstant instantTo;
        TimeInstant.TimeMode modeTo;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            instantFrom.setFirstMonthOfYear(month);
        }
        if ((modeTo = (instantTo = this.timeFrame.getTo()).getTimeMode()) != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex()) {
            instantTo.setFirstMonthOfYear(month);
        }
    }

    @Override
    public void setFocus(boolean focus) {
    }

    public void changeFirstMonth() {
        int selectedIdx = this.view.getSelectedFirstMonthIndex();
        Month month = Month.getByIndex((int)(selectedIdx + 1));
        this.setFirstMonthOfYear(month);
        this.fireChanges();
    }

    protected void fireChanges() {
        this.onChangeCommand.execute();
    }

    public static interface View
    extends UberView<TimeFrameEditor> {
        public void hideFirstMonthSelector();

        public void showFirstMonthSelector();

        public void clearFirstMonthSelector();

        public void addFirstMonthItem(Month var1);

        public void setSelectedFirstMonthIndex(int var1);

        public int getSelectedFirstMonthIndex();
    }
}

