/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.resources.i18n.PositionConstants;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.LabelType;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@Dependent
public class DisplayerSettingsEditorView
extends Composite
implements DisplayerSettingsEditor.View {
    private static final Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Panel mainPanel;
    @UiField
    PropertyEditorWidget propertyEditor;
    DisplayerSettingsEditor presenter;
    List<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
    Map<DisplayerAttributeDef, String> attrMapI18n = new HashMap<DisplayerAttributeDef, String>();
    PropertyEditorCategory category = null;
    public static final String PROPERTY_EDITOR_ID = "displayerSettingsEditor";

    public void init(DisplayerSettingsEditor presenter) {
        this.presenter = presenter;
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP, CommonConstants.INSTANCE.common_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TITLE, CommonConstants.INSTANCE.common_title());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TITLE_VISIBLE, CommonConstants.INSTANCE.common_showTitle());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.ALLOW_EXPORT_CSV, CommonConstants.INSTANCE.common_allowCSV());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.ALLOW_EXPORT_EXCEL, CommonConstants.INSTANCE.common_allowExcel());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.EXPORT_GROUP, CommonConstants.INSTANCE.common_export());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.EXPORT_TO_CSV, CommonConstants.INSTANCE.common_allowCSV());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.EXPORT_TO_XLS, CommonConstants.INSTANCE.common_allowExcel());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.RENDERER, CommonConstants.INSTANCE.common_renderer());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_GROUP, CommonConstants.INSTANCE.chart_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_WIDTH, CommonConstants.INSTANCE.chart_width());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_HEIGHT, CommonConstants.INSTANCE.chart_height());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_BGCOLOR, CommonConstants.INSTANCE.chart_bgColor());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_3D, CommonConstants.INSTANCE.chart_3d());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP, CommonConstants.INSTANCE.chart_marginGroup());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_MARGIN_TOP, CommonConstants.INSTANCE.chart_topMargin());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_MARGIN_BOTTOM, CommonConstants.INSTANCE.chart_bottomMargin());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_MARGIN_LEFT, CommonConstants.INSTANCE.chart_leftMargin());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_MARGIN_RIGHT, CommonConstants.INSTANCE.chart_rightMargin());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP, CommonConstants.INSTANCE.chart_legendGroup());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_SHOWLEGEND, CommonConstants.INSTANCE.chart_legendShow());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.CHART_LEGENDPOSITION, CommonConstants.INSTANCE.chart_legendPosition());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.XAXIS_GROUP, CommonConstants.INSTANCE.axis_group());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.YAXIS_GROUP, CommonConstants.INSTANCE.axis_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.XAXIS_SHOWLABELS, CommonConstants.INSTANCE.xaxis_showLabels());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.XAXIS_TITLE, CommonConstants.INSTANCE.xaxis_title());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.XAXIS_LABELSANGLE, CommonConstants.INSTANCE.xaxis_angle());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.YAXIS_SHOWLABELS, CommonConstants.INSTANCE.yaxis_showLabels());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.YAXIS_TITLE, CommonConstants.INSTANCE.yaxis_title());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP, CommonConstants.INSTANCE.table_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_PAGESIZE, CommonConstants.INSTANCE.table_pageSize());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_WIDTH, CommonConstants.INSTANCE.table_width());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_SORTENABLED, CommonConstants.INSTANCE.table_sortEnabled());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_SORTCOLUMNID, CommonConstants.INSTANCE.table_sortColumn());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_SORTORDER, CommonConstants.INSTANCE.table_sortOrder());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.TABLE_COLUMN_PICKER_ENABLED, CommonConstants.INSTANCE.table_columnPicker());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP, CommonConstants.INSTANCE.meter_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.METER_START, CommonConstants.INSTANCE.meter_start());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.METER_WARNING, CommonConstants.INSTANCE.meter_warning());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.METER_CRITICAL, CommonConstants.INSTANCE.meter_critical());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.METER_END, CommonConstants.INSTANCE.meter_end());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP, CommonConstants.INSTANCE.filter_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.FILTER_ENABLED, CommonConstants.INSTANCE.filter_enabled());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.FILTER_SELFAPPLY_ENABLED, CommonConstants.INSTANCE.filter_self());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.FILTER_LISTENING_ENABLED, CommonConstants.INSTANCE.filter_listening());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.FILTER_NOTIFICATION_ENABLED, CommonConstants.INSTANCE.filter_notifications());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.SELECTOR_GROUP, CommonConstants.INSTANCE.selector_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.SELECTOR_WIDTH, CommonConstants.INSTANCE.selector_width());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.SELECTOR_MULTIPLE, CommonConstants.INSTANCE.selector_multiple());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.SELECTOR_SHOW_INPUTS, CommonConstants.INSTANCE.selector_show_inputs());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP, CommonConstants.INSTANCE.refresh_group());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.REFRESH_INTERVAL, CommonConstants.INSTANCE.refresh_interval());
        this.attrMapI18n.put(DisplayerAttributeGroupDef.REFRESH_STALE_DATA, CommonConstants.INSTANCE.refresh_stale_data());
        this.attrMapI18n.put((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP, CommonConstants.INSTANCE.common_columns());
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void clear() {
        this.categories.clear();
    }

    @Override
    public void show() {
        this.propertyEditor.handle(new PropertyEditorEvent(PROPERTY_EDITOR_ID, this.categories));
    }

    @Override
    public void dataSetNotFound() {
        this.mainPanel.add((Widget)new Label(LabelType.WARNING, CommonConstants.INSTANCE.error() + CommonConstants.INSTANCE.displayer_editor_dataset_notfound()));
    }

    @Override
    public void error(String message) {
        this.mainPanel.add((Widget)new Label(LabelType.WARNING, CommonConstants.INSTANCE.error() + message));
    }

    @Override
    public void addCategory(DisplayerAttributeDef attributeDef) {
        String catName = this.attrMapI18n.get(attributeDef);
        this.category = new PropertyEditorCategory(catName);
        this.categories.add(this.category);
    }

    @Override
    public void addTextProperty(DisplayerAttributeDef attributeDef, String value, PropertyFieldValidator ... validators) {
        String propName = this.attrMapI18n.get(attributeDef);
        this.category.withField(new PropertyEditorFieldInfo(propName, value, PropertyEditorType.TEXT).withValidators(validators).withKey(attributeDef.getFullId()));
    }

    @Override
    public void addTextProperty(String propId, String propName, String value, PropertyFieldValidator ... validators) {
        this.category.withField(new PropertyEditorFieldInfo(propName, value, PropertyEditorType.TEXT).withValidators(validators).withKey(propId));
    }

    @Override
    public void addBooleanProperty(DisplayerAttributeDef attributeDef, boolean value) {
        String propName = this.attrMapI18n.get(attributeDef);
        this.category.withField(new PropertyEditorFieldInfo(propName, Boolean.toString(value), PropertyEditorType.BOOLEAN).withKey(attributeDef.getFullId()));
    }

    @Override
    public void addColorProperty(DisplayerAttributeDef attributeDef, String color) {
        String propName = this.attrMapI18n.get(attributeDef);
        this.category.withField(new PropertyEditorFieldInfo(propName, color, PropertyEditorType.COLOR).withKey(attributeDef.getFullId()));
    }

    @Override
    public void addListProperty(DisplayerAttributeDef attributeDef, List<String> optionList, String selectedValue) {
        String propName = this.attrMapI18n.get(attributeDef);
        this.category.withField(new PropertyEditorFieldInfo(propName, selectedValue, PropertyEditorType.COMBO).withComboValues(optionList).withKey(attributeDef.getFullId()));
    }

    @Override
    public String getColumnNameI18n() {
        return CommonConstants.INSTANCE.columns_name();
    }

    @Override
    public String getColumnExpressionI18n() {
        return CommonConstants.INSTANCE.columns_expression();
    }

    @Override
    public String getColumnPatternI18n() {
        return CommonConstants.INSTANCE.columns_pattern();
    }

    @Override
    public String getPositionLiteralI18n(Position position) {
        return PositionConstants.INSTANCE.getString("POSITION_" + position.toString());
    }

    @Override
    public String getIntegerValidationFailedI18n() {
        return CommonConstants.INSTANCE.settings_validation_integer();
    }

    @Override
    public String getDoubleValidationFailedI18n() {
        return CommonConstants.INSTANCE.settings_validation_double();
    }

    @Override
    public String getMeterStartI18n() {
        return CommonConstants.INSTANCE.meter_start();
    }

    @Override
    public String getMeterWarningI18n() {
        return CommonConstants.INSTANCE.meter_warning();
    }

    @Override
    public String getMeterCriticalI18n() {
        return CommonConstants.INSTANCE.meter_critical();
    }

    @Override
    public String getMeterEndI18n() {
        return CommonConstants.INSTANCE.meter_end();
    }

    @Override
    public String getMeterUnknownI18n() {
        return CommonConstants.INSTANCE.settings_validation_meter_unknown();
    }

    @Override
    public String getMeterValidationHigherI18n(String level) {
        return CommonConstants.INSTANCE.settings_validation_meter_higher(level);
    }

    @Override
    public String getMeterValidationLowerI18n(String level) {
        return CommonConstants.INSTANCE.settings_validation_meter_lower(level);
    }

    @Override
    public String getMeterValidationInvalidI18n() {
        return CommonConstants.INSTANCE.settings_validation_meter_invalid();
    }

    protected void onPropertyEditorChange(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(PROPERTY_EDITOR_ID)) {
            String attrKey = property.getKey();
            String attrValue = event.getNewValue();
            this.presenter.onAttributeChanged(attrKey, attrValue);
        }
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerSettingsEditorView> {
    }
}

