/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;

@Dependent
public class DataSetLookupEditorView
extends Composite
implements DataSetLookupEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    DataSetLookupEditor presenter;
    @UiField
    ListBox dataSetListBox;
    @UiField
    Label statusLabel;
    @UiField
    Panel groupControlPanel;
    @UiField
    com.google.gwt.user.client.ui.Label groupControlLabel;
    @UiField
    Icon groupDetailsIcon;
    @UiField
    ListBox groupColumnListBox;
    @UiField
    Panel groupDatePanel;
    @UiField(provided=true)
    DataSetGroupDateEditor groupDateEditor;
    @UiField
    Panel columnsControlPanel;
    @UiField
    com.google.gwt.user.client.ui.Label columnsControlLabel;
    @UiField
    Panel columnsPanel;
    @UiField
    Button addColumnButton;
    @UiField
    Panel filtersControlPanel;
    @UiField(provided=true)
    DataSetFilterEditor filterEditor;
    boolean dataSetSelectorHintEnabled = false;
    boolean groupColumnSelectorHintEnabled = false;

    public void init(DataSetLookupEditor presenter) {
        this.presenter = presenter;
        this.filterEditor = presenter.getFilterEditor();
        this.groupDateEditor = presenter.getGroupDateEditor();
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.groupDetailsIcon.setType(IconType.ARROW_DOWN);
        this.groupDetailsIcon.addDomHandler((EventHandler)((ClickHandler)this::expandCollapseGroupDetails), ClickEvent.getType());
    }

    @Override
    public void clearAll() {
        this.setFilterEnabled(false);
        this.setGroupEnabled(false);
        this.setColumnsSectionEnabled(false);
        this.clearDataSetSelector();
        this.clearGroupColumnSelector();
        this.clearColumnList();
    }

    @Override
    public void clearDataSetSelector() {
        this.dataSetListBox.clear();
    }

    @Override
    public void enableDataSetSelectorHint() {
        this.dataSetListBox.addItem(CommonConstants.INSTANCE.common_dropdown_select());
        this.dataSetSelectorHintEnabled = true;
    }

    @Override
    public void addDataSetItem(String name, String id) {
        this.dataSetListBox.addItem(name, id);
    }

    @Override
    public void removeDataSetItem(int index) {
        this.dataSetListBox.removeItem(this.dataSetSelectorHintEnabled ? index + 1 : index);
    }

    @Override
    public void setSelectedDataSetIndex(int index) {
        this.dataSetListBox.setSelectedIndex(this.dataSetSelectorHintEnabled ? index + 1 : index);
    }

    @Override
    public String getSelectedDataSetId() {
        int idx = this.dataSetListBox.getSelectedIndex();
        if (this.dataSetSelectorHintEnabled && idx == 0) {
            return null;
        }
        return this.dataSetListBox.getValue(idx);
    }

    @Override
    public void errorDataSetNotFound(String dataSetUUID) {
        this.statusLabel.setVisible(true);
        this.statusLabel.setText(CommonConstants.INSTANCE.dataset_lookup_dataset_notfound(dataSetUUID));
    }

    @Override
    public void error(ClientRuntimeError e) {
        this.statusLabel.setVisible(true);
        this.statusLabel.setText(e.getCause());
        if (e.getThrowable() != null) {
            GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        } else {
            GWT.log((String)e.getMessage());
        }
    }

    @Override
    public void setFilterEnabled(boolean enabled) {
        this.filtersControlPanel.setVisible(enabled);
    }

    @Override
    public void setGroupEnabled(boolean enabled) {
        this.groupControlPanel.setVisible(enabled);
    }

    @Override
    public void clearGroupColumnSelector() {
        this.groupColumnListBox.clear();
    }

    @Override
    public void setGroupByDateEnabled(boolean enabled) {
        this.groupDetailsIcon.setVisible(enabled);
    }

    @Override
    public void setGroupColumnSelectorTitle(String title) {
        this.groupControlLabel.setText(title);
    }

    @Override
    public void enableGroupColumnSelectorHint() {
        this.groupColumnListBox.insertItem(CommonConstants.INSTANCE.dataset_lookup_group_columns_all(), 0);
        this.groupColumnSelectorHintEnabled = true;
    }

    @Override
    public void addGroupColumnItem(String column) {
        this.groupColumnListBox.addItem(column);
    }

    @Override
    public void setSelectedGroupColumnIndex(int index) {
        this.groupColumnListBox.setSelectedIndex(this.groupColumnSelectorHintEnabled ? index + 1 : index);
    }

    @Override
    public String getSelectedGroupColumnId() {
        int index = this.groupColumnListBox.getSelectedIndex();
        if (this.groupColumnSelectorHintEnabled && index == 0) {
            return null;
        }
        return this.groupColumnListBox.getValue(index);
    }

    @Override
    public void setColumnsSectionEnabled(boolean enabled) {
        this.columnsControlPanel.setVisible(enabled);
    }

    @Override
    public void clearColumnList() {
        this.columnsPanel.clear();
    }

    @Override
    public void setColumnSectionTitle(String title) {
        this.columnsControlLabel.setText(title);
    }

    @Override
    public void setAddColumnOptionEnabled(boolean enabled) {
        this.addColumnButton.setVisible(enabled);
    }

    @Override
    public void addColumnEditor(ColumnFunctionEditor editor) {
        this.columnsPanel.add((IsWidget)editor);
    }

    @Override
    public void removeColumnEditor(ColumnFunctionEditor editor) {
        this.columnsPanel.remove((IsWidget)editor);
    }

    @UiHandler(value={"dataSetListBox"})
    public void onDataSetSelected(ChangeEvent changeEvent) {
        this.presenter.onDataSetSelected();
    }

    @UiHandler(value={"addColumnButton"})
    public void onAddColumnClicked(ClickEvent clickEvent) {
        this.presenter.onAddColumn();
    }

    @UiHandler(value={"groupColumnListBox"})
    public void onGroupColumnChanged(ChangeEvent changeEvent) {
        this.presenter.onGroupColumnSelected();
    }

    public void expandCollapseGroupDetails(ClickEvent event) {
        if (this.groupDatePanel.isVisible()) {
            this.groupDatePanel.setVisible(false);
            this.groupDetailsIcon.setType(IconType.ARROW_DOWN);
        } else {
            this.groupDatePanel.setVisible(true);
            this.groupDetailsIcon.setType(IconType.ARROW_UP);
        }
    }

    static interface Binder
    extends UiBinder<Widget, DataSetLookupEditorView> {
    }
}

